/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.SkypeException;
import com.skype.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public final class Profile {
    Profile() {
    }

    public String getId() throws SkypeException {
        return Utils.getProperty("CURRENTUSERHANDLE");
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getProperty("USERSTATUS"));
    }

    public void setStatus(Status newStatus) throws SkypeException {
        Utils.setProperty("USERSTATUS", newStatus.toString());
    }

    public boolean canDoSkypeOut() throws SkypeException {
        return this.canDo("SKYPEOUT");
    }

    public boolean canDoSkypeIn() throws SkypeException {
        return this.canDo("SKYPEIN");
    }

    public boolean canDoVoiceMail() throws SkypeException {
        return this.canDo("VOICEMAIL");
    }

    private boolean canDo(String name) throws SkypeException {
        return Boolean.parseBoolean(Utils.getProperty("PRIVILEGE", name));
    }

    public int getPSTNBalance() throws SkypeException {
        return Integer.parseInt(this.getProperty("PSTN_BALANCE"));
    }

    public String getPSTNBalanceCurrencyUnit() throws SkypeException {
        return this.getProperty("PSTN_BALANCE_CURRENCY");
    }

    public String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public void setFullName(String newValue) throws SkypeException {
        this.setProperty("FULLNAME", newValue);
    }

    public Date getBirthDay() throws SkypeException {
        String value = this.getProperty("BIRTHDAY");
        if ("0".equals(value)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("library developer should check Skype specification.");
        }
    }

    public void setBirthDay(Date newValue) throws SkypeException {
        String newValueString = newValue == null ? "0" : new SimpleDateFormat("yyyyMMdd").format(newValue);
        this.setProperty("BIRTHDAY", newValueString);
    }

    public Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProperty("SEX"));
    }

    public void setSex(Sex newValue) throws SkypeException {
        this.setProperty("SEX", newValue.toString());
    }

    public String[] getAllLauguages() throws SkypeException {
        return this.getProperty("LANGUAGES").split(" ");
    }

    public void setAllLanguages(String[] newValues) throws SkypeException {
        if (newValues == null) {
            newValues = new String[]{};
        }
        this.setProperty("LANGUAGES", this.toSpaceSeparatedString(newValues));
    }

    private String toSpaceSeparatedString(Object[] newValues) {
        StringBuilder newValuesString = new StringBuilder();
        Object[] objectArray = newValues;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object newValue = objectArray[n];
            newValuesString.append(newValue);
            ++n;
        }
        return newValuesString.toString();
    }

    public String getCountryByISOCode() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        return value.substring(0, value.indexOf(32));
    }

    public void setCountryByISOCode(String newValue) throws SkypeException {
        if (newValue == null) {
            newValue = "";
        }
        this.setProperty("COUNTRY", String.valueOf(newValue) + " " + this.getCountry());
    }

    public String getCountry() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        return value.substring(value.indexOf(32) + 1);
    }

    public void setCountry(String newValue) throws SkypeException {
        if (newValue == null) {
            newValue = "";
        }
        this.setProperty("COUNTRY", String.valueOf(this.getCountryByISOCode()) + " " + newValue);
    }

    public String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public void setProvince(String newValue) throws SkypeException {
        this.setProperty("PROVINCE", newValue);
    }

    public String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    public void setCity(String newValue) throws SkypeException {
        this.setProperty("CITY", newValue);
    }

    public String getHomePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    public void setHomePhoneNumber(String newValue) throws SkypeException {
        this.setProperty("PHONE_HOME", newValue);
    }

    public String getOfficePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    public void setOfficePhoneNumber(String newValue) throws SkypeException {
        this.setProperty("PHONE_OFFICE", newValue);
    }

    public String getMobilePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public void setMobilePhoneNumber(String newValue) throws SkypeException {
        this.setProperty("PHONE_MOBILE", newValue);
    }

    public String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    public void setHomePageAddress(String newValue) throws SkypeException {
        this.setProperty("HOMEPAGE", newValue);
    }

    public String getIntroduction() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public void setIntroduction(String newValue) throws SkypeException {
        this.setProperty("ABOUT", newValue);
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProperty("MOOD_TEXT");
    }

    public void setMoodMessage(String newValue) throws SkypeException {
        this.setProperty("MOOD_TEXT", newValue);
    }

    public int getTimeZone() throws SkypeException {
        return Integer.parseInt(this.getProperty("TIMEZONE"));
    }

    public void setTimeZone(int newValue) throws SkypeException {
        this.setProperty("TIMEZONE", "" + newValue);
    }

    public boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_VIDEO_CAPABLE"));
    }

    public int getWaitTimeBeforeCallForwarding() throws SkypeException {
        return Integer.parseInt(this.getProperty("CALL_NOANSWER_TIMEOUT"));
    }

    public void setWaitTimeBeforeCallForwarding(int newValue) throws SkypeException {
        this.setProperty("CALL_NOANSWER_TIMEOUT", "" + newValue);
    }

    public boolean isCallForwarding() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("CALL_APPLY_CF"));
    }

    public void setCallForwarding(boolean on) throws SkypeException {
        this.setProperty("CALL_APPLY_CF", ("" + on).toUpperCase());
    }

    public CallForwardingRule[] getAllCallForwardingRules() throws SkypeException {
        ArrayList<CallForwardingRule> rules = new ArrayList<CallForwardingRule>();
        String value = this.getProperty("CALL_FORWARD_RULES");
        if ("".equals(value)) {
            return new CallForwardingRule[0];
        }
        String[] stringArray = value.split(" ");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String rule = stringArray[n];
            String[] elements = rule.split(",");
            rules.add(new CallForwardingRule(Integer.parseInt(elements[0]), Integer.parseInt(elements[1]), elements[2]));
            ++n;
        }
        return rules.toArray(new CallForwardingRule[0]);
    }

    public void setAllCallForwardingRules(CallForwardingRule[] newValues) throws SkypeException {
        this.setProperty("CALL_FORWARD_RULES", this.toSpaceSeparatedString(newValues));
    }

    String[] getAllValidSMSNumbers() throws SkypeException {
        return Utils.convertToArray(this.getProperty("SMS_VALIDATED_NUMBERS"));
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("PROFILE", name);
    }

    private void setProperty(String name, String value) throws SkypeException {
        Utils.setProperty("PROFILE", name, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        ONLINE,
        OFFLINE,
        SKYPEME,
        AWAY,
        NA,
        DND,
        INVISIBLE,
        LOGGEDOUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    public static final class CallForwardingRule {
        private final int startSecond;
        private final int endSecond;
        private final String target;

        public CallForwardingRule(int newStartSecond, int newEndSecond, String newTarget) {
            this.startSecond = newStartSecond;
            this.endSecond = newEndSecond;
            if (newTarget.startsWith("+")) {
                newTarget = newTarget.replaceAll("-", "");
            }
            this.target = newTarget;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object compared) {
            if (compared instanceof CallForwardingRule) {
                return this.toString().equals(((Profile)compared).toString());
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.startSecond) + "," + this.endSecond + "," + this.target;
        }

        public int getStartSecond() {
            return this.startSecond;
        }

        public int getEndSecond() {
            return this.endSecond;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

