/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector;

import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import com.skype.connector.ConnectorStatusEvent;
import com.skype.connector.ConnectorUtils;
import com.skype.connector.MessageProcessor;
import com.skype.connector.NotAttachedException;
import com.skype.connector.TimeOutException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.EventListenerList;

public abstract class Connector {
    private static boolean useJNIConnector;
    private static Connector instance;
    private PrintWriter debugOut = new PrintWriter(System.out, true);
    private ConnectorListener debugListener;
    private Object debugFieldMutex = new Object();
    private String applicationName = "SkypeAPI4Java";
    private Status status = Status.NOT_RUNNING;
    private boolean isInitialized;
    private int connectTimeout = 10000;
    private int commandTimeout = 10000;
    private EventListenerList listeners = new EventListenerList();
    private int commandCount;
    private ExecutorService executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger();

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "SkypeMessageSender-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    public static synchronized void useJNIConnector(boolean on) {
        if (instance != null) {
            throw new IllegalStateException("You should call this method before calling Connector#getInstance().");
        }
        useJNIConnector = on;
    }

    private static boolean isSWTAvailable() {
        try {
            Class.forName("org.eclipse.swt.SWT");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static synchronized Connector getInstance() {
        if (instance == null) {
            String osName = System.getProperty("os.name");
            String connectorClassName = null;
            if (!useJNIConnector && !Connector.isSWTAvailable()) {
                useJNIConnector = true;
            }
            if (osName.startsWith("Windows")) {
                connectorClassName = useJNIConnector ? "com.skype.connector.win32.Win32Connector" : "com.skype.connector.windows.WindowsConnector";
            } else if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
                connectorClassName = "com.skype.connector.linux.LinuxConnector";
            } else if (osName.startsWith("Mac OS X")) {
                connectorClassName = "com.skype.connector.osx.OSXConnector";
            }
            if (connectorClassName == null) {
                throw new IllegalStateException("This platform is not supported by Skype API for Java.");
            }
            try {
                Class<?> connectorClass = Class.forName(connectorClassName);
                Method getInstance = connectorClass.getMethod("getInstance", new Class[0]);
                instance = (Connector)getInstance.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("The connector couldn't be initialized.", e);
            }
        }
        return instance;
    }

    protected static synchronized void setInstance(Connector newInstance) throws ConnectorException {
        if (instance != null) {
            instance.dispose();
        }
        instance = newInstance;
    }

    protected Connector() {
    }

    public String getInstalledPath() {
        return "skype";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDebug(boolean on) throws ConnectorException {
        Object object = this.debugFieldMutex;
        synchronized (object) {
            if (on) {
                if (this.debugListener == null) {
                    this.debugListener = new AbstractConnectorListener(){

                        public void messageReceived(ConnectorMessageEvent event) {
                            Connector.this.getDebugOut().println("<- " + event.getMessage());
                        }

                        public void messageSent(ConnectorMessageEvent event) {
                            Connector.this.getDebugOut().println("-> " + event.getMessage());
                        }
                    };
                    this.addConnectorListener(this.debugListener);
                }
            } else if (this.debugListener != null) {
                this.removeConnectorListener(this.debugListener);
            }
        }
    }

    public final void setDebugOut(PrintWriter newDebugOut) {
        ConnectorUtils.checkNotNull("debugOut", newDebugOut);
        this.debugOut = newDebugOut;
    }

    public final void setDebugOut(PrintStream newDebugOut) {
        ConnectorUtils.checkNotNull("debugOut", newDebugOut);
        this.setDebugOut(new PrintWriter(newDebugOut, true));
    }

    public final PrintWriter getDebugOut() {
        return this.debugOut;
    }

    public final void setApplicationName(String newApplicationName) {
        ConnectorUtils.checkNotNull("applicationName", newApplicationName);
        this.applicationName = newApplicationName;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    protected final void setStatus(Status newValue) {
        this.status = newValue;
        this.fireStatusChanged(newValue);
    }

    public final Status getStatus() {
        return this.status;
    }

    public final void setConnectTimeout(int newValue) {
        this.connectTimeout = newValue;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setCommandTimeout(int newValue) {
        this.commandTimeout = newValue;
    }

    public final int getCommandTimeout() {
        return this.commandTimeout;
    }

    public final synchronized Status connect() throws ConnectorException {
        Status tmpStatus;
        int timeout = this.getConnectTimeout();
        if (!this.isInitialized) {
            this.initialize(timeout);
            this.isInitialized = true;
        }
        if ((tmpStatus = this.connect(timeout)) == Status.ATTACHED) {
            try {
                this.sendApplicationName(this.getApplicationName());
                this.execute("PROTOCOL 9999", new String[]{"PROTOCOL "}, false);
            }
            catch (TimeOutException timeOutException) {
                tmpStatus = Status.NOT_RUNNING;
            }
        }
        return tmpStatus;
    }

    protected abstract void initialize(int var1) throws ConnectorException;

    protected abstract Status connect(int var1) throws ConnectorException;

    protected abstract void disposeImpl();

    protected void sendApplicationName(String newApplicationName) throws ConnectorException {
    }

    public final synchronized void dispose() throws ConnectorException {
        if (!this.isInitialized) {
            return;
        }
        this.disposeImpl();
        this.isInitialized = false;
    }

    public final boolean isRunning() throws ConnectorException {
        try {
            this.assureAttached();
            return true;
        }
        catch (TimeOutException timeOutException) {
            return false;
        }
        catch (NotAttachedException notAttachedException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void execute(String command, final MessageProcessor processor) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("processor", processor);
        this.assureAttached();
        Object lock = new Object();
        AbstractConnectorListener listener = new AbstractConnectorListener(){

            public void messageReceived(ConnectorMessageEvent event) {
                processor.messageReceived(event.getMessage());
            }
        };
        processor.init(lock, listener);
        this.addConnectorListener(listener, false);
        this.fireMessageSent(command);
        Object object = lock;
        synchronized (object) {
            try {
                try {
                    this.sendCommand(command);
                    long start = System.currentTimeMillis();
                    long commandResponseTime = this.getCommandTimeout();
                    lock.wait(commandResponseTime);
                    if (commandResponseTime <= System.currentTimeMillis() - start) {
                        this.setStatus(Status.NOT_RUNNING);
                        throw new TimeOutException("The '" + command + "' command failed by timeout.");
                    }
                }
                catch (InterruptedException e) {
                    throw new ConnectorException("The '" + command + "' command was interrupted.", e);
                }
            }
            finally {
                this.removeConnectorListener(listener);
            }
        }
    }

    public final String execute(String command) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        return this.execute(command, command);
    }

    public final String executeWithId(String command, String responseHeader) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeader", responseHeader);
        String header = "#" + this.commandCount++ + " ";
        String response = this.execute(String.valueOf(header) + command, new String[]{String.valueOf(header) + responseHeader, String.valueOf(header) + "ERROR "}, true);
        return response.substring(header.length());
    }

    public final String execute(String command, String responseHeader) throws ConnectorException {
        ConnectorUtils.checkNotNull("responseHeader", responseHeader);
        return this.execute(command, new String[]{responseHeader, "ERROR "}, true);
    }

    public final String execute(String command, String[] responseHeaders) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeaders", responseHeaders);
        return this.execute(command, responseHeaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String execute(String command, final String[] responseHeaders, boolean checkAttached) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", command);
        ConnectorUtils.checkNotNull("responseHeaders", responseHeaders);
        if (checkAttached) {
            this.assureAttached();
        }
        final Object lock = new Object();
        final String[] response = new String[1];
        AbstractConnectorListener listener = new AbstractConnectorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageReceived(ConnectorMessageEvent event) {
                String message = event.getMessage();
                String[] stringArray = responseHeaders;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String responseHeader = stringArray[n];
                    if (message.startsWith(responseHeader)) {
                        response[0] = message;
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                        return;
                    }
                    ++n;
                }
            }
        };
        this.addConnectorListener(listener, false);
        this.fireMessageSent(command);
        Object object = lock;
        synchronized (object) {
            try {
                try {
                    this.sendCommand(command);
                    long start = System.currentTimeMillis();
                    long commandResponseTime = this.getCommandTimeout();
                    lock.wait(commandResponseTime);
                    if (commandResponseTime <= System.currentTimeMillis() - start) {
                        this.setStatus(Status.NOT_RUNNING);
                        throw new TimeOutException("The '" + command + "' command failed by timeout.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ConnectorException("The '" + command + "' command was interrupted.");
                }
            }
            finally {
                this.removeConnectorListener(listener);
            }
        }
        return response[0];
    }

    private void fireMessageSent(String message) {
        assert (message != null);
        ConnectorListener[] fireListeners = (ConnectorListener[])this.listeners.getListeners(ConnectorListener.class);
        if (fireListeners.length == 0) {
            return;
        }
        ConnectorMessageEvent event = new ConnectorMessageEvent(this, message);
        ConnectorListener[] connectorListenerArray = fireListeners;
        int n = 0;
        int n2 = connectorListenerArray.length;
        while (n < n2) {
            ConnectorListener listener = connectorListenerArray[n];
            listener.messageSent(event);
            ++n;
        }
    }

    protected abstract void sendCommand(String var1);

    private void assureAttached() throws ConnectorException {
        Status attachedStatus = this.getStatus();
        if (attachedStatus != Status.ATTACHED && (attachedStatus = this.connect()) != Status.ATTACHED) {
            throw new NotAttachedException(attachedStatus);
        }
    }

    public final void addConnectorListener(ConnectorListener listener) throws ConnectorException {
        this.addConnectorListener(listener, true);
    }

    public final void addConnectorListener(ConnectorListener listener, boolean checkAttached) throws ConnectorException {
        ConnectorUtils.checkNotNull("listener", listener);
        this.listeners.add(ConnectorListener.class, listener);
        if (checkAttached) {
            this.assureAttached();
        }
    }

    public final void removeConnectorListener(ConnectorListener listener) {
        ConnectorUtils.checkNotNull("listener", listener);
        this.listeners.remove(ConnectorListener.class, listener);
    }

    protected final void fireMessageReceived(final String message) {
        ConnectorUtils.checkNotNull("message", message);
        this.executor.execute(new Runnable(){

            public void run() {
                ConnectorListener[] fireListeners = (ConnectorListener[])Connector.this.listeners.getListeners(ConnectorListener.class);
                if (fireListeners.length == 0) {
                    return;
                }
                ConnectorMessageEvent event = new ConnectorMessageEvent(this, message);
                int i = fireListeners.length - 1;
                while (i >= 0) {
                    fireListeners[i].messageReceived(event);
                    --i;
                }
            }
        });
    }

    protected final void fireStatusChanged(final Status newStatus) {
        ConnectorUtils.checkNotNull("status", (Object)newStatus);
        this.executor.execute(new Runnable(){

            public void run() {
                ConnectorListener[] fireListeners = (ConnectorListener[])Connector.this.listeners.getListeners(ConnectorListener.class);
                if (fireListeners.length == 0) {
                    return;
                }
                ConnectorStatusEvent event = new ConnectorStatusEvent(this, newStatus);
                int i = fireListeners.length - 1;
                while (i >= 0) {
                    fireListeners[i].statusChanged(event);
                    --i;
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PENDING_AUTHORIZATION,
        ATTACHED,
        REFUSED,
        NOT_AVAILABLE,
        API_AVAILABLE,
        NOT_RUNNING;

    }
}

