/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Call;
import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.Utils;
import com.skype.VoiceMail;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class User
extends SkypeObject {
    private static final Map<String, User> users = new HashMap<String, User>();
    private String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static User getInstance(String id) {
        Map<String, User> map = users;
        synchronized (map) {
            if (!users.containsKey(id)) {
                users.put(id, new User(id));
            }
            return users.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Friend getFriendInstance(String id) {
        Map<String, User> map = users;
        synchronized (map) {
            if (!users.containsKey(id)) {
                Friend friend = new Friend(id);
                users.put(id, friend);
                return friend;
            }
            User user = users.get(id);
            if (user instanceof Friend) {
                return (Friend)user;
            }
            Friend friend = new Friend(id);
            friend.copyFrom(user);
            users.put(id, friend);
            return friend;
        }
    }

    User(String newId) {
        this.id = newId;
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean equals(Object compared) {
        if (compared instanceof User) {
            User comparedUser = (User)compared;
            return this.getId().equals(comparedUser.getId());
        }
        return false;
    }

    public final String toString() {
        return this.getId();
    }

    public final String getId() {
        return this.id;
    }

    public final String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public final Date getBirthDay() throws SkypeException {
        String value = this.getProperty("BIRTHDAY");
        if ("0".equals(value)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(value);
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("library developer should check Skype specification.");
        }
    }

    public final Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProperty("SEX"));
    }

    public final Status getOnlineStatus() throws SkypeException {
        return Status.valueOf(this.getProperty("ONLINESTATUS"));
    }

    public final String getLauguage() throws SkypeException {
        return this.getProperty("LANGUAGE");
    }

    public final String getCountry() throws SkypeException {
        return this.getProperty("COUNTRY");
    }

    public final String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public final String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    public final String getHomePhone() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    public final String getOfficePhone() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    public final String getMobilePhone() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public final String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    public final String getAbout() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProperty("MOOD_TEXT");
    }

    public final String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public final boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_VIDEO_CAPABLE"));
    }

    public final boolean isAuthorized() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("ISAUTHORIZED"));
    }

    public final void setAuthorized(boolean authorized) throws SkypeException {
        if (authorized) {
            this.getProperty("ISAUTHORIZED TRUE");
        } else {
            this.getProperty("ISAUTHORIZED FALSE");
        }
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("USER", this.getId(), name);
    }

    public final Call call() throws SkypeException {
        return Skype.call(this.getId());
    }

    public final Chat chat() throws SkypeException {
        return Skype.chat(this.getId());
    }

    public final ChatMessage send(String message) throws SkypeException {
        return Skype.chat(this.getId()).send(message);
    }

    public final VoiceMail voiceMail() throws SkypeException {
        return Skype.voiceMail(this.getId());
    }

    public final void setDisplayName(String displayName) throws SkypeException {
        Utils.setProperty("USER", this.getId(), "DISPLAYNAME", displayName);
    }

    public final ChatMessage[] getAllChatMessages() throws SkypeException {
        String[] ids = this.getHistory("CHATMESSAGES");
        ChatMessage[] messages = new ChatMessage[ids.length];
        int i = 0;
        while (i < ids.length) {
            messages[i] = ChatMessage.getInstance(ids[i]);
            ++i;
        }
        List<ChatMessage> messageList = Arrays.asList(messages);
        Collections.reverse(messageList);
        return messageList.toArray(new ChatMessage[0]);
    }

    public final Call[] getAllCalls() throws SkypeException {
        String[] ids = this.getHistory("CALLS");
        Call[] calls = new Call[ids.length];
        int i = 0;
        while (i < ids.length) {
            calls[i] = Call.getInstance(ids[i]);
            ++i;
        }
        return calls;
    }

    private String[] getHistory(String type) throws SkypeException {
        try {
            String responseHeader = String.valueOf(type) + " ";
            String response = Connector.getInstance().execute("SEARCH " + type + " " + this.getId(), responseHeader);
            Utils.checkError(response);
            String data = response.substring(responseHeader.length());
            return Utils.convertToArray(data);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    final void dispose() {
        users.remove(this.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        OFFLINE,
        ONLINE,
        AWAY,
        NA,
        DND,
        SKYPEOUT,
        SKYPEME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }
}

