/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.ApplicationAdapter;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.Stream;
import com.skype.StreamAdapter;
import com.skype.TestData;
import junit.framework.TestCase;

public final class Ap2ApAPIStressTest
extends TestCase {
    static final String APPLICATION_NAME = Ap2ApAPIStressTest.class.getName();

    public void testWriteOnMultiThread() throws Exception {
        Skype.setDebug(true);
        Application application = Skype.addApplication(APPLICATION_NAME);
        Friend friend = TestData.getFriend();
        try {
            Stream[] streams = application.connect(friend);
            Ap2ApAPIStressTest.assertEquals((int)1, (int)streams.length);
            Stream stream = streams[0];
            this.checkConnectedFriends(application, friend);
            this.checkWriteOnMultiThread(stream);
            this.checkDisconnect(application, stream);
        }
        finally {
            application.finish();
        }
    }

    private void checkConnectedFriends(Application application, Friend friend) throws SkypeException {
        Friend[] connectableFriends = application.getAllConnectedFriends();
        Ap2ApAPIStressTest.assertEquals((int)1, (int)connectableFriends.length);
        Ap2ApAPIStressTest.assertEquals((Object)friend, (Object)connectableFriends[0]);
    }

    private void checkWriteOnMultiThread(final Stream stream) throws SkypeException {
        Thread[] threads = new Thread[20];
        final String[] results = new String[threads.length];
        int i = 0;
        while (i < threads.length) {
            final int index = i;
            Thread thread = new Thread("write-" + index){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        final Object lock = new Object();
                        stream.addStreamListener(new StreamAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void textReceived(String text) throws SkypeException {
                                results[index] = text;
                                Object object = lock;
                                synchronized (object) {
                                    lock.notify();
                                }
                            }
                        });
                        Object object = lock;
                        synchronized (object) {
                            stream.write("Hello, World!");
                            try {
                                lock.wait(10000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (SkypeException skypeException) {}
                }
            };
            thread.start();
            threads[i] = thread;
            ++i;
        }
        Object[] objectArray = threads;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Thread thread = objectArray[n];
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            ++n;
        }
        objectArray = results;
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Object result = objectArray[n];
            Ap2ApAPIStressTest.assertEquals((String)"Hello, World!", (String)result);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDisconnect(Application application, Stream stream) throws Exception {
        final Object lock = new Object();
        final boolean[] result = new boolean[1];
        application.addApplicationListener(new ApplicationAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void disconnected(Stream stream) throws SkypeException {
                result[0] = true;
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            stream.write("disconnect");
            try {
                lock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                Ap2ApAPIStressTest.fail();
            }
        }
        Ap2ApAPIStressTest.assertTrue((boolean)result[0]);
    }
}

