/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.osx;

import com.skype.connector.Connector;

public class OSXConnector
extends Connector
implements Runnable {
    private static OSXConnector _instance = null;
    private static final Object lock = new Object();
    private boolean inited = false;

    private OSXConnector() {
        try {
            System.loadLibrary("JSA");
        }
        catch (Exception e) {
            this.setStatus(Connector.Status.NOT_AVAILABLE);
            this.fireMessageReceived("ConnectorStatusChanged");
        }
    }

    public static synchronized OSXConnector getInstance() {
        System.out.println("OSXConnector.getInstance()");
        if (_instance == null) {
            _instance = new OSXConnector();
        }
        return _instance;
    }

    protected void sendCommand(String command) {
        System.out.println("OSXConnector.sendCommand(" + command + ") start");
        this.sendSkypeMessage(command);
        System.out.println("OSXConnector.sendCommand(" + command + ") end");
    }

    protected void disposeImpl() {
        System.out.println("OSXConnector.disposeImpl() start");
        OSXConnector.setConnectedStatus(5);
        this.disposeNative();
        _instance = null;
        System.out.println("OSXConnector.disposeImpl() end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connector.Status connectImpl(int timeout) {
        System.out.println("OSXConnector.connectImpl(" + timeout + ") start");
        if (this.getStatus() == Connector.Status.PENDING_AUTHORIZATION) {
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("OSXConnector.connectImpl(" + timeout + ") end");
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(int timeout) {
        System.out.println("OSXConnector.initialize(" + timeout + ") start ***************");
        if (!this.inited) {
            this.inited = true;
            new Thread(this).start();
            this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
            this.fireMessageReceived("ConnectorStatusChanged");
            this.setDebugPrinting(true);
            this.init(this.getApplicationName());
        }
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("OSXConnector.initialize(" + timeout + ") end ***************");
    }

    public static synchronized void receiveSkypeMessage(final String message) {
        System.out.println("OSXConnector.receiveSkypeMessage(" + message + ") start");
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (_instance.getStatus() != Connector.Status.ATTACHED) {
                    OSXConnector.setConnectedStatus(1);
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                }
                _instance.fireMessageReceived(message);
            }
        }.start();
        System.out.println("OSXConnector.receiveSkypeMessage(" + message + ") end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectedStatus(int status) {
        System.out.println("OSXConnector.setConnectedStatus(" + status + ") start");
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
        switch (status) {
            case 0: {
                _instance.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                break;
            }
            case 1: {
                _instance.setStatus(Connector.Status.ATTACHED);
                break;
            }
            case 2: {
                _instance.setStatus(Connector.Status.REFUSED);
                break;
            }
            case 3: {
                _instance.setStatus(Connector.Status.NOT_AVAILABLE);
                break;
            }
            case 4: {
                _instance.setStatus(Connector.Status.API_AVAILABLE);
                break;
            }
            case 5: {
                _instance.setStatus(Connector.Status.NOT_RUNNING);
                break;
            }
            default: {
                _instance.setStatus(Connector.Status.NOT_RUNNING);
            }
        }
        _instance.fireMessageReceived("ConnectorStatusChanged");
        System.out.println("OSXConnector.setConnectedStatus(" + status + ") end");
    }

    public void run() {
        this.startEventLoop();
    }

    private synchronized native void init(String var1);

    private native void startEventLoop();

    private native void sendSkypeMessage(String var1);

    private native void disposeNative();

    private native void setDebugPrinting(boolean var1);
}

