/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.VoiceMail;
import com.skype.VoiceMailStatusChangedListener;
import com.skype.connector.test.TestCaseByCSVFile;
import java.util.ArrayList;

public class AutoVoiceMailAPITest
extends TestCaseByCSVFile {
    protected void setUp() throws Exception {
        this.setRecordingMode(false);
    }

    public void testGetAllVoiceMails() throws Exception {
        VoiceMail[] voiceMails = Skype.getAllVoiceMails();
        String result = this.toString(voiceMails);
        if (this.isRecordingMode()) {
            System.out.println(result);
        } else {
            AutoVoiceMailAPITest.assertEquals((String)"65, 70, 71", (String)result);
        }
    }

    private String toString(VoiceMail[] voiceMails) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int length = voiceMails.length;
        while (i < length) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(voiceMails[i].getId());
            ++i;
        }
        return builder.toString();
    }

    public void testVoiceMail() throws Exception {
        VoiceMail voiceMail = Skype.voiceMail("echo123");
        String result = String.valueOf(voiceMail.getId()) + ", " + (Object)((Object)voiceMail.getType()) + ", " + voiceMail.getPartnerId() + ", " + voiceMail.getPartnerDisplayName() + ", " + voiceMail.getStartTime().getTime() + ", " + voiceMail.getDuration() + ", " + voiceMail.getAllowedDuration();
        if (this.isRecordingMode()) {
            System.out.println(result);
        } else {
            AutoVoiceMailAPITest.assertEquals((String)"2346, OUTGOING, echo123, Skype Test Call, 1156016035000, 0, 600", (String)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVoiceMailStatusChangedListener() throws Exception {
        VoiceMail voiceMail = Skype.voiceMail("echo123");
        final ArrayList statuses = new ArrayList();
        final Object wait = new Object();
        voiceMail.addVoiceMailStatusChangedListener(new VoiceMailStatusChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void statusChanged(VoiceMail.Status status) throws SkypeException {
                statuses.add(status);
                if (status == VoiceMail.Status.UPLOADED) {
                    Object object = wait;
                    synchronized (object) {
                        wait.notify();
                    }
                }
            }
        });
        Object object = wait;
        synchronized (object) {
            wait.wait();
        }
        String result = ((Object)statuses).toString();
        if (this.isRecordingMode()) {
            System.out.println(result);
        } else {
            AutoVoiceMailAPITest.assertEquals((String)"[BLANK, RECORDING, UPLOADING, UPLOADED]", (String)result);
        }
    }
}

