#include "AfxWin.h"
#include <stdio.h>
#include <locale.h>
#include "skkinput.h"
#include "dispatch.h"
#if defined (SUPPORT_KINPUT)
#include "KinputServer.h"
#endif
#if defined (SUPPORT_XIM)
#include "XIMServer.h"
#endif
#include "kanji.h"

/*========================================================================*
 *	ץȥ
 *========================================================================*/
static	Boolean	skkinputApp_initInstance		(int*, char*[]) ;
static	Boolean	skkinputApp_exitInstance		(void) ;
static	Boolean	skkinputApp_mainLoop			(void) ;
static	Boolean	skkinputApp_initLispMgr			(void) ;
static	void	skkinputApp_onProtocolDestroy	(Widget, XtPointer, XtPointer) ;
static	int		skkinputApp_onXIoError			(Display*) ;
static	void	skkinputApp_showUsage			(int*, char*[]) ;

/*========================================================================*
 *	Хѿ
 *========================================================================*/
static SkkinputApp	theApp ;

#if !defined (XtNlispMachine)
#define	XtNlispMachine			"lispMachine"
#endif

typedef struct {
#if defined (SUPPORT_KINPUT)
	Boolean		m_fUseKinputProtocol ;
#endif
#if defined (SUPPORT_XIM)
	Boolean		m_fUseXIMProtocol ;
#endif
	String		m_strServerHost ;
	int			m_nPortNum ;
	String		m_strConfigPath ;
}	SkkinputAppResRec ;

static SkkinputAppResRec	theAppRes ;

#define	offset(field)	XtOffsetOf(SkkinputAppResRec,field)

static XtResource		rresSkkinputApp []	= {
#if defined (SUPPORT_KINPUT)
	{ "useKinputProtocol",	"UseKinputProtocol",	XtRBoolean,
	  sizeof (Boolean),		offset (m_fUseKinputProtocol),
	  XtRImmediate,			(XtPointer) True, },
#endif
#if defined (SUPPORT_XIM)
	{ "useXIMProtocol",		"UseXIMProtocol",		XtRBoolean,
	  sizeof (Boolean),		offset (m_fUseXIMProtocol),
	  XtRImmediate,			(XtPointer) True, },
#endif
	{ "serverHost",			"SkkserverHost",		XtRString,
	  sizeof (String),		offset (m_strServerHost),
	  XtRImmediate,			(XtPointer)"", },
	{ "portnum",			"Portnum",				XtRInt,
	  sizeof (int),			offset (m_nPortNum),
	  XtRImmediate,			(XtPointer)-1, },
	{ "configPath",			"ConfigPath",			XtRString,
	  sizeof (String),		offset (m_strConfigPath),
	  XtRImmediate,			(XtPointer) ELISP_DIR, },
} ;

#undef	offset

static XrmOptionDescRec	roptDescSkkinputApp [] = {
#if defined (SUPPORT_KINPUT)
	{ "-kinput",	".useKinputProtocol",	XrmoptionNoArg,		"True", },
	{ "+kinput",	".useKinputProtocol",	XrmoptionNoArg,		"False", },
#endif
#if defined (SUPPORT_XIM)
	{ "-xim",		".useXIMProtocol",		XrmoptionNoArg,		"True", },
	{ "+xim",		".useXIMProtocol",		XrmoptionNoArg,		"False", },
#endif
	{ "-server",	".serverHost",			XrmoptionSepArg,	NULL, },
	{ "-portnum",	".portnum",				XrmoptionSepArg,	NULL, },
	{ "-config",	".configPath",			XrmoptionSepArg,	NULL, },
	{ "-fontset",	"*fontSet",				XrmoptionSepArg,	NULL, },
	{ "-rv",		"*reverseVideo",		XrmoptionNoArg,		"True", },
	{ "+rv",		"*reverseVideo",		XrmoptionNoArg,		"False", },
	{ "-fg",		"*foreground",			XrmoptionSepArg,	NULL, },
	{ "-bg",		"*background",			XrmoptionSepArg,	NULL, },
	{ "-bd",		"*borderColor",			XrmoptionSepArg,	NULL, },
} ;

int
main (int iArgc, char* pArgv [])
{
	setlocale (LC_ALL, "japanese") ;

	if (!skkinputApp_initInstance (&iArgc, pArgv))
		return	1 ;

	if (theApp.m_nProtocol > 0)
		skkinputApp_mainLoop () ;
	skkinputApp_exitInstance () ;
	return	0 ;
}

#if defined (DEBUG)
TLispManager*
skkinputApp_GetLispMgr (void)
{
	return	theApp.m_pLispMgr ;
}
#endif

/*========================================================================*
 *	ؿ
 *========================================================================*/
Boolean
skkinputApp_initInstance (
	register int*	pnArgc,
	register char*	pArgv [])
{
	/*register TEditorClient*	pClient ;*/
	register Widget		wgToplevel, wgKinputProtocol, wgXIMProtocol ;
	Arg					rArg [8] ;
	register int		nArg, nArgc ;

	theApp.m_nProtocol	= 0 ;

	wgToplevel	= XtAppInitialize (&theApp.m_appContext, "Skkinput", roptDescSkkinputApp, XtNumber (roptDescSkkinputApp), pnArgc, pArgv, NULL, NULL, (Cardinal) 0) ;
	nArgc	= *pnArgc ;
	if (nArgc > 1) {
		skkinputApp_showUsage (pnArgc, pArgv) ;
		return	False ;
	}
	if (wgToplevel == NULL)
		return	False ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged,	False) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNwidth,				1) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNheight,				1) ;	nArg ++ ;
	XtSetValues (wgToplevel, rArg, nArg) ;

	XtGetApplicationResources (wgToplevel, &theAppRes, rresSkkinputApp, XtNumber (rresSkkinputApp), NULL, 0) ;

	/*	lisp manager ν*/
	if (TFAILED (skkinputApp_initLispMgr ()))
		return	False ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNlispMachine,			theApp.m_pLM) ;	nArg ++ ;

#if defined (SUPPORT_KINPUT)
    /* Kinput Protocol Ѥ뤿νԤ*/
	if (theAppRes.m_fUseKinputProtocol) {
		wgKinputProtocol	= XtCreateManagedWidget ("kinput2", kinputServerWidgetClass, wgToplevel, rArg, nArg) ;
		if (wgKinputProtocol != NULL) {
			XtAddCallback (wgKinputProtocol, XtNdestroyCallback, skkinputApp_onProtocolDestroy, 0) ;
			theApp.m_nProtocol	++ ;
		}
	}
#endif
#if defined (SUPPORT_XIM)
	/*	XIMProtocol ¦ν*/
	if (theAppRes.m_fUseXIMProtocol) {
		wgXIMProtocol		= XtCreateManagedWidget ("xim", ximServerWidgetClass, wgToplevel, rArg, nArg) ;
		if (wgXIMProtocol != NULL) {
			XtAddCallback (wgXIMProtocol, XtNdestroyCallback, skkinputApp_onProtocolDestroy, 0) ;
			theApp.m_nProtocol	++ ;
		}
	}
#endif
	if (theApp.m_nProtocol <= 0) {
		fprintf (stderr, "No protocol server is available.\n") ;
		return	False ;
	}

	AfxWinInitialize (wgToplevel) ;
	XtRealizeWidget (wgToplevel) ;
	return	True ;
}

Boolean
skkinputApp_exitInstance (void)
{
    XtDestroyApplicationContext (theApp.m_appContext) ;
	return	True ;
}

Boolean
skkinputApp_mainLoop (void)
{
	register int	(*pOrgHandler)(Display*, XErrorEvent*) ;
	register int	(*pOrgIOHandler)(Display*) ;

	pOrgHandler		= XSetErrorHandler   (AfxHandleXError) ;
	pOrgIOHandler	= XSetIOErrorHandler (skkinputApp_onXIoError) ;
	TLispClient_MainLoop (theApp.m_appContext, theApp.m_pLM) ;
	TLispClient_ClassFinalize (theApp.m_pLM) ;
	(void) XSetIOErrorHandler (pOrgIOHandler) ;
	(void) XSetErrorHandler (pOrgHandler) ;
	return	True ;
}

Boolean
skkinputApp_initLispMgr (void)
{
	if (TFAILED (TLispClient_ClassInitialize (&theApp.m_pLispMgr, &theApp.m_pLM, theAppRes.m_strConfigPath, theAppRes.m_strServerHost, theAppRes.m_nPortNum))) {
		fprintf (stderr, "skkinput: failed: initialize lisp manager.\n") ;
		return	False ;
	}
	return	True ;
}

void
skkinputApp_onProtocolDestroy (
	register Widget		gw,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	theApp.m_nProtocol	-- ;
	if (theApp.m_nProtocol <= 0) 
		XtAppSetExitFlag (theApp.m_appContext) ;
#if defined (DEBUG)
	fprintf (stderr, "theApp.m_nProtocol = %d\n", theApp.m_nProtocol) ;
#endif
	return ;
}

/*	X IO Error Υϥɥ顣
 */
int
skkinputApp_onXIoError (
	register Display*	pDisplay)
{
#if defined (DEBUG)
	fprintf (stderr, "skkinputApp_onXIoError (%p)\n", pDisplay) ;
#endif
	if (theApp.m_pLispMgr != NULL &&
		theApp.m_pLM != NULL) {
		TLispClient_ClassFinalize (theApp.m_pLM) ;
	}
	exit (0) ;
}

void
skkinputApp_showUsage (
	register int*		pnArgc,
	register char*		pArgv [])
{
	register int	i, nArgc ;

	nArgc	= *pnArgc ;
	for (i = 1 ; i < nArgc ; i ++) {
		if (strcmp (pArgv [i], "-v") && strcmp (pArgv [i], "-version")) 
			fprintf (stderr, "Unknown option: %s\n", pArgv [i]) ;
	}
	fprintf (stderr, "skkinput version 3.0_1\n") ;
	fprintf (stderr, "[usage]\n") ;
	fprintf (stderr, " -v, -version:  show version\n") ;
#if defined (SUPPORT_KINPUT)
	fprintf (stderr, " -/+kinput:     enable/disable kinput protocol server\n") ;
#endif
#if defined (SUPPORT_XIM)
	fprintf (stderr, " -/+xim:        enable/disable XIM protocol server\n") ;
#endif
	fprintf (stderr, " -server:       specify skk-server-host\n") ;
	fprintf (stderr, " -portnum:      specify skk-portnum\n") ;
	fprintf (stderr, " -config:       specify load-path (default:%s)\n", ELISP_DIR) ;
	fprintf (stderr, " -fontset:      specify default fontset\n") ;
	fprintf (stderr, " -fg:           specify default foreground pixel\n") ;
	fprintf (stderr, " -bg:           specify default background pixel\n") ;
	fprintf (stderr, " -bd:           specify default border pixel\n") ;
	fprintf (stderr, " -/+rv:         enable/disable reverse video\n") ;
	return ;
}

