#if !defined (tfontset_h)
#define	tfontset_h

#include <X11/Xlib.h>
#include "TFont.h"

#define	TFONTSET_MAX_NAMES	(64)

struct tagTFontSet {
	int			m_iAscent ;
	int			m_iHeight ;
	int			m_iAvgWidth ;
	TFont*		m_af [MAX_CHARSET] ;
} ;

typedef struct tagTFontSet TFontSet ;

void		TFontSet_Initialize	(TFontSet*) ;
Boolean		TFontSet_Load		(Display*, TFontSet*, const char*, Boolean) ;
Boolean		TFontSet_LoadAtom	(Display*, TFontSet*, int, Atom*, Boolean) ;
void		TFontSet_Clear		(TFontSet*) ;
void		TFontSet_Destroy	(TFontSet*) ;
void		TFontSet_Copy		(TFontSet*, const TFontSet*) ;
int			TFontSet_GetAscent	(TFontSet*) ;
int			TFontSet_GetHeight	(TFontSet*) ;
int			TFontSet_GetDescent	(TFontSet*) ;
TFont*		TFontSet_GetFont	(TFontSet*, int) ;
void		TFontSet_Show		(TFontSet*) ;
void		TFontSet_Adjust		(Display*, TFontSet*, int) ;

#endif

