#include "AfxWin.h"
#include <stdlib.h>
#include "TFontP.h"

/*========================================================================*
 *	ץȥ
 *========================================================================*/

static	TFont*	TFont_alloc				(void) ;
static	TFont*	TFont_searchCachedFont	(const char*) ;
static	void	TFont_register			(TFont*) ;
static	Boolean	TFont_unregister		(TFont*) ;

/*========================================================================*
 *	Хѿ
 *========================================================================*/

static	TFont*	spCachedFontListTop	= NULL ;

/*========================================================================*
 *	Хؿ
 *========================================================================*/

TFont*
TFont_Load (
	register Display*		pDisplay,
	register const char*	pFontName)
{
	register TFont*	pFont ;

	assert (pDisplay != NULL) ;
	assert (pFontName != NULL) ;

	pFont	= TFont_searchCachedFont (pFontName) ;
	if (pFont == NULL) {
		pFont			= TFont_alloc () ;
		assert (pFont != NULL) ;
		pFont->m_pFont	= XLoadQueryFont (pDisplay, pFontName) ;
		assert (pFont->m_pFont != NULL) ;
		TVarbuffer_Add (&pFont->m_vbName, pFontName, strlen (pFontName) + 1) ;
		TFont_register (pFont) ;
	}
	pFont->m_iRefer	++ ;

	return	pFont ;
}

TFont*
TFont_Clone (
	register TFont*	pFont)
{
	pFont->m_iRefer	++ ;
	return	pFont ;
}

void
TFont_Unload (
	register TFont*	pFont)
{
	pFont->m_iRefer	-- ;
	return ;
}

XFontStruct*
TFont_GetFontStruct (
	register TFont*	pFont)
{
	assert (pFont != NULL) ;

	return	pFont->m_pFont ;
}

Font
TFont_GetFont (
	register TFont*	pFont)
{
	assert (pFont != NULL) ;
	assert (pFont->m_pFont != NULL) ;

	return	pFont->m_pFont->fid ;
}

/*========================================================================*
 *	ؿ
 *========================================================================*/

TFont*
TFont_alloc (void)
{
	register TFont*	pFont ;

	pFont			= MALLOC (sizeof (TFont)) ;
	pFont->m_pFont	= NULL ;
	pFont->m_iRefer	= 0 ;
	pFont->m_pNext	= NULL ;
	TVarbuffer_Initialize (&pFont->m_vbName, sizeof (char)) ;

	return	pFont ;
}

TFont*
TFont_searchCachedFont (
	register const char*	pFontName)
{
	register TFont*	pFont ;

	pFont	= spCachedFontListTop ;
	while (pFont != NULL) {
		if (strcmp (TVarbuffer_GetBuffer (&pFont->m_vbName), pFontName) == 0)
			return	pFont ;
		pFont	= pFont->m_pNext ;
	}

	return	NULL ;
}

void
TFont_register (
	register TFont*	pFont)
{
	pFont->m_pNext		= spCachedFontListTop ;
	spCachedFontListTop	= pFont ;
	return ;
}

Boolean
TFont_unregister (
	register TFont*	pFont)
{
	TFont*	pPrevFont ;
	TFont*	pCurFont ;

	pPrevFont	= NULL ;
	pCurFont	= spCachedFontListTop ;
	while (pCurFont != NULL) {
		if (pCurFont == pFont)
			break ;
		pPrevFont	= pCurFont ;
		pCurFont	= pCurFont->m_pNext ;
	}

	if (pCurFont == NULL)
		return	FALSE ;

	if (pPrevFont != NULL) {
		pPrevFont->m_pNext	= pCurFont->m_pNext ;
	} else {
		spCachedFontListTop	= pCurFont->m_pNext ;
	}
	pCurFont->m_pNext	= NULL ;
	return	TRUE ;
}

