#if !defined (TSubWindowFrameP_h)
#define	TSubWindowFrameP_h

#include "TFrameP.h"
#include "TSubWindowFrame.h"
#include "varbuffer.h"
#include "TFontSet.h"

typedef struct tagTSubWindowFrameTerminalTextControl {
	int						m_nTextPos ;
	int						m_nText ;
	Boolean					m_fRev ;
	Boolean					m_fFinish ;
}	TSubWindowFrameTerminalTextControl ;

typedef struct tagTSubWindowFrameTerminal {
	TVarbuffer				m_vbufText ;	/* $BJ8;zNs$rNs5s!#(B*/
	TVarbuffer				m_vbufControl ;	/* $B@)8f%3!<%I!#(B*/
	int						m_nCursor ;		/* $B8=:_$N%+!<%=%k0LCV!#(B*/
	Boolean					m_fRev ;		/* ReverseVideo $B$+H]$+!#(B*/
	int						m_nLine ;
}	TSubWindowFrameTerminal ;

typedef struct tagTSubWindowFramePart {
	Window					m_wndClient ;
	Window					m_wndFocus ;
	Pixel					m_pxlForeground ;
	XtCallbackList			m_lstCbkConfigure ;
	XtCallbackList			m_lstCbkDestroy ;
	Boolean					m_fDestroy ;

	Window					m_wndTerminal ;
	GC						m_gcTerminal ;
	TFontSet				m_fsTerminal ;
	int						m_nLineSpacing ;
	TSubWindowFrameTerminal	m_Terminal ;
}	TSubWindowFramePart ;

typedef struct tagTSubWindowFrameRec {
	CorePart				core ;
	CompositePart			composite ;
	ShellPart				shell ;
	TFramePart				tframe ;
	TSubWindowFramePart		tsubwin ;
}	TSubWindowFrameRec ;

typedef struct {
	int						dummy ;
}	TSubWindowFrameClassPart ;

typedef struct tagTSubWindowFrameClassRec {
	CoreClassPart			core_class ;
	CompositeClassPart		composite_class ;
	ShellClassPart			shell_class ;
	TFrameClassPart			tframe_class ;
	TSubWindowFrameClassPart	tsubframe_class ;
}	TSubWindowFrameClassRec ;

extern TSubWindowFrameClassRec	tsubWindowFrameClassRec ;

#endif
