#include "AfxWin.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "TSubWindowFrameP.h"
#include "TTerminal.h"
#include "TConvAttr.h"
#include "dispatch.h"
#include "ttext.h"

#define offset(field)	XtOffsetOf(TSubWindowFrameRec, tsubwin.field)
#define goffset(field)	XtOffsetOf(WidgetRec, core.field )

static	XtResource	srSubWindowFrameResource []	= {
	{	XtNwidth,		XtCWidth,		XtRDimension,	sizeof (Dimension),
		goffset (width),			XtRImmediate,	(XtPointer) 640, },
	{	XtNheight,		XtCHeight,		XtRDimension,	sizeof (Dimension),
		goffset (height),			XtRImmediate,	(XtPointer) 48, },
	{	XtNbackground,	XtCBackground,	XtRPixel,		sizeof (Pixel),
		goffset (background_pixel),	XtRString,		XtDefaultBackground, },
	{	XtNforeground,	XtCForeground,	XtRPixel,		sizeof (Pixel),
		offset (m_pxlForeground),	XtRString,		XtDefaultForeground, },
	{	XtNconfigureCallback,	XtCCallback,	XtRCallback,	sizeof (XtCallbackList),
		offset (m_lstCbkConfigure),	XtRCallback,	(XtPointer) NULL, },
	{	XtNdestroyCallback,		XtCCallback,	XtRCallback,	sizeof (XtCallbackList),
		offset (m_lstCbkDestroy),	XtRCallback,	(XtPointer) NULL, },
	{	XtNclientWindow,			XtCClientWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndClient),		XtRImmediate,		(XtPointer) None, },
	{	XtNfocusWindow,				XtCFocusWindow,
		XtRWindow,					sizeof (Window),
		offset (m_wndFocus),		XtRImmediate,		(XtPointer) None, },
} ;

#undef	offset
#undef	goffset

static	void	tsubWindowFrame_onInitialize(Widget, Widget, ArgList, Cardinal*) ;
static	void	tsubWindowFrame_onRealize	(Widget, XtValueMask*, XSetWindowAttributes*) ;
static	Boolean	tsubWindowFrame_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static	void	tsubWindowFrame_onDestroy	(Widget) ;

static	Boolean	tsubWindowFrame_createTerminal	(Widget, Window) ;
static	void*	tsubWindowFrame_getclient		(Widget) ;
static	int		tsubWindowFrame_getrect			(Widget, XRectangle*) ;
static	void	tsubWindowFrame_activate		(Widget, Boolean) ;
static	void*	tsubWindowFrame_getfontset		(Widget) ;
static	Boolean	tsubWindowFrame_getlinespacing	(Widget, int*) ;
static	void*	tsubWindowFrame_getlispframeobject(Widget) ;
static	void	tsubWindowFrame_setattribute	(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetAttributeFocusWindow	(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetPreeditAttribute		(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetPAttributeClientArea	(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetPAttributeFont			(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetPAttributeLineSpacing	(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetPAttributeColormap		(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetPAttributeBackground	(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetPAttributeForeground	(Widget, const TConversionAttribute*) ;
static	Boolean	tsubWindowFrame_onSetStatusAttribute		(Widget, const TConversionAttribute*) ;

static	Boolean	tsubWindowFrame_putchar			(Widget, const Char) ;
static	Boolean	tsubWindowFrame_puts			(Widget, const Char*, int) ;
static	void	tsubWindowFrame_rev				(Widget, Boolean) ;
static	void	tsubWindowFrame_clear			(Widget) ;
static	void	tsubWindowFrame_flush			(Widget) ;
static	Boolean	tsubWindowFrame_rectVariablep	(Widget) ;
static	Boolean	tsubWindowFrame_haveExternModelinep(Widget) ;
static	Boolean	tsubWindowFrame_setModeline		(Widget, const Char*, int) ;
static	Boolean	tsubWindowFrame_autoPopupp		(Widget) ;

static	int		tsubWindowFrame_onTerminalDestroy	(void*, XEvent*) ;
static	int		tsubWindowFrame_onTerminalConfigure	(void*, XEvent*) ;
static	int		tsubWindowFrame_onTerminalExpose 	(void*, XEvent*) ;

static	XtActionsRec	srSubWindowFrameAction []	= {
} ;

static	char			strSubWindowFrameTranslation []	= "" ;

TSubWindowFrameClassRec		tsubWindowFrameClassRec	= {
    {	/* core fields */
		/* superclass			*/	(WidgetClass) &tframeClassRec,
		/* class_name			*/	"TSubWindowFrame",
		/* size					*/	sizeof (TSubWindowFrameRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	tsubWindowFrame_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	tsubWindowFrame_onRealize,
		/* actions				*/	srSubWindowFrameAction,
		/* num_actions			*/	XtNumber (srSubWindowFrameAction),
		/* resources			*/	srSubWindowFrameResource,
		/* num_resources		*/	XtNumber(srSubWindowFrameResource),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	tsubWindowFrame_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	tsubWindowFrame_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	strSubWindowFrameTranslation,
		/* query_geometry		*/	XtInheritQueryGeometry,
		/* display_accelerator	*/	NULL,
		/* extension	  		*/	NULL,
    },
	{	/* Composite			*/
		/* geometry_manager		*/	XtInheritGeometryManager,
		/* change_managed		*/	XtInheritChangeManaged,
		/* insert_child			*/	XtInheritInsertChild,
		/* delete_child			*/	XtInheritDeleteChild,
		/* extension			*/	NULL,
	},
	{	/* Shell				*/
		/* extension			*/	NULL,
	},
	{	/* Frame				*/
		/* getclient			*/	tsubWindowFrame_getclient,
		/* getlispframeobject	*/	tsubWindowFrame_getlispframeobject,
		/* setattribute			*/	tsubWindowFrame_setattribute,
		/* getrect				*/	tsubWindowFrame_getrect,
		/* activate				*/	tsubWindowFrame_activate,
		/* getfontset			*/	tsubWindowFrame_getfontset,
		/* getlinespacing		*/	tsubWindowFrame_getlinespacing,
		/* putchar				*/	tsubWindowFrame_puts,
		/* putchar				*/	tsubWindowFrame_putchar,
		/* rev					*/	tsubWindowFrame_rev,
		/* clear				*/	tsubWindowFrame_clear,
		/* flush				*/	tsubWindowFrame_flush,
		/* rectvariablep		*/	tsubWindowFrame_rectVariablep,
		/* haveExternModelinep	*/	tsubWindowFrame_haveExternModelinep,
		/* setModeline			*/	tsubWindowFrame_setModeline,
		/* destroy				*/	tsubWindowFrame_autoPopupp,
		/* setCaret				*/	NULL,
	},
	{
		/* dummy				*/	0,
	},
} ;

WidgetClass	tsubWindowFrameWidgetClass	= (WidgetClass) &tsubWindowFrameClassRec ;

void
tsubWindowFrame_onInitialize (
	Widget		wgRequest,
	Widget		wgNew,
	ArgList		args,
	Cardinal*	num_args)
{
	register TSubWindowFrameWidget	wgThis = (TSubWindowFrameWidget) wgNew ;
	register TSubWindowFrameTerminal*	pTerminal ;

	wgThis->tsubwin.m_wndTerminal	= None ;
	wgThis->tsubwin.m_gcTerminal	= None ;
	TFontSet_Initialize (&wgThis->tsubwin.m_fsTerminal) ;

	pTerminal	= &wgThis->tsubwin.m_Terminal ;
	TVarbuffer_Initialize (&pTerminal->m_vbufText,    sizeof (Char)) ;
	TVarbuffer_Initialize (&pTerminal->m_vbufControl, sizeof (TSubWindowFrameTerminalTextControl)) ;
	pTerminal->m_fRev		= False ;
	pTerminal->m_nCursor	= 0 ;
	pTerminal->m_nLine		= 0 ;

	wgThis->tsubwin.m_fDestroy		= False ;
	wgThis->tsubwin.m_nLineSpacing	= 0 ;
	return ;
}

void
tsubWindowFrame_onRealize (
	register Widget					gw,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;
	register CoreWidgetClass	super	= (CoreWidgetClass) XtClass (gw)->core_class.superclass ;
	register Window				wndFocus ;

	(*super->core_class.realize) (gw, pValueMask, pXSWA) ;

	if (wgThis->tsubwin.m_wndClient == None) {
		XtDestroyWidget (gw) ;
		return ;
	}
	if (wgThis->tsubwin.m_wndFocus == None) 
		wgThis->tsubwin.m_wndFocus	= wgThis->tsubwin.m_wndClient ;
	wndFocus	= wgThis->tsubwin.m_wndFocus ;

	if (!tsubWindowFrame_createTerminal (gw, wndFocus)) 
		XtDestroyWidget (gw) ;
	return ;
}

Boolean
tsubWindowFrame_onSetValues (
	register Widget		curw,
	register Widget		reqw,
	register Widget		neww,
	register ArgList	args,
	register Cardinal*	num_args)
{
	return	False ;
}

void
tsubWindowFrame_onDestroy (
	register Widget	gw)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;
	register Display*			pDisplay	= XtDisplay (gw) ;
	register TSubWindowFrameTerminal*	pTerminal ;
	register Window				wndTerminal ;

	if (!wgThis->tsubwin.m_fDestroy) {
		wgThis->tsubwin.m_fDestroy	= True ;
		XtCallCallbacks ((Widget) wgThis, XtNdestroyCallback, (XtPointer) 0) ;
	}
	wndTerminal	= wgThis->tsubwin.m_wndTerminal ;
	if (wndTerminal != None) {
		AfxUnregisterWindow (wndTerminal, Expose, ExposureMask, gw, tsubWindowFrame_onTerminalExpose) ;
		AfxUnregisterWindow (wndTerminal, DestroyNotify, StructureNotifyMask, gw, tsubWindowFrame_onTerminalDestroy) ;
		AfxUnregisterWindow (wndTerminal, ConfigureNotify, StructureNotifyMask, gw, tsubWindowFrame_onTerminalConfigure) ;
		XDestroyWindow (pDisplay, wndTerminal) ;
		wgThis->tsubwin.m_wndTerminal	= None ;
	}
	if (wgThis->tsubwin.m_gcTerminal != None) {
		XFreeGC (pDisplay, wgThis->tsubwin.m_gcTerminal) ;
		wgThis->tsubwin.m_gcTerminal	= None ;
	}
	TFontSet_Destroy (&wgThis->tsubwin.m_fsTerminal) ;

	pTerminal	= &wgThis->tsubwin.m_Terminal ;
	TVarbuffer_Uninitialize (&pTerminal->m_vbufText) ;
	TVarbuffer_Uninitialize (&pTerminal->m_vbufControl) ;
	return ;
}

Boolean
tsubWindowFrame_createTerminal (
	register Widget			gw,
	register Window			wndFocus)
{
	register TSubWindowFrameWidget	wgThis = (TSubWindowFrameWidget) gw ;
	register Display*			pDisplay ;
	register Window				wndTerminal ;
	register unsigned long		lMask ;
	XSetWindowAttributes		xsa ;
	register GC					gc ;

	pDisplay				= XtDisplay (gw) ;
	lMask					= CWOverrideRedirect | CWBackPixel | CWBorderPixel ;
	xsa.override_redirect	= True ;
	xsa.background_pixel	= gw->core.background_pixel ;
	xsa.border_pixel		= gw->core.border_pixel ;
	wndTerminal				= XCreateWindow (pDisplay, wndFocus, gw->core.x, gw->core.y, gw->core.width, gw->core.height, 0, CopyFromParent, CopyFromParent, CopyFromParent, lMask, &xsa) ;
	if (wndTerminal == None) 
		return	False ;
	
	/*	Focus  Resize 򸫤ơWindow  size ȤǤϤ
	 *	ΤFocus ΥƱ礭Žդ櫓ǤϤʤΤǡ
	 *	Բǽ(礬¸櫓Ǥ)
	 */
	AfxRegisterWindow (pDisplay, wndTerminal, Expose, ExposureMask, gw, tsubWindowFrame_onTerminalExpose) ;
	AfxRegisterWindow (pDisplay, wndTerminal, DestroyNotify, StructureNotifyMask, gw, tsubWindowFrame_onTerminalDestroy) ;
	AfxRegisterWindow (pDisplay, wndTerminal, ConfigureNotify, StructureNotifyMask, gw, tsubWindowFrame_onTerminalConfigure) ;
	wgThis->tsubwin.m_wndTerminal	= wndTerminal ;

	gc	= XCreateGC (pDisplay, wndTerminal, 0, NULL) ;
	if (gc == None) 
		return	False ;
	wgThis->tsubwin.m_gcTerminal	= gc ;
#if 0
	rc.x		= 0 ;
	rc.y		= 0 ;
	rc.width	= gw->core.width ;
	rc.height	= gw->core.height ;
	XtCallCallbacks ((Widget) wgThis, XtNconfigureCallback, (XtPointer) &rc) ;
#endif
	XMapWindow (pDisplay, wndTerminal) ;
	return	True ;
}

/*	ƤӽФ Method
 */

/*	ƥԽʬɽ롣
 */
void
TSubWindowFrame_Popup (
	register Widget	gw)
{
	TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	assert (wgThis->tsubwin.m_wndTerminal != None) ;
	XMapWindow (XtDisplay (gw), wgThis->tsubwin.m_wndTerminal) ;
	return ;
}

/*	ƥԽʬɽˤ롣
 */
void
TSubWindowFrame_Popdown (
	register Widget	gw)
{
	TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	assert (wgThis->tsubwin.m_wndTerminal != None) ;
	XUnmapWindow (XtDisplay (gw), wgThis->tsubwin.m_wndTerminal) ;
	return ;
}

/*	private functions
 */
void*
tsubWindowFrame_getclient (
	register Widget	gw)
{
	TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	return	wgThis->tframe.m_pClient ;
}

int
tsubWindowFrame_getrect (
	register Widget			gw,
	register XRectangle*	pRect)
{
	TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	if (pRect != NULL) {
		pRect->x		= 0 ;
		pRect->y		= 0 ;
		pRect->width	= wgThis->core.width ;
		pRect->height	= wgThis->core.height ;
#if defined (DEBUG)
		fprintf (stderr, "GetRect: (%d, %d, %d, %d)\n", 
				 pRect->x, pRect->y, pRect->width, pRect->height) ;
#endif
	}
	return	1 ;
}

void
tsubWindowFrame_activate (
	register Widget			gw,
	register Boolean		fActivate)
{
	if (fActivate) {
		TSubWindowFrame_Popup (gw) ;
	} else {
		TSubWindowFrame_Popdown (gw) ;
	}
	return ;
}

void*
tsubWindowFrame_getfontset (
	register Widget			gw)
{
	TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	return	&wgThis->tsubwin.m_fsTerminal ;
}

Boolean
tsubWindowFrame_getlinespacing (
	register Widget			gw,
	register int*			pnLineSpacing)
{
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	if (wgThis->tsubwin.m_nLineSpacing > 0) {
		*pnLineSpacing	= wgThis->tsubwin.m_nLineSpacing ;
		return	True ;
	} else {
		*pnLineSpacing	= TFontSet_GetHeight (&wgThis->tsubwin.m_fsTerminal) ;
		return	False ;
	}
}

void*
tsubWindowFrame_getlispframeobject (
	register Widget			gw)
{
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	return	wgThis->tframe.m_pLispFrameObject ;
}

void
tsubWindowFrame_setattribute	(
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	static Boolean	(*rpSetAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		tsubWindowFrame_onSetAttributeFocusWindow,
		tsubWindowFrame_onSetPreeditAttribute,
		tsubWindowFrame_onSetStatusAttribute,
	} ;
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;
	register int			i ;
	register unsigned int	uMask ;
	register Boolean		fReconf ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	if (wgThis->tsubwin.m_fDestroy)
		return ;
	
	uMask	= 1 << CAFocusWindowBit ;
	fReconf	= False ;
	for (i = 0 ; i <= (CAStatusMaskBit - CAFocusWindowBit) ; i ++) {
		if (IS_CONVATTR_MASK (*pAttribute, uMask)) 
			fReconf	= (rpSetAttrProcTbl [i])(gw, pAttribute) | fReconf ;
		uMask	= uMask << 1 ;
	}
#if	0 
	if (XtIsRealized (gw) && fReconf) {
		/*	ľ*/
		tsubWindowFrame_configureFocusOffset (gw) ;
		tsubWindowFrame_configureTerminalWindow (gw) ;
	}
#endif
	return ;
}

Boolean
tsubWindowFrame_onSetAttributeFocusWindow (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;
	register Display*	pDisplay ;
	register Window		wndNewFocus ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;
	assert ((pAttribute->m_uMask & CAFocusWindow) != 0) ;

	wndNewFocus	= CONVATTR_FOCUSWINDOW (*pAttribute) ; 
#if defined (DEBUG)
	fprintf (stderr, "FocusWindow: (%lx)\n", wndNewFocus) ;
#endif
	if (!XtIsRealized (gw)) {
		wgThis->tsubwin.m_wndFocus	= wndNewFocus ;
		return	False ;
	}
	if (wgThis->tsubwin.m_wndFocus != wndNewFocus) {
		pDisplay	= XtDisplay (gw) ;
		XReparentWindow (pDisplay, wgThis->tsubwin.m_wndTerminal, wndNewFocus, 0, 0) ;
	}
	return	True ;
}

Boolean
tsubWindowFrame_onSetPreeditAttribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register unsigned int	uMask ;
	register int			i ;
	register Boolean		fRetval ;
	static Boolean	(*rpSetPAttrProcTbl[])(Widget, const TConversionAttribute*) = {
		NULL,
		tsubWindowFrame_onSetPAttributeClientArea,
		tsubWindowFrame_onSetPAttributeFont,
		tsubWindowFrame_onSetPAttributeLineSpacing,
		tsubWindowFrame_onSetPAttributeColormap,
		tsubWindowFrame_onSetPAttributeForeground,
		tsubWindowFrame_onSetPAttributeBackground,
	} ;

	uMask	= 1 << CASpotLocationBit ;
	i		= 0 ;
	fRetval	= False ;
	while (i <= (CABackgroundPixelBit - CASpotLocationBit)) {
		if (IS_CONVATTR_PREEDIT_MASK (*pAttribute, uMask) &&
			rpSetPAttrProcTbl [i] != NULL)
			fRetval	= (rpSetPAttrProcTbl [i])(gw, pAttribute) || fRetval ;
		uMask	= uMask << 1 ;
		i	++ ;
	}
	return	fRetval ;
}

Boolean
tsubWindowFrame_onSetPAttributeClientArea (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;
	register const XRectangle*	pRect ;
	register unsigned int		uMask ;
	XWindowChanges				xwc ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

#if defined (DEBUG)
	fprintf (stderr, "TSubWindowFrame: ClientArea: (%d, %d, %d, %d)\n", 
			 pAttribute->m_Preedit.m_area.x,
			 pAttribute->m_Preedit.m_area.y,
			 pAttribute->m_Preedit.m_area.width,
			 pAttribute->m_Preedit.m_area.height) ;
#endif
	pRect	= &CONVATTR_PREEDIT_CLIENTAREA (*pAttribute) ;
	uMask	= 0 ;
	if (wgThis->core.x != pRect->x) {
		wgThis->core.x	= xwc.x	= pRect->x ;
		uMask	|= CWX ;
	}
	if (wgThis->core.y != pRect->y) {
		wgThis->core.y	= xwc.y	= pRect->y ;
		uMask	|= CWY ;
	}
	if (wgThis->core.width  != pRect->width) {
		wgThis->core.width	= xwc.width	= pRect->width ;
		uMask	|= CWWidth ;
	}
	if (wgThis->core.height != pRect->height) {
		wgThis->core.height	= xwc.height	= pRect->height ;
		uMask	|= CWHeight ;
	}
	if (wgThis->tsubwin.m_wndTerminal != None && uMask != 0) 
		XConfigureWindow (XtDisplay (gw), wgThis->tsubwin.m_wndTerminal, uMask, &xwc) ;
	return	False ;
}

Boolean
tsubWindowFrame_onSetPAttributeFont (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;
	
	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	TFontSet_Copy (&wgThis->tsubwin.m_fsTerminal, &CONVATTR_PREEDIT_FONTSET (*pAttribute)) ;
#if defined (DEBUG)
	fprintf (stderr, "tsubWindowFrame_onSetPAttributeFont: \n") ;
	TFontSet_Show (&wgThis->tsubwin.m_fsTerminal) ;
	TFontSet_Show (&CONVATTR_PREEDIT_FONTSET (*pAttribute)) ;
#endif
	wgThis->tsubwin.m_nLineSpacing	= 0 ;
	return	True ;
}

Boolean
tsubWindowFrame_onSetPAttributeLineSpacing (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	if (wgThis->tsubwin.m_nLineSpacing != pAttribute->m_Preedit.m_nLineSpacing) {
		wgThis->tsubwin.m_nLineSpacing = pAttribute->m_Preedit.m_nLineSpacing ;
		return	True ;
	}
	return	False ;
}

Boolean
tsubWindowFrame_onSetPAttributeColormap (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;
	register Colormap	colormap ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	colormap	= pAttribute->m_Preedit.m_colormap ;
	if (wgThis->core.colormap == colormap)
		return	False ;

	wgThis->core.colormap	= colormap ;
	if (wgThis->tsubwin.m_wndTerminal != None)
		XSetWindowColormap (XtDisplay (gw), wgThis->tsubwin.m_wndTerminal, colormap) ;
	return	False ;
}

Boolean
tsubWindowFrame_onSetPAttributeBackground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;
	register Pixel	pxlBack ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pxlBack		= CONVATTR_PREEDIT_BACKGROUND (*pAttribute) ;
	if (wgThis->core.background_pixel == pxlBack)
		return	False ;

	wgThis->core.background_pixel	= pxlBack ;
	if (wgThis->tsubwin.m_wndTerminal != None)
		XSetWindowBackground (XtDisplay (gw), wgThis->tsubwin.m_wndTerminal, pxlBack) ;
	return	False ;
}

Boolean
tsubWindowFrame_onSetPAttributeForeground (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) gw ;
	register Pixel	pxlFore ;

	assert (gw != NULL) ;
	assert (pAttribute != NULL) ;

	pxlFore		= CONVATTR_PREEDIT_FOREGROUND (*pAttribute) ;
	if (wgThis->tsubwin.m_pxlForeground == pxlFore)
		return	False ;
	wgThis->tsubwin.m_pxlForeground	= pxlFore ;
	return	True ;
}

/*	Status Attribute:	Status Attribute ¦ϲޤǤμɬפ
 */
Boolean
tsubWindowFrame_onSetStatusAttribute (
	register Widget			gw,
	register const TConversionAttribute*	pAttribute)
{
	return	False ;
}

Boolean
tsubWindowFrame_puts (
	register Widget			gw,
	register const Char*	pText,
	register int			nText)
{
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;
	register TSubWindowFrameTerminal*				pTerminal ;
	register TSubWindowFrameTerminalTextControl*	pControl ;
	TSubWindowFrameTerminalTextControl			localControl ;
	register int			nControl, nptr, nInput ;
	register Boolean		fNewControl	= False ;
	register const Char*	ptr ;
	register const Char*	pStrInput ;

	if (wgThis->tsubwin.m_fDestroy)
		return	False ;

#if defined (DEBUG)
	fprintf (stderr, "tsubWindowFrame_puts (%p, %p, %d)\n",
			 gw, pText, nText) ;
#endif
	pTerminal	= &wgThis->tsubwin.m_Terminal ;
	nControl	= TVarbuffer_GetUsage (&pTerminal->m_vbufControl) ;
	if (nControl > 0) {
		pControl	= TVarbuffer_GetBuffer (&pTerminal->m_vbufControl) ;
		pControl	= pControl + nControl - 1 ;
		if (TSUCCEEDED (pControl->m_fFinish) ||
			pControl->m_fRev != pTerminal->m_fRev) {
			/* ξˤϿȥ뤬ɬס*/
			pControl	= &localControl ;
			fNewControl	= True ;
		}
	} else {
		pControl	= &localControl ;
		fNewControl	= True ;
	}
	if (fNewControl) {
		pControl->m_fRev		= pTerminal->m_fRev ;
		pControl->m_nTextPos	= TVarbuffer_GetUsage (&pTerminal->m_vbufText) ;
		pControl->m_nText		= 0 ;
		pControl->m_fFinish		= False ;
	}

	ptr		= pStrInput	= pText ;
	nptr	= nText ;
	while (nptr > 0) {
		if (*ptr == '\n') {
			nInput					= ptr - pStrInput ;
			if (nInput > 0 &&
				TFAILED (TVarbuffer_Add (&pTerminal->m_vbufText, pStrInput, nInput)))
				return	False ;
			pControl->m_nText		+= nInput ;
#if defined (DEBUG) || 0
			fprintf (stderr, "TextPos(%d), Text(%d), %d, %d\n",
					 pControl->m_nTextPos, pControl->m_nText, nInput, nText) ;
#endif
			pControl->m_fFinish	= True ;
			if (fNewControl) {
				if (TFAILED (TVarbuffer_Add (&pTerminal->m_vbufControl, pControl, 1)))
					return	False ;
			}
			pControl				= &localControl ;
			fNewControl				= True ;
			pControl->m_fRev		= pTerminal->m_fRev ;
			pControl->m_nTextPos	= TVarbuffer_GetUsage (&pTerminal->m_vbufText) ;
			pControl->m_nText		= 0 ;
			pControl->m_fFinish		= False ;
			pTerminal->m_nLine		++ ;	/* Ԥ뤫ϥ쥤Ȥ˽פʤΤǵ롣*/
			pStrInput				= ptr + 1 ;
		}
		ptr		++ ;
		nptr	-- ;
	}
	if (ptr != pStrInput) {
		nInput					= ptr - pStrInput ;
		if (TFAILED (TVarbuffer_Add (&pTerminal->m_vbufText, pStrInput, nInput)))
			return	False ;
		pControl->m_nText		+= nInput ;
#if defined (DEBUG)
		fprintf (stderr, "TextPos(%d), Text(%d), %d, %d\n",
				 pControl->m_nTextPos, pControl->m_nText, nInput, nText) ;
#endif
	}
	if (fNewControl) {
		if (TFAILED (TVarbuffer_Add (&pTerminal->m_vbufControl, pControl, 1)))
			return	False ;
	}
	return	True ;
}

Boolean
tsubWindowFrame_putchar (
	register Widget		gw,
	const Char			cc)
{
	return	tsubWindowFrame_puts (gw, &cc, 1) ;
}

void
tsubWindowFrame_rev (
	register Widget			gw,
	register Boolean		fRev)
{
	register TSubWindowFrameWidget		wgThis	= (TSubWindowFrameWidget) gw ;
	register TSubWindowFrameTerminal*		pTerminal ;

	pTerminal	= &wgThis->tsubwin.m_Terminal ;
	pTerminal->m_fRev	= fRev ;
	return ;
}

void
tsubWindowFrame_clear (
	register Widget			gw)
{
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;
	register TSubWindowFrameTerminal*	pTerminal ;

	if (wgThis->tsubwin.m_fDestroy)
		return ;

#if defined (DEBUG)
	fprintf (stderr, "tsubWindowFrame_clear (%p)\n", gw) ;
#endif
	pTerminal	= &wgThis->tsubwin.m_Terminal ;
	TVarbuffer_Clear (&pTerminal->m_vbufText) ;
	TVarbuffer_Clear (&pTerminal->m_vbufControl) ;
	pTerminal->m_nCursor	= 0 ;
	pTerminal->m_nLine		= 1 ;
	return ;
}

void
tsubWindowFrame_flush (
	register Widget			gw)
{
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) gw ;

	if (wgThis->tsubwin.m_fDestroy)
		return ;
#if defined (DEBUG)
	fprintf (stderr, "tsubWindowFrame_flush (%p)\n", gw) ;
#endif
	XMapWindow (XtDisplay (gw), wgThis->tsubwin.m_wndTerminal) ;
	tsubWindowFrame_onTerminalExpose (gw, 0) ;
	//XClearArea (XtDisplay (gw), wgThis->tsubwin.m_wndTerminal, 0, 0, 0, 0, True) ;
	return ;
}

Boolean
tsubWindowFrame_rectVariablep (
	register Widget			gw)
{
	return	False ;
}

Boolean
tsubWindowFrame_haveExternModelinep (
	register Widget			gw)
{
	return	False ;
}

Boolean
tsubWindowFrame_setModeline (
	register Widget			gw,
	register const Char*	pString,
	register int			nString)
{
	return	False ;
}

Boolean
tsubWindowFrame_autoPopupp (
	register Widget			gw)
{
	return	False ;
}

int
tsubWindowFrame_onTerminalExpose (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TSubWindowFrameWidget	wgThis	= (TSubWindowFrameWidget) pClosure ;
	register TSubWindowFrameTerminal*				pTerminal ;
	register TSubWindowFrameTerminalTextControl*	pControl ;
	register Display*			pDisplay ;
	register Window				wndTerminal ;
	register GC					gc ;
	register const Char*		pText ;
	register TFontSet*			pFontSet ;
	register Pixel				pxlForeground, pxlBackground ;
	register int				x, y, nHeight, nLine, nControl ;
	register Boolean			fLineSpacing ;
	register int				nLineSpacing, nAscent, nDescent ;
	TSize						sz ;
#if defined (DEBUG) || 1
	register int				i	= 0 ;
#endif

	if (wgThis->tsubwin.m_fDestroy)
		return	0 ;

#if defined (DEBUG)
	fprintf (stderr, "TSubWindowFrame_onTerminalExpose (%p)\n", pClosure) ;
#endif
	pDisplay		= XtDisplay (wgThis) ;
	wndTerminal		= wgThis->tsubwin.m_wndTerminal ;
	pTerminal		= &wgThis->tsubwin.m_Terminal ;
	nControl		= TVarbuffer_GetUsage  (&pTerminal->m_vbufControl) ;
	if (nControl <= 0 || pTerminal->m_nLine <= 0)
		return	0 ;

	pControl		= TVarbuffer_GetBuffer (&pTerminal->m_vbufControl) ;
	pFontSet		= &wgThis->tsubwin.m_fsTerminal ;
	gc				= wgThis->tsubwin.m_gcTerminal ;
	nLine			= pTerminal->m_nLine ;
	x				= 0 ;
	nAscent			= TFontSet_GetAscent  (pFontSet) ;
	nDescent		= TFontSet_GetDescent (pFontSet) ;
	y				= nAscent ;
	nHeight			= 0 ;
	nLineSpacing	= wgThis->tsubwin.m_nLineSpacing ;
	fLineSpacing	= (wgThis->tsubwin.m_nLineSpacing > 0) ;
	pxlForeground	= wgThis->tsubwin.m_pxlForeground ;
	pxlBackground	= wgThis->core.background_pixel ;
	pText			= TVarbuffer_GetBuffer (&pTerminal->m_vbufText) ;
	while (nControl > 0) {
#if defined (DEBUG) || 0
		fprintf (stderr, "Control(%d):(%d,%d), TextPos(%d), Text(%d), Rev(%d), Fin(%d)\n",
				 i, x, y, 
				 pControl->m_nTextPos, pControl->m_nText, 
				 pControl->m_fRev, pControl->m_fFinish) ;
		i	++ ;
#endif
		if (pControl->m_fRev) {
			XSetBackground (pDisplay, gc, pxlForeground) ;
			XSetForeground (pDisplay, gc, pxlBackground) ;
		} else {
			XSetForeground (pDisplay, gc, pxlForeground) ;
			XSetBackground (pDisplay, gc, pxlBackground) ;
		}
		if (pControl->m_nText > 0) {
			TTextOut (pDisplay, wndTerminal, gc, pFontSet, x, y, pText + pControl->m_nTextPos, pControl->m_nText, &sz) ;
			x	+= sz.cx ;
		}

		/*	ιԤޤ뤫ɤΥå*/
		if (pControl->m_fFinish) {
			XClearArea (pDisplay, wndTerminal, x, y - nAscent, 65535, y + nDescent, False) ;
			nLine	-- ;
			if (nLine <= 0)
				break ;
			y		+= (fLineSpacing)? nLineSpacing : nHeight ;
			nHeight	= 0 ;
		} else {
			nHeight	=  (nHeight < sz.cy)? sz.cy : nHeight ;
		}
		pControl	++ ;
		nControl	-- ;
	}
	return	0 ;
}

int
tsubWindowFrame_onTerminalConfigure (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) pClosure ;
	XRectangle	rect ;

#if defined (DEBUG)
	fprintf (stderr, "TSubWindowFrame_onTerminalConfigure (%p, %d)\n",
			 pClosure, pEvent->type) ;
#endif
	/*	ꥵ XConfigureEvent Ȼפ*/
	if (pEvent->type != ConfigureNotify)
		return	0 ;

#if defined (DEBUG)
	if (pEvent->type == ConfigureNotify) {
		fprintf (stderr, "Configure: %d, %d, %d, %d\n", 
				 pEvent->xconfigure.x, pEvent->xconfigure.y, 
				 pEvent->xconfigure.width, pEvent->xconfigure.height) ; 
	}
#endif
	wgThis->core.x		= pEvent->xconfigure.x ;
	wgThis->core.y		= pEvent->xconfigure.y ;
	wgThis->core.width	= pEvent->xconfigure.width ;
	wgThis->core.height	= pEvent->xconfigure.height ;
	rect.x				= 0 ;
	rect.y				= 0 ;
	rect.width			= wgThis->core.width ;
	rect.height			= wgThis->core.height ;
	XtCallCallbacks ((Widget) wgThis, XtNconfigureCallback, (XtPointer) &rect) ;
	return	0 ;
}

/*	Terminal ؤ key Ϥ򽦤ä client ˽뤿 wrapper callback ؿ
 *	 callback  callback Ťͤơߤΰ¸٤򸺤餷ƤΤɡä
 *	ɤˤʤäΤ⤷ʤ(;_;)
 */
int
tsubWindowFrame_onTerminalDestroy (
	register void*			pClosure,
	register XEvent*		pEvent)
{
	register TSubWindowFrameWidget	wgThis		= (TSubWindowFrameWidget) pClosure ;
	register Display*	pDisplay ;
	register Window		wnd ;

	if (wgThis->tsubwin.m_fDestroy)
		return	0 ;

#if defined (DEBUG)
	fprintf (stderr, "TSubWindowFrame_onTerminalDestroy (%p)\n", pClosure) ;
#endif
	pDisplay	= XtDisplay (wgThis) ;
	wnd			= wgThis->tsubwin.m_wndTerminal ;
	AfxUnregisterWindow (wnd, Expose, ExposureMask, wgThis, tsubWindowFrame_onTerminalExpose) ;
	AfxUnregisterWindow (wnd, DestroyNotify, StructureNotifyMask, wgThis, tsubWindowFrame_onTerminalDestroy) ;
	AfxUnregisterWindow (wnd, ConfigureNotify, StructureNotifyMask, wgThis, tsubWindowFrame_onTerminalConfigure) ;
	wgThis->tsubwin.m_wndTerminal	= None ;

	if (wgThis->tsubwin.m_gcTerminal != None) {
		XFreeGC (pDisplay, wgThis->tsubwin.m_gcTerminal) ;
		wgThis->tsubwin.m_gcTerminal	= None ;
	}
	wgThis->tsubwin.m_fDestroy	= True ;
	XtCallCallbacks ((Widget) wgThis, XtNdestroyCallback, (XtPointer) 0) ;
	return	0 ;
}

Widget
TSubWindowFrame_Create (
	Widget			wgParent,
	ArgList			arglist,
	Cardinal		nArglist)
{
	assert (wgParent != NULL) ;

	return	XtCreateWidget ("TSubWindowFrame", tsubWindowFrameWidgetClass, wgParent, arglist, nArglist) ;
}



