/*	Kinput2 Protocol  Server ȤƵǽ Widget
 */
#include "AfxWin.h"
#include "local.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "KinputServerP.h"
#include "TRootWindow.h"

struct proprec {
	Atom prop ;
	struct proprec *prev ;
} ;

#define offset(field)  XtOffsetOf(KinputServerRec, kinputServer.field)
#define goffset(field) XtOffsetOf(WidgetRec, core.field)

static XtResource	srKinputServerResources [] = {
	{	XtNwidth,		XtCWidth,		XtRDimension,	sizeof (Dimension),
		goffset (width),			XtRImmediate,	(XtPointer) 1, },
	{	XtNheight,		XtCHeight,		XtRDimension,	sizeof (Dimension),
		goffset (height),			XtRImmediate,	(XtPointer) 1, },
	{	XtNmappedWhenManaged,	XtCMappedWhenManaged,	XtRBoolean,	sizeof (Boolean),
		goffset (mapped_when_managed),	XtRImmediate,	(XtPointer)False, },
	{	XtNenableKinput1,	XtCEnableKinput1,	XtRBoolean,	sizeof(Boolean),
		offset (m_fEnableKinput1),	XtRString,	(XtPointer)"True" },
	{	XtNlispMachine,	XtCLispMachine,	XtRPointer,		sizeof (XtPointer),
		offset (m_pLispMachine),	XtRImmediate,	(XtPointer) 0, },
	{	XtNdestroyCallback,			XtCCallback,
		XtRCallback,				sizeof (XtCallbackList),
		offset (m_lstCbkDestroy),	XtRCallback,		(XtPointer) NULL, },
} ;

#undef offset
#undef goffset

static void		kinputServer_onInitialize	(Widget, Widget, ArgList, Cardinal*) ;
static void		kinputServer_onRealize		(Widget, XtValueMask*, XSetWindowAttributes*) ;
static Boolean	kinputServer_onSetValues	(Widget, Widget, Widget, ArgList, Cardinal*) ;
static void		kinputServer_onDestroy		(Widget) ;

static	void	kinputServer_onConversionRequest	(Widget, XEvent*, String*, Cardinal*) ;
static	void	kinputServer_onConversionEndRequest	(Widget, XEvent*, String*, Cardinal*) ;
static	void	kinputServer_onConversionAttributeNotify	(Widget, XEvent*, String*, Cardinal*) ;
static	void	kinputServer_onSelectionRequest		(Widget, XEvent*, String*, Cardinal*) ;
static	void	kinputServer_onSelectionClear		(Widget, XEvent*, String*, Cardinal*) ;

static	void	kinputServer_setProperty			(Widget) ;
static	Boolean	kinputServer_correctClientMessagep	(Widget, XEvent*) ;
static	void	kinputServer_acceptConversion		(Widget, KinputClient*) ;
static	void	kinputServer_rejectConversion		(Widget, Window, Atom) ;

static	KinputClient*	kinputServer_newClient		(Widget, Window, Atom) ;
static	KinputClient*	kinputServer_findClient		(Widget, Window) ;


/* ٥ȤФ륢Υơ֥롣*/
static XtActionsRec		srKinputServerActionsTable [] = {
	{	"conversion-request",			kinputServer_onConversionRequest, },
	{	"conversion-end-request",		kinputServer_onConversionEndRequest, },
	{	"conversion-attribute-notify",	kinputServer_onConversionAttributeNotify, },
	{	"selection-request",			kinputServer_onSelectionRequest, },
	{	"selection-clear",				kinputServer_onSelectionClear, },
} ;

/*- default translation -*/
static char	sstrKinputServerTranslations [] =
"<Message>CONVERSION_REQUEST:          conversion-request()\n\
 <Message>CONVERSION_END_REQUEST:      conversion-end-request()\n\
 <Message>CONVERSION_ATTRIBUTE_NOTIFY: conversion-attribute-notify()\n\
 <SelReq>:                             selection-request()\n\
 <SelClr>:                             selection-clear()" ;

KinputServerClassRec kinputServerClassRec = {
    {	/* core fields 			*/
		/* superclass			*/	&widgetClassRec,
		/* class_name			*/	"KinputServer",
		/* size					*/	sizeof (KinputServerRec),
		/* class_initialize		*/	NULL,
		/* class_part_initialize*/	NULL,
		/* class_inited			*/	FALSE,
		/* initialize			*/	kinputServer_onInitialize,
		/* initialize_hook		*/	NULL,
		/* realize				*/	kinputServer_onRealize,
		/* actions				*/	srKinputServerActionsTable,
		/* num_actions			*/	XtNumber (srKinputServerActionsTable),
		/* resources			*/	srKinputServerResources,
		/* num_resources		*/	XtNumber (srKinputServerResources),
		/* xrm_class			*/	NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy				*/	kinputServer_onDestroy,
		/* resize				*/	NULL,
		/* expose				*/	NULL,
		/* set_values			*/	kinputServer_onSetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL,
		/* accept_focus			*/	NULL,
		/* version				*/	XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table				*/	sstrKinputServerTranslations,
		/* query_geometry		*/	XtInheritQueryGeometry,
    }, {
		/* dummy				*/	0,
	}
} ;

WidgetClass kinputServerWidgetClass = (WidgetClass)&kinputServerClassRec;


/*
 * KinputWidgetClass νؿ
 */
static void
kinputServer_onInitialize (
	register Widget		greq,
	register Widget		gnew,
	register ArgList	args,
	register Cardinal*	num_args)
{
	register Display*			pDisplay	= XtDisplay (gnew) ;
	register KinputServerWidget	wgThis		= (KinputServerWidget) gnew ;

	wgThis->kinputServer.m_lstClient	= NULL ;
#define MakeAtom(s)	XInternAtom(pDisplay,s,False)
	wgThis->kinputServer.m_atConversion			= MakeAtom ("_JAPANESE_CONVERSION") ;
	wgThis->kinputServer.m_atOldConversion		= MakeAtom ("JAPANESE_CONVERSION") ;
	wgThis->kinputServer.m_atCompoundText		= MakeAtom ("COMPOUND_TEXT") ;
	wgThis->kinputServer.m_atConversionString	= MakeAtom ("CONVERSION_STRING") ;
	wgThis->kinputServer.m_atConversionNotify	= MakeAtom ("CONVERSION_NOTIFY") ;
	wgThis->kinputServer.m_atConversionEnd		= MakeAtom ("CONVERSION_END") ;
	wgThis->kinputServer.m_atConversionAttribute= MakeAtom ("CONVERSION_ATTRIBUTE") ;
#undef MakeAtom
	return ;
}

/*
 * KinputWidget β˸ƤӽФؿ
 */
static void
kinputServer_onRealize (
	register Widget					gw,
	register XtValueMask*			pValueMask,
	register XSetWindowAttributes*	pXSWA)
{
	register Display*			pDisplay	= XtDisplay (gw) ;
	register KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	register CoreWidgetClass	super	= (CoreWidgetClass) XtClass (gw)->core_class.superclass ;

	(*super->core_class.realize)(gw, pValueMask, pXSWA) ;

	XSetSelectionOwner (pDisplay, wgThis->kinputServer.m_atConversion, XtWindow (gw), CurrentTime) ;
	if (XGetSelectionOwner (pDisplay, wgThis->kinputServer.m_atConversion) != XtWindow (gw)) {
		XtDestroyWidget (gw) ;
		return ;
	}
	if (wgThis->kinputServer.m_fEnableKinput1 != False)
		XSetSelectionOwner (pDisplay, wgThis->kinputServer.m_atOldConversion, XtWindow (gw), CurrentTime) ;
	kinputServer_setProperty (gw) ;
	return ;
}

static Boolean
kinputServer_onSetValues (
	register Widget		gwCurrent,
	register Widget		gwRequest,
	register Widget		gwNeww,
	register ArgList	args,
	register Cardinal*	num_args)
{
/*
	register KinputServerWidget	curw	= (KinputServerWidget) gwCurrent ;
	register KinputServerWidget	reqw	= (KinputServerWidget) gwRequest ;
	register KinputServerWidget	neww	= (KinputServerWidget) gwNeww ;
*/
	return	False ;
}

/*
 * KinputWidget ˴˸ƤФؿ
 */
static void
kinputServer_onDestroy (
	register Widget		gw)
{
	register KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	register KinputClient*		pClient ;
	register KinputClient*		pNextClient ;

	XtCallCallbacks (gw, XtNdestroyCallback, 0) ;

	pClient	= wgThis->kinputServer.m_lstClient ;
	while (pClient != NULL) {
		pNextClient	= KinputClient_GetNext (pClient) ;
		KinputClient_Destroy (pClient) ;
		pClient		= pNextClient ;
	}
	wgThis->kinputServer.m_lstClient	= NULL ;
	return ;
}

/*
 * ѴϤ׵᤬褿νԤؿ
 */
static	void
kinputServer_onConversionRequest (
	register Widget			gw,
	register XEvent*		pXEvent,
	register String*		params,
	register Cardinal*		num_params)
{
	register KinputServerWidget		wgThis	= (KinputServerWidget) gw ;
	register XClientMessageEvent*	pEvent	= &pXEvent->xclient ;
	register Window					wndRequestor ;
	register KinputClient*			pClient ;
	register Atom					atConversion, atProperty, atConversionString ;

#if defined (DEBUG)
	fprintf (stderr, "Conversion Request from Window(%ld)\n", (unsigned long)pXEvent->xany.window) ;
#endif
	/* ٥ȤʤΤɤåפޤ*/
	if (!kinputServer_correctClientMessagep (gw, pXEvent)) {
#if defined (DEBUG)
		fprintf (stderr, "Illegal conversion-request message(Kinput2)\n") ;
#endif
		return ;
	}

	atConversion	= (Atom)   pEvent->data.l [0] ;
	wndRequestor	= (Window) pEvent->data.l [1] ;
	atProperty		= (Atom)   pEvent->data.l [4] ;

	pClient	= kinputServer_findClient (gw, wndRequestor) ;
	if (pClient == NULL) {
		pClient = kinputServer_newClient (gw, wndRequestor, atConversion) ;
		if (pClient == NULL) {
			kinputServer_rejectConversion (gw, wndRequestor, atConversion) ;
			return ;
		}

		atConversionString	= (Atom)pEvent->data.l [3] ;
		if (atConversionString == None)
			atConversionString	= wgThis->kinputServer.m_atConversionString ;
		
		if (!KinputClient_Initialize (pClient, atConversion, atProperty, wgThis->kinputServer.m_atConversionAttribute, atConversionString, wgThis->kinputServer.m_atCompoundText)) {
			kinputServer_rejectConversion (gw, wndRequestor, atConversion) ;
			return ;
		}
	}
	kinputServer_acceptConversion (gw, pClient) ;
	KinputClient_Activate (pClient, True) ;
	return ;
}

/*
 * ѴλåνԤؿ
 */
static	void
kinputServer_onConversionEndRequest (
	register Widget		gw,
	register XEvent*	pXEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	register XClientMessageEvent*	pEvent	= &pXEvent->xclient ;
	register KinputClient*			pClient ;

	if (!kinputServer_correctClientMessagep (gw, pXEvent))
		return ;

	pClient	= kinputServer_findClient (gw, (Window)pEvent->data.l [1]) ;
	if (pClient == NULL)
		return ;

	KinputClient_Activate (pClient, False) ;
	return ;
}

/*
 * Ѵ饤Ȥ°ѹΤ褿νԤؿ
 */
static	void
kinputServer_onConversionAttributeNotify (
	register Widget		gw,
	register XEvent*	pXEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	register KinputServerWidget		wgThis	= (KinputServerWidget) gw ;
	register XClientMessageEvent*	pEvent	= &pXEvent->xclient ;
	register KinputClient*			pClient ;
	TConversionAttribute			attribute ;

	if (!kinputServer_correctClientMessagep (gw, pXEvent))
		return ;

	pClient	= kinputServer_findClient (gw, (Window)pEvent->data.l [1]) ;
	if (pClient == NULL)
		return ;
	
	if (KinputClient_GetAttributeFromEvent (pClient, pEvent, wgThis->kinputServer.m_atConversionAttribute, &attribute))
		KinputClient_SetAttribute (pClient, &attribute) ;
	TConvAttr_Uninitialize (&attribute) ;
	return ;
}

/*
 * ¾ѴФ selection ׵򤷤ƤνԤؿ
 */
static	void
kinputServer_onSelectionRequest (
	register Widget		gw,
	register XEvent*	pXEvent,
	register String*	params,
	register Cardinal*	num_params)
{
	XSelectionRequestEvent*	pEvent	= &pXEvent->xselectionrequest ;
	XEvent					ev ;

#if defined (DEBUG)
	fprintf (stderr, "(Kinput2)Selection Request\n") ;
#endif
	ev.xselection.type      = SelectionNotify ;
	ev.xselection.requestor = pEvent->requestor ;
	ev.xselection.selection = pEvent->selection ;
	ev.xselection.target    = pEvent->target ;
	ev.xselection.property  = None ;
	ev.xselection.time      = pEvent->time ;
	
	XSendEvent (pEvent->display, pEvent->requestor, False, NoEventMask, &ev) ;
	return ;
}

/*
 * ѴФ븢¤򼺤äνԤؿ
 */
static	void
kinputServer_onSelectionClear (
	register Widget		gw,
	register XEvent*	pXEvent,
	register String*	params,
	register Cardinal*	num_params)
{
#if defined (DEBUG)
	fprintf (stderr, "kinputServer_onSelectionClear ()\n") ;
#endif
	XtDestroyWidget (gw) ;
	return ;
}

/*
 * Kinput2 Protocol ΥФˤʤäѰդʤФʤʤǡ 
 * X ΥץѥƥȤϿƤΤ˻Ȥؿ饤ȤϤΥ
 * ѥƥ򸫤ƤȻפ
 */ 
static	void
kinputServer_setProperty (
	register Widget		gw)
{
	register Display*	pDisplay	= XtDisplay (gw) ;
	register Atom		atServerProperty, atServerType ;
	register int		n ;
	unsigned long		ruServerProfile [10] ;
  
	atServerProperty	= XInternAtom (pDisplay, KINPUT_CONVERSION_PROFILE, False) ;
	atServerType		= XInternAtom (pDisplay, KINPUT_CONVERSION_ATTRIBUTE_TYPE, False) ;
	
	n	= 0 ;
	ruServerProfile [n ++]	= MAKE_CONVERSION_ATTRIBUTE (KINPUT_CONVERSION_PROFILE_PROTOCOL_VERSION, 1) ;
	ruServerProfile [n ++]	= XInternAtom (pDisplay, KINPUT_PROTOCOL_VERSION, False) ;
	ruServerProfile [n ++]	= MAKE_CONVERSION_ATTRIBUTE (KINPUT_CONVERSION_PROFILE_SUPPORTED_STYLES, 1) ;
	ruServerProfile [n ++]	= KINPUT_CONVERSION_STYLE_ROOTWINDOW | KINPUT_CONVERSION_STYLE_OVERTHESPOT ;

 	XChangeProperty (pDisplay, XtWindow (gw), atServerProperty, atServerType, sizeof (ruServerProfile [0]) * 8, PropModeReplace, (unsigned char*)ruServerProfile, n) ;
	return ;
}

/*
 * Kinput Protocol Ȥå褿ΤɤȽ
 * ꤹؿ
 */
static	Boolean
kinputServer_correctClientMessagep (
	register Widget		gw,
	register XEvent*	pXEvent)
{
	register XClientMessageEvent*	pEvent	= &pXEvent->xclient ;
	register KinputServerWidget		wgThis	=  (KinputServerWidget) gw ;

#if defined (DEBUG)
	fprintf (stderr, "Get Client Message. I check whether it is correct.\n") ;
#endif
	if (pEvent->window != XtWindow (gw) ||
		pEvent->format != 32 ||
		(pEvent->data.l [0] != wgThis->kinputServer.m_atConversion &&
		 (wgThis->kinputServer.m_fEnableKinput1 &&
		  pEvent->data.l [0] != wgThis->kinputServer.m_atOldConversion))) {
		return  False ;
	}
	return	True ;
}

/*
 * Kinput Protocl Ѵ׵Ф饤ȤѴ׵μ
 * Τؿ
 */
static	void
kinputServer_acceptConversion (
	register Widget			gw,
	register KinputClient*	pClient)
{
	KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	XEvent				ev ;

#if defined (DEBUG)
	fprintf (stderr, "Requestor(%x), Selection(%x), Target(%x), Property(%x), Client(%x)\n",
			 KinputClient_GetRequestor (pClient),
			 KinputClient_GetSelection (pClient),
			 KinputClient_GetTarget (pClient),
			 KinputClient_GetProperty (pClient),
			 XtWindow (KinputClient_GetFrame (pClient))) ;
#endif
	ev.xclient.type         = ClientMessage ;
	ev.xclient.window       = KinputClient_GetRequestor (pClient) ;
	ev.xclient.message_type = wgThis->kinputServer.m_atConversionNotify ;
	ev.xclient.format       = 32 ;
	ev.xclient.data.l [0]	= (long) KinputClient_GetSelection (pClient) ;
	ev.xclient.data.l [1]	= (long) KinputClient_GetTarget (pClient) ;
	ev.xclient.data.l [2]	= (long) KinputClient_GetProperty (pClient) ;
	/* RootWindowStyle Frame ʤɤ TopFrame  Window Ƥ*/
	ev.xclient.data.l [3]	= (long) XtWindow (KinputClient_GetFrame (pClient)) ;
	ev.xclient.data.l [4]	= 0L ;
	
	XSendEvent (XtDisplay (gw), KinputClient_GetRequestor (pClient), False, NoEventMask, &ev) ;
	return ;
}

/*
 * Kinput Protocl Ѵ׵Ф饤ȤѴ׵μ
 * Τؿ
 */
static	void
kinputServer_rejectConversion (
	register Widget			gw,
	register Window			wndRequestor,
	register Atom			atConversion)
{
	KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	XEvent				ev ;

	ev.xclient.type			= ClientMessage ;
	ev.xclient.window		= wndRequestor ;
	ev.xclient.message_type	= wgThis->kinputServer.m_atConversionNotify ;
	ev.xclient.format		= 32 ;
	ev.xclient.data.l [0]	= atConversion ;
	ev.xclient.data.l [1]	= None ;
	ev.xclient.data.l [2]	= 0L ;
	ev.xclient.data.l [3]	= 0L ;
	ev.xclient.data.l [4]	= 0L ;

	XSendEvent (XtDisplay (gw), wndRequestor, False, NoEventMask, &ev) ;
	return ;
}

static	KinputClient*
kinputServer_newClient (
	register Widget			gw,
	register Window			wndRequestor,
	register Atom			atConversion)
{
	register KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	register KinputClient*		pClient ;

	pClient	= KinputClient_New (gw, wndRequestor) ;
	if (pClient == NULL)
		return	NULL ;

	KinputClient_SetNext (pClient, wgThis->kinputServer.m_lstClient) ;
	wgThis->kinputServer.m_lstClient	= pClient ;
	return	pClient ;
}

/*
 * ׵ᤷƤ kinput protocol ǽƤΤǤ礦ȥ
 * ؿ
 */
static	KinputClient*
kinputServer_findClient (
	register Widget		gw,
	register Window		wndRequestor)
{
	register KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	register KinputClient*		pClient ;

	pClient	= wgThis->kinputServer.m_lstClient ;
	while (pClient != NULL) {
		if (KinputClient_GetRequestor (pClient) == wndRequestor)
			break ;
		pClient	= KinputClient_GetNext (pClient) ;
	}
	return	pClient ;
}

/*
 *
 */
void
KinputServer_RemoveClient (
	register Widget			gw,
	register void*			pvClient)
{
	register KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	register KinputClient*		pClient	= pvClient ;
	register KinputClient*		pNode ;
	register KinputClient*		pPrevNode ;

	pNode		= wgThis->kinputServer.m_lstClient ;
	pPrevNode	= NULL ;
	while (pNode != NULL) {
		if (pNode == pClient)
			break ;
		pPrevNode	= pNode ;
		pNode		= KinputClient_GetNext (pNode) ;
	}
	if (pNode == NULL)
		return ;

	if (pPrevNode != NULL) {
		KinputClient_SetNext (pPrevNode, KinputClient_GetNext (pNode)) ;
	} else {
		wgThis->kinputServer.m_lstClient	= KinputClient_GetNext (pNode) ;
	}
	KinputClient_Destroy (pClient) ;
	return ;
}

void
KinputServer_FixText (
	register Widget				gw,
	register void*				pvClient,
	register const char*		pText,
	register int				nText)
{
	register Display*		pDisplay 		= XtDisplay (gw) ;
	register KinputClient*	pClient	= pvClient ;
	register Window			wndRequestor 	= KinputClient_GetRequestor (pClient) ;
	register Atom			atProperty		= KinputClient_GetProperty (pClient) ;
	register Atom			atTarget 		= KinputClient_GetTarget (pClient) ;

	/* Property ˷̤򥻥åȤ */
	XChangeProperty (pDisplay, wndRequestor, atProperty, atTarget, 8, PropModeAppend, pText, nText) ;
	return ;
}

/*
 * Kinput Protocol Ѵλ׵˽äƥ饤ȤȤ³λ
 * ؿ
 */
void
KinputServer_EndConversion (
	register Widget				gw,
	register void*				pvClient)
{
	register KinputServerWidget	wgThis	= (KinputServerWidget) gw ;
	register KinputClient*		pClient	= pvClient ;
	XEvent						ev ;

	ev.xclient.type			= ClientMessage ;
	ev.xclient.window		= KinputClient_GetRequestor (pClient) ;
	ev.xclient.message_type	= wgThis->kinputServer.m_atConversionEnd ;
	ev.xclient.format		= 32 ;
	ev.xclient.data.l [0]	= (long) KinputClient_GetSelection (pClient) ;
	ev.xclient.data.l [1]	= (long) XtWindow (gw) ;
	ev.xclient.data.l [2]	= 0L ;
	ev.xclient.data.l [3]	= 0L ;
	ev.xclient.data.l [4]	= 0L ;
	XSendEvent (XtDisplay (gw), KinputClient_GetRequestor (pClient), False, NoEventMask, &ev) ;
	return ;
}

