#if !defined (vstack_h)
#define	vstack_h

#include "local.h"

enum {
	DEFAULT_VSTACK_SIZE	= 512,
} ;

typedef struct {
	unsigned char	m_achInternal [DEFAULT_VSTACK_SIZE] ;
	void*			m_pBuffer ;
	int				m_nWidth ;
	int				m_nUsage ;
	int				m_nSize ;
}	VStack ;

/*	Prototypes */

/*	Ĺåν*/
extern inline	Boolean
Vstack_Initialize   (
	register VStack*		pStack,
	register int			nWidth)
{
	assert (pStack != NULL) ;
	assert (nWidth >  0) ;

	pStack->m_pBuffer	= pStack->m_achInternal ;
	pStack->m_nSize		= DEFAULT_VSTACK_SIZE / nWidth ;
	pStack->m_nUsage	= 0 ;
	pStack->m_nWidth	= nWidth ;
	return	True ;
}

extern inline	Boolean
Vstack_Uninitialize (
	register VStack*		pStack)
{
	assert (pStack != NULL) ;

	if (pStack->m_pBuffer != pStack->m_achInternal) {
		FREE (pStack->m_pBuffer) ;
		pStack->m_pBuffer	= pStack->m_achInternal ;
	}
	pStack->m_nUsage	= 0 ;
	pStack->m_nSize		= 0 ;
	pStack->m_nWidth	= 0 ;
	return	True ;
}

extern inline	Boolean
Vstack_Push         (
	register VStack*		pStack,
	register const void*	pData)
{
	register int		nPosition ;

	assert (pStack != NULL) ;
	assert (pData  != NULL) ;

	nPosition	= pStack->m_nWidth * pStack->m_nUsage ;

	if ((pStack->m_nUsage + 1) > pStack->m_nSize) {
		unsigned char*	pNewBuffer ;
		int				nNewSize ;

		nNewSize	= (pStack->m_nUsage + 1 + DEFAULT_VSTACK_SIZE) ;
		nNewSize	= nNewSize - nNewSize % DEFAULT_VSTACK_SIZE ;
 
		pNewBuffer	= MALLOC (nNewSize * pStack->m_nWidth) ;
		if (pNewBuffer == NULL) 
			return	False ;

		assert (pNewBuffer != NULL) ;
		if (pStack->m_pBuffer != pStack->m_achInternal) {
			memcpy (pNewBuffer, pStack->m_pBuffer, nPosition) ;
			FREE (pStack->m_pBuffer) ;
		} else {
			memcpy (pNewBuffer, pStack->m_achInternal, nPosition) ;
		}
		pStack->m_pBuffer	= pNewBuffer ;
		pStack->m_nSize		= nNewSize ;
	}
	memcpy ((unsigned char*)pStack->m_pBuffer + nPosition, pData, pStack->m_nWidth) ;
	pStack->m_nUsage	++ ;
	return	True ;
}

extern inline	Boolean
Vstack_Pop          (
	register VStack*	pStack,
	register void*		pData)
{
	register int			nPos ;

	assert (pStack != NULL) ;

	if (pStack->m_nUsage <= 0)
		return	False ;

	pStack->m_nUsage	-- ;
	if (pData == NULL) 
		return	True ;

	nPos	= pStack->m_nWidth * pStack->m_nUsage ;
	memcpy (pData, (unsigned char*)pStack->m_pBuffer + nPos, pStack->m_nWidth) ;
	return	True ;
}

extern inline	Boolean
Vstack_Clear        (
	register VStack*	pStack)
{
	pStack->m_nUsage	= 0 ;
	return	True ;
}

extern inline	Boolean
Vstack_Emptyp       (
	register VStack*	pStack)
{
	return	(pStack->m_nUsage == 0)? True : False ;
}

extern inline	Boolean
Vstack_GetHead		(VStack* pStack, void* pData)
{
	register int		nPosition ;

	if (pStack->m_nUsage <= 0)
		return	False ;
	
	nPosition	= pStack->m_nWidth * (pStack->m_nUsage - 1) ;
	memcpy (pData, (unsigned char *)pStack->m_pBuffer + nPosition, pStack->m_nWidth) ;
	return	True ;
}

#endif

