#if defined (WIN32)
#include "local.h"
#include <assert.h>
#include "kstring.h"
#include "unicodemap.h"

int
dwcstowcs (LPWSTR pwDest, int nDestSize, const Char* pSrc, int nSrcSize)
{
	int	nBackup ;

	assert (pwDest != NULL || nDestSize <= 0) ;
	assert (pSrc   != NULL || nSrcSize  <= 0) ;
	
	nBackup	= nDestSize ;
	while (nDestSize > 0 && nSrcSize > 0) {
		*pwDest		++	= Char_ToUnicode (*pSrc ++) ;
		nDestSize	-- ;
		nSrcSize	-- ;
	}
	return	(nBackup - nDestSize) ;
}

int
wcstodwcs (Char* pDest, int nDestSize, LPCWSTR pwSrc, int nSrcSize)
{
	return	0 ;
}

#endif

