#if !defined (kfile_h)
#define	kfile_h

#include "Char.h"
#include <stdio.h>
#include "kanji.h"

typedef struct tagKFILE {
	FILE*				m_pf ;
	KANJISTATEMACHINE	m_ksm ;
	int					m_iCodingSystem ;
}	KFILE ;

typedef struct tagKFILEPOS {
	long				m_lPosition ;	/* եƬΰ֡*/
	KANJISTATEMACHINE	m_ksm ;			/* ֵξ֡*/
}	KFILEPOS ;

#define	KFILEPOS_POSITION(pos)	((pos).m_lPosition)
#define	KFILEPOS_STATE(pos)		((pos).m_ksm)

/*	Prototypes */
Boolean	KFile_Init	(KFILE*) ;
Boolean	KFile_Open	(KFILE*, const char*, int) ;
Boolean	KFile_Close	(KFILE*) ;
Char	KFile_Getc	(KFILE*) ;
Boolean	KFile_FindsAtBeginningOfLine  (KFILE*, const Char*) ;
Boolean	KFile_FindsAtBeginningOfLineA (KFILE*, const char*) ;
Boolean	KFile_Cmps					(KFILE*, const Char*) ;
Boolean	KFile_Cmpsn					(KFILE*, const Char*, int) ;
Boolean	KFile_Nextline				(KFILE*) ;
Boolean	KFile_Tell					(KFILE*, KFILEPOS*) ;
Boolean	KFile_Seek					(KFILE*, KFILEPOS*) ;
Boolean	KFile_Seekn					(KFILE*, long, int) ;
Boolean	KFile_Rewind				(KFILE*) ;
int		KFile_GetCodingSystem		(KFILE*) ;
int		KFile_DetectCodingSystem	(KFILE*) ;

#endif

