#include "local.h"
#include <assert.h>
#include <unistd.h>
#if !defined (__linux__)
#include <sys/syslimits.h>
#endif
#include <sys/param.h>
#include <pwd.h>
#include <sys/types.h>
#include "filename.h"
#include "cstring.h"

#if !defined (MAXLOGNAME)
#define	MAXLOGNAME	(256)
#endif

/*	ɽǤ Char ʸ System ѤǤʸ
 *	Ѵ롣ȤäƤ⡢ASCII ʳΤƤäꤹ뤬ġ
 *
 *	pDest  MAX_PATH + 1 ߤʡ
 */
Boolean
ConvertInternalFileName2SystemFileName (
	register char*			pDest,
	register int			nDest,
	register const Char*	pPath,
	register int			nPath)
{
	/*	PATH_MAX ʾϳݤƤʤ⤽ OS ˤ
	 *	ݤƤʾ塢ץꥱǤƤʤϤʤ
	 */
	if (nPath > PATH_MAX)
		nPath	= PATH_MAX ;

	while (nPath > 0 && nDest > 0) {
		/*	ASCII ʳʸǧʤȤˤ롣*/
		if (!Char_IsAscii (*pPath) || *pPath < 0x20)
			return	False ;
		*pDest ++	= (char)*pPath ++ ;
		nDest	-- ;
		nPath	-- ;
	}
	if (nDest > 0)
		*pDest	= '\0' ;
	return	True ;
}

/*	ѥŸưդʷľؿ
 *	֤ΰդʡפʬμ¸ϤʤǸľɬפ
 *	
 */
Boolean
ExpandFileName (
	register TVarbuffer*	pvbuf,
	register const Char*	pPath,
	register int			nPath,
	register const Char*	pDefaultPath,
	register int			nDefaultPath)
{
	char	achPath [PATH_MAX + 1] ;
	char	achLoginName [MAXLOGNAME + 1] ;

	if (*pPath == '.') {
		if (pDefaultPath != NULL) {
			if (TFAILED (ExpandFileName (pvbuf, pDefaultPath, nDefaultPath, NULL, 0)))
				return	False ;
		} else {
			int		len ;
			if (getcwd (achPath, NELEMENTS (achPath) - 1) == NULL)
				return	False ;
			achPath [NELEMENTS (achPath) - 1]	= '\0' ;
			len		= strlen (achPath) ;
			if (TFAILED (TVarbuffer_Require (pvbuf, len)))
				return	False ;
			strtocstr (TVarbuffer_GetBuffer (pvbuf), achPath, len) ;
		}
	}
	if (*pPath == '~') {
		register const Char*	ptr ;
		register int			nptr ;
		register char*			pLogname ;
		register int			nLogname ;
		register struct passwd*	pPasswd	= NULL ;
		register int			nPos ;
		register int			nDir ;

		ptr			= pPath + 1 ;
		nptr		= nPath - 1 ;
		pLogname	= achLoginName ;
		nLogname	= MAXLOGNAME ;
		/*	login ̾ȤͭʤΤϡ[A-Za-z0-9_] Ǥ롣*/
		while (nLogname > 0 && nptr > 0 && (Char_IsAlphaNum (*ptr) || *ptr == '_')) {
			*pLogname	++ = Char_ToAscii (*ptr) ;
			nLogname	-- ;
			ptr			++ ;
			nptr		-- ;
		}
		*pLogname	= '\0' ;
		/*	path separator ǧǤʤСġ*/
		if (nptr <= 0 || *ptr == '/') {
			if (achLoginName [0] == '\0') {
				pPasswd	= getpwuid (getuid ()) ;
			} else {
				pPasswd	= getpwnam (achLoginName) ;
			}
			if (pPasswd != NULL) {
				pPath	= ptr ;
				nPath	= nptr ;
			}
		}
		if (pPasswd == NULL) {
			pPasswd	= getpwent () ;
			if (pPasswd == NULL)
				return	False ;
		}
		/*	home directory 롣*/
		nDir	= strlen (pPasswd->pw_dir) ;
		nPos	= TVarbuffer_GetUsage (pvbuf) ;
		if (TFAILED (TVarbuffer_Require (pvbuf, nDir)))
			return	False ;
		strtocstr ((Char*)TVarbuffer_GetBuffer (pvbuf) + nPos, pPasswd->pw_dir, nDir) ;
	}

	/*	Ϥθɤʡġ*/
	return	TVarbuffer_Add (pvbuf, pPath, nPath) ;
}

Boolean
GetFileNameNondirectory (
	register const Char*	pFileName,
	register int			nFileName,
	register const Char**	ppFileNameOut,
	register int*			pnFileNameOut)
{
	register const Char*	pPtr ;
	register int			nPtr ;
	register const Char*	pLastPos ;

	pLastPos	= NULL ;
	pPtr		= pFileName ;
	nPtr		= nFileName ;
	while (nPtr > 0) {
		if (*pPtr == '/') 
			pLastPos	= pPtr ;
		pPtr	++ ;
		nPtr	-- ;
	}
	if (pLastPos == NULL) {
		*ppFileNameOut	= pFileName ;
		*pnFileNameOut	= nFileName ;
	} else {
		register int	nRest	= nFileName - (pLastPos + 1 - pFileName) ;
		if (nRest < 0)
			return	False ;
		*ppFileNameOut	= pLastPos + 1 ;
		*pnFileNameOut	= nRest ;
	}
	return	True ;
}


