#if defined (DEBUG_MEMORY)
#include "local.h"
#include <stdio.h>
#include <stdlib.h>

typedef struct tagDebugMBlock {
	const char*				m_pSource ;
	int						m_nLine ;
	int						m_nLevel ;
	size_t					m_nSize ;
	struct tagDebugMBlock*	m_pPrev ;
	struct tagDebugMBlock*	m_pNext ;
}	DebugMBlock ;

static DebugMBlock*	slstMBlock		= NULL ;
static int			snTouchLevel	= 0 ;

void*
debug_malloc (
	register size_t			nSize,
	register const char*	pSource,
	register int			nLine)
{
	register DebugMBlock*	pBlock ;

	pBlock	= malloc (sizeof (DebugMBlock) + nSize) ;
	if (pBlock == NULL)
		return	NULL ;
#if 0
	fprintf (stderr, "debug_malloc (source:\"%s\", line:%d, size:%d, %p)\n",
			 pSource, nLine, nSize, pBlock + 1) ;
#endif
	pBlock->m_pSource	= pSource ;
	pBlock->m_nLine		= nLine ;
	pBlock->m_nLevel	= snTouchLevel ;
	pBlock->m_nSize		= nSize ;
	pBlock->m_pPrev		= NULL ;
	pBlock->m_pNext		= slstMBlock ;
	if (slstMBlock != NULL)
		slstMBlock->m_pPrev	= pBlock ;
	slstMBlock			= pBlock ;
	return	(void*)(pBlock + 1) ;
}

void
debug_free (
	register void*			pPointer,
	register const char*	pSource,
	register int			nLine)
{
	register DebugMBlock*	pBlock ;

	if (pPointer == NULL)
		return ;

	pBlock	= (DebugMBlock*)pPointer - 1 ;

#if 0
	fprintf (stderr, "debug_free (source:\"%s\", line:%d, block(source:\"%s\", line:%d, size:%d, %p))\n",
			 pSource, nLine, pBlock->m_pSource, pBlock->m_nLine, 
			 pBlock->m_nSize, pPointer) ;
#endif
	if (pBlock->m_pPrev != NULL) {
		pBlock->m_pPrev->m_pNext	= pBlock->m_pNext ;
	} else {
		slstMBlock	= pBlock->m_pNext ;
	}
	if (pBlock->m_pNext != NULL) {
		pBlock->m_pNext->m_pPrev	= pBlock->m_pPrev ;
	}
	free (pBlock) ;
	return ;
}

void
debug_touch (void)
{
	snTouchLevel	++ ;
	return ;
}

void
debug_dumpmemory (int n)
{
	register DebugMBlock*	pBlock ;

	pBlock	= slstMBlock ;
	while (pBlock != NULL) {
		if (pBlock->m_nLevel >= n) {
			fprintf (stderr, "block(%p/%d) (source:\"%s\", line:%d, size:%d)",
					 pBlock,
					 pBlock->m_nLevel,
					 pBlock->m_pSource, 
					 pBlock->m_nLine, 
					 pBlock->m_nSize) ;
			fprintf (stderr, "\n") ;
		}
		pBlock	= pBlock->m_pNext ;
	}
	fflush (stderr) ;
	return ;
}

#endif

