#if !defined (bufstringp_h)
#define	bufstringp_h

#include "bufstring.h"

struct tagBufStringLeaf ;
struct tagBufStringNode ;

#define	SIZE_TBUFBASESTRING	(224)

/*	$B#2?'LZ$K$7$F%P%i%s%9$r$H$k$h$&$K$7$F$$$k!#$=$N$^$^%D%j!<$r(B
 *	$B:n$k$H@~7?%j%9%H$HJQ$o$i$J$$9=B$$K$J$k2DG=@-$,9b$$$N$G!#(B
 */
typedef enum {
	TBUFSTRINGNODECOLOR_RED,
	TBUFSTRINGNODECOLOR_BLACK,
}	TBufStringNodeColor ;

typedef struct tagBufStringLeaf {
	Char		m_achText [SIZE_TBUFBASESTRING] ;
	int			m_nLength ;
	struct tagBufStringLeaf*	m_pPrev ;
	struct tagBufStringLeaf*	m_pNext ;
	struct tagBufStringNode*	m_pParent ;
}	TBufStringLeaf ;

typedef struct tagBufStringLink {
	Boolean					m_fLeaf ;
	union {
		struct tagBufStringNode*	m_pNode ;
		struct tagBufStringLeaf*	m_pLeaf ;
	}	u ;
}	TBufStringLink ;

typedef struct tagBufStringNode {
	unsigned int				m_nLength ;
	TBufStringLink				Left ;
	TBufStringLink				Right ;
	struct tagBufStringNode*	m_pParent ;
	TBufStringNodeColor			m_nColor ;
}	TBufStringNode ;

#endif

