#if !defined (bufstring_h)
#define	bufstring_h

#include "local.h"
#include "Char.h"

struct tagBufStringMarker ;
struct tagBufStringNode ;
struct tagBufStringLeaf ;
struct tagBufString;

struct tagBufString {
	struct tagBufStringNode*	m_pRoot ;
	struct tagBufStringLeaf*	m_pHead ;
} ;

struct tagBufStringMarker {
	struct tagBufString*		m_pBufString ;
	struct tagBufStringLeaf*	m_pLeaf ;
	int							m_nPosition ;
	int							m_nOffset ;
} ;

typedef	struct tagBufStringMarker	TBufStringMarker ;
typedef struct tagBufString			TBufString ;


Boolean	TBufString_Initialize			(TBufString*) ;
Boolean	TBufString_Uninitialize			(TBufString*) ;
Boolean	TBufString_SolveMarker			(TBufString*, int, TBufStringMarker*) ;
int		TBufString_GetLength			(TBufString*) ;
Boolean	TBufStringMarker_InsertString	(TBufStringMarker*, const Char*, int) ;
Boolean	TBufStringMarker_InsertChar		(TBufStringMarker*, Char, int) ;
Boolean	TBufStringMarker_DeleteChar		(TBufStringMarker*, int) ;
Boolean	TBufStringMarker_Forward		(TBufStringMarker*, int) ;
Boolean	TBufStringMarker_Backward		(TBufStringMarker*, int) ;
int		TBufStringMarker_GetOffset		(TBufStringMarker*) ;
Char	TBufStringMarker_GetChar		(TBufStringMarker*) ;
void	TBufStringMarker_SetVoid		(TBufStringMarker*) ;
Boolean	TBufStringMarker_Voidp			(TBufStringMarker*) ;

#endif

