#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"
#include "lmstate.h"

static	Boolean	lispMachine_makeLocalHook (TLispMachine*, TLispEntity*, TLispEntity*) ;

TLMRESULT
lispMachineState_Nth (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pN ;
	TLispEntity*	pList ;
	TLispEntity*	pRetval ;
	long			lN ;
	
	pLispMgr	= pLM->m_pLispMgr ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pN)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pArglist, &pList)) ||
		TFAILED (lispEntity_GetIntegerValue (pLispMgr, pN, &lN)) ||
		TFAILED (lispEntity_Listp    (pLispMgr, pList))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	while (lN > 0 && TFAILED (lispEntity_Nullp (pLispMgr, pList))) {
		lispEntity_GetCdr (pLispMgr, pList, &pList) ;
		lN	-- ;
	}
	lispEntity_GetCar (pLispMgr, pList, &pRetval) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pRetval) ;
	return	LMR_RETURN ;
}

/*
 *	(local-set-key KEY COMMAND)
 *
 *	interactive function:
 *	"KSet key locally: \nCSet key %s locally to command: "
 *
  (let ((map (current-local-map)))
    (or map
	(use-local-map (setq map (make-sparse-keymap))))
    (or (vectorp key) (stringp key)
	(signal 'wrong-type-argument (list 'arrayp key)))
    (define-key map key command)))
 */
TLMRESULT
lispMachineState_LocalSetKey (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntCurBuffer ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntKey ;
	TLispEntity*	pEntCommand ;
	TLispEntity*	pEntKeymap ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntKey)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntCommand))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMachineCode_GetCurrentBuffer (pLM, &pEntCurBuffer))) {
#if defined (DEBUG) || 1
		fprintf (stderr, "current buffer doesn't exist.\n") ;
#endif
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	(void) lispBuffer_GetKeymap (pEntCurBuffer, &pEntKeymap) ;
	if (pEntKeymap == NULL ||
		TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntKeymap))) {
		if (TFAILED (lispMgr_CreateSparseKeymap (pLispMgr, NULL, &pEntKeymap)))
			return	LMR_ERROR ;
		lispBuffer_SetKeymap (pLispMgr, pEntCurBuffer, pEntKeymap) ;
#if defined (DEBUG) || 1
		fprintf (stderr, "set current buffer keymap.\n") ;
#endif
	}
	if (TSUCCEEDED (lispEntity_Vectorp (pLispMgr, pEntKey))) {
		TLispEntity**	ppEntKeySeq ;
		int				nKeySeq ;

		(void) lispEntity_GetVectorValue (pLispMgr, pEntKey, &ppEntKeySeq, &nKeySeq) ;
		if (TFAILED (lispKeymap_DefineKeyWithVector (pLispMgr, pEntKeymap, ppEntKeySeq, nKeySeq, pEntCommand)))
			lispMachineCode_SetError (pLM) ;
	} else if (TSUCCEEDED (lispEntity_Stringp (pLispMgr, pEntKey))) {
		const Char*		pString ;
		int				nString ;

		(void) lispEntity_GetStringValue (pLispMgr, pEntKey, &pString, &nString) ;
		if (TFAILED (lispKeymap_DefineKey (pLispMgr, pEntKeymap, pString, nString, pEntCommand))) 
			lispMachineCode_SetError (pLM) ;
	} else {
		register TLispEntity*	pEntSignal ;
		TLispEntity*	pEntSigValue ;

		pEntSignal	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_WRONG_TYPE_ARGUMENT) ;
		/*	 nil ʤġ*/
		lispMgr_CreateNil (pLispMgr, &pEntSigValue) ;
		lispMachineCode_SetSignal (pLM, pEntSignal, pEntSigValue) ;
	}
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_Functionp (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*			pEntArglist ;
	TLispEntity*			pEntObject ;
	TLispEntity*			pFunc ;
	TLispEntity*			pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntObject) ;

	/*	桼ؿˤʤĴ٤롣*/
	if (TSUCCEEDED (lispMachine_GetSymbolFunctionValue (pLM, pEntObject, &pFunc))) {
		lispMgr_CreateT   (pLispMgr, &pEntRetval) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

/*
 *	(error &rest ARGS)
 *
 *	`subr' Ƥ Lisp ؿǤ롣顼 Signal ơ
 *	顼å `format' ˰ϤȤ롣
 *	ΤȤ顼åϲɽʤͳ `format'
 *	äƤʤ顣
 */
TLMRESULT
lispMachineState_Error (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntError ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntFormat ;
	TLispEntity*	pEntObjects ;
	TLispEntity*	pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntFormat) ;
	lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntObjects) ;
	if (TFAILED (lispEntity_Nullp (pLispMgr, pEntFormat))) {
		const Char*	pStrFormat ;
		int			nStrFormat ;
		if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntFormat, &pStrFormat, &nStrFormat))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
		lispEntity_Format (pLispMgr, pStrFormat, nStrFormat, pEntObjects, &pEntRetval) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
#if defined (DEBUG) || 1
	fprintf (stderr, "error = ") ;
	lispEntity_Print (pLispMgr, pEntRetval) ;
	fprintf (stderr, "\n") ;
#endif
	pEntError	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_ERROR) ;
	lispMachineCode_SetSignal (pLM, pEntError, pEntRetval) ;
	return	LMR_RETURN ;
}

/*
 *	(make-local-hook HOOK)
 *
 *	ȥХåեФ hook HOOK ˺롣֤ͤ
 *	HOOK Ǥ롣
 */
TLMRESULT
lispMachineState_MakeLocalHook (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntHook ;
	TLispEntity*	pEntBuffer ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntHook)) ||
		TFAILED (lispMachineCode_GetCurrentBuffer (pLM, &pEntBuffer)) ||
		TFAILED (lispMachine_makeLocalHook (pLM, pEntBuffer, pEntHook))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntHook) ;
	return	LMR_RETURN ;
}

/*
 *	(add-hook HOOK FUNCTION &optional APPEND LOCAL)
 *
 *	HOOK ͤ function FUNCTION ɲä롣⤷ FUNCTION 
 *	¸ߤƤɲäϤʤoptional  APPEND 
 *	nil ǤʤСFUNCTION  hook list Ƭɲä롣
 *	FUNCTION is added (if necessary) at the beginning of the hook list
 *	unless the optional argument APPEND is non-nil, in which case
 *	FUNCTION is added at the end.
 *	
 *	The optional fourth argument, LOCAL, if non-nil, says to modify
 *	the hook's buffer-local value rather than its default value.
 *	This makes the hook buffer-local if needed.
 *	To make a hook variable buffer-local, always use
 *	`make-local-hook', not `make-local-variable'.
 *	
 *	HOOK should be a symbol, and FUNCTION may be any valid function.  If
 *	HOOK is void, it is first set to nil.  If HOOK's value is a single
 *	function, it is changed to a list of functions.
 */
TLMRESULT
lispMachineState_AddHook (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntHook ;
	TLispEntity*	pEntHookValue ;
	TLispEntity*	pEntCar ;
	TLispEntity*	pEntFunction ;
	TLispEntity*	pEntAppend ;
	TLispEntity*	pEntLocal ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntNil ;
	TLispEntity*	pEntRetval ;
	Boolean			fLocal ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntHook)) ||
		TFAILED (lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntFunction)) ||
		TFAILED (lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntAppend)) ||
		TFAILED (lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntLocal)) ||
		TFAILED (lispMachineCode_GetCurrentBuffer (pLM, &pEntBuffer))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	fLocal	= TFAILED (lispEntity_Nullp (pLispMgr, pEntLocal)) ;
	if (TSUCCEEDED (fLocal)) {
		if (TFAILED (lispMachine_LocalVariableIfSetp (pLM, pEntHook)))
			lispMachine_makeLocalHook (pLM, pEntBuffer, pEntHook) ;
	} else {
		TLispEntity*	pEntValue ;
		TLispEntity*	pEntT ;
		if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntHook, &pEntValue)) ||
			TSUCCEEDED (lispEntity_Voidp (pLispMgr, pEntValue))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
		lispMgr_CreateT (pLispMgr, &pEntT) ;
		if (TFAILED (lispEntity_Consp (pLispMgr, pEntValue)) ||
			TFAILED (lispEntity_Memq (pLispMgr, pEntT, pEntValue, &pEntRetval)) ||
			TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntRetval))) {
			fLocal	= True ;
		}
	}
	if (fLocal) {
		lispMachine_GetCurrentSymbolValue (pLM, pEntHook, &pEntHookValue) ;
	} else {
		lispMachine_GetGlobalSymbolValue (pLM, pEntHook, &pEntHookValue) ;
	}
	lispEntity_GetCar (pLispMgr, pEntHookValue, &pEntCar) ;
	if (TFAILED (lispEntity_Listp (pLispMgr, pEntHookValue)) ||
		TSUCCEEDED (lispEntity_Lambdap (pLispMgr, pEntCar))) {
		lispMgr_CreateConscell (pLispMgr, pEntHookValue, pEntNil, &pEntHookValue) ;
	}
	lispEntity_AddRef (pLispMgr, pEntHookValue) ;

	if (TFAILED (lispEntity_Member (pLispMgr, pEntFunction, pEntHookValue, &pEntRetval)) ||
		TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntRetval))) {
		TLispEntity*	pEntNewHookValue ;

		if (TFAILED (lispEntity_Nullp (pLispMgr, pEntAppend))) {
			TLispEntity*	pEntTemp ;
			TLispEntity*	pEntSequence ;
			TLispEntity*	apEntTbl [2] ;
			lispMgr_CreateConscell (pLispMgr, pEntFunction, pEntNil, &pEntTemp) ;
			lispEntity_AddRef  (pLispMgr, pEntTemp) ;
			apEntTbl [0]	= pEntHookValue ;
			apEntTbl [1]	= pEntTemp ;
			lispMgr_CreateList     (pLispMgr, apEntTbl, 2, &pEntSequence) ;
			lispEntity_AddRef  (pLispMgr, pEntSequence) ;
			lispEntity_Release (pLispMgr, pEntTemp) ;
			lispMgr_Append (pLispMgr, pEntSequence, &pEntNewHookValue) ;
			lispEntity_Release (pLispMgr, pEntSequence) ;
		} else {
			lispMgr_CreateConscell (pLispMgr, pEntFunction, pEntHookValue, &pEntNewHookValue) ;
		}
		lispEntity_AddRef  (pLispMgr, pEntNewHookValue) ;
		lispEntity_Release (pLispMgr, pEntHookValue) ;
		pEntHookValue	= pEntNewHookValue ;
	}
	if (fLocal) {
		if (TFAILED (lispMachine_SetCurrentSymbolValue (pLM, pEntHook, pEntHookValue))) 
			lispMachineCode_SetError (pLM) ;
	} else {
		if (TFAILED (lispMachine_SetGlobalSymbolValue (pLM, pEntHook, pEntHookValue))) 
			lispMachineCode_SetError (pLM) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntHookValue) ;
	lispEntity_Release (pLispMgr, pEntHookValue) ;
	return	LMR_RETURN ;
}

Boolean
lispMachine_makeLocalHook (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntBuffer,
	register TLispEntity*	pEntHook)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntT ;
	TLispEntity*	pEntNil ;
	TLispEntity*	pEntValue	= NULL ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMgr_CreateNil (pLispMgr, &pEntNil) ;
	if (TFAILED (lispMachine_GetCurrentBufferLocalSymbolValue (pLM, pEntHook, &pEntValue)) ||
		pEntValue == NULL) {
		if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntHook, &pEntValue)) ||
			TSUCCEEDED (lispEntity_Voidp (pLispMgr, pEntValue))) 
			lispMachine_SetCurrentSymbolValue (pLM, pEntHook, pEntNil) ;

		if (TFAILED (lispBuffer_MakeSymbolValue (pLispMgr, pEntBuffer, pEntHook)) ||
			TFAILED (lispMgr_CreateT (pLispMgr, &pEntT)) ||
			TFAILED (lispMgr_CreateConscell (pLispMgr, pEntT, pEntNil, &pEntValue)))
			return	False ;
		lispBuffer_SetSymbolValue (pLispMgr, pEntBuffer, pEntHook, pEntValue) ;
	}
	return	True ;
}

/*
 *	This function does not work well.
 */
TLMRESULT
lispMachineState_Documentation (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntRetval ;

	lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

