#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"
#include "jisyo.h"
#include "cstring.h"

static	Boolean	lispMachine_skkOkuriArip (TLispMachine*) ;
static	Boolean	lispMachine_skkMergeAllEntryp (TLispMachine*) ;
static	Boolean	lispMachine_skkProcessOkuriEarlyp (TLispMachine*) ;
static	Boolean	lispMachine_skkGetSearchKey (TLispMachine*, const Char**, int*) ;
static	Boolean	lispMachine_jSearchServerSubr (TLispMachine*, PSKKSERVERJISYO, TLispEntity**) ;
static	Boolean	lispMachine_jSearchJisyoFile (TLispMachine*, const Char*, int, int, TLispEntity**) ;
static	Boolean	lispMachine_jSearchJisyoFileSubr (const Char*, int, const Char*, int, Boolean, int, TVarbuffer*) ;
static	Boolean	lispMachine_jOkuriSearchSubr (TLispMachine*, const Char*, int, const Char*, int, TLispEntity**) ;
static	Boolean	lispMachine_makeCandidateVectorFromString (TLispManager*, TVarbuffer*, TLispEntity**) ;
static	Boolean	lispMachine_computeHenkanVectors (TLispMachine*, const Char*, int, const Char*, int, Boolean, Boolean, TLispEntity**) ;
static	Boolean	lispMachine_jVectorAdd (TLispMachine*, TLispEntity*, TLispEntity*, TLispEntity**) ;
static	Boolean	lispMachine_jVectorMem (TLispMachine*, TLispEntity*, TLispEntity*, Boolean*) ;
static	Boolean	lispMachine_getSkkServerList (TLispMachine*, TLispEntity**) ;

TLMRESULT
lispMachineState_JSearchServer (
	register TLispMachine*	pLM)
{
	register TLispManager*		pLispMgr	= pLM->m_pLispMgr ;
	register PSKKSERVERJISYO	pJisyo ;
	register TLispEntity*		pValServerList ;
	TLispEntity*				pValServerListOrg ;
	register TLMRESULT			lmResult	= LMR_RETURN ;
	TLispEntity*				pEntRetval ;

	if (TFAILED (lispMachine_getSkkServerList (pLM, &pValServerListOrg))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	pJisyo				= NULL ;
	pEntRetval			= NULL ;
	pValServerList		= pValServerListOrg ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pValServerList))) {
		TLispEntity*	pEntHost ;
		TLispEntity*	pEntCar ;
		TLispEntity*	pEntCdr ;
		const Char*		pStrHost ;
		int				nStrHost ;

		if (TFAILED (lispEntity_GetCar (pLispMgr, pValServerList, &pEntCar)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pValServerList, &pEntCdr)) ||
			TFAILED (lispEntity_GetCar (pLispMgr, pEntCar, &pEntHost))) {
			lispMachineCode_SetError (pLM) ;
			goto	exit_func ;
		}
		if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntHost, &pStrHost, &nStrHost)))
			goto	skip ;

		pJisyo	= SkkServerJisyo_Find (pStrHost, nStrHost) ;
		if (pJisyo == NULL) 
			pJisyo	= SkkServerJisyo_Register (pStrHost, nStrHost, 1178) ;

		if (pJisyo != NULL) {
			if (TFAILED (lispMachine_jSearchServerSubr (pLM, pJisyo, &pEntRetval))) {
				lispMachineCode_SetError (pLM) ;
				goto	exit_func ;
			}
			if (pEntRetval != NULL) 
				break ;
		}
	  skip:
		pValServerList	= pEntCdr ;
	}

	/*	ʤäФϼĴ٤ʤ褦ˤ롣
	 */
	if (pValServerList != NULL) {
		register TLispEntity*	pEntServerList ;

		pEntServerList	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_SKK_SERVER_LIST) ;
		lispMachine_SetCurrentSymbolValue (pLM, pEntServerList, pValServerList) ;
	}

	if (pEntRetval == NULL) {
		lmResult	= lispMachineState_JSearchJisyoFile (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	}
 exit_func:
	lispEntity_Release (pLispMgr, pValServerListOrg) ;
	return	lmResult ;
}

TLMRESULT
lispMachineState_JSearchJisyoFile (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntFile ;
	TLispEntity*	pEntLimit ;
	const Char*		pStrFile ;
	int				nStrFile ;
	long			lLimit ;
	TLispEntity*	pEntRetval ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntFile) ;

	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntFile))) {
		if (TFAILED (lispMgr_CreateVector (pLispMgr, NULL, 0, &pEntRetval)))
			return	LMR_ERROR ;
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_GetStringValue  (pLispMgr, pEntFile, &pStrFile, &nStrFile)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntLimit)) ||
		TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntLimit, &lLimit))) 
		goto	error ;

	if (TFAILED (lispMachine_jSearchJisyoFile (pLM, pStrFile, nStrFile, lLimit, &pEntRetval)))
		goto	error ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*
 *	٤ȡskk-jisyo (skkinput-jisyo ľ˸Ǥʤܤˤʤ
 *	) 顢겾̾Ԥ
 *
 *	ΤǡĥƤߤơ(j-okuri-search-subr jisyo) ȤƤߤ롣
 */
TLMRESULT
lispMachineState_JOkuriSearchSubr (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*			pEntArglist ;
	TLispEntity*			pEntJisyo ;
	TLispEntity*			pEntRetval ;
	const Char*				pStrJisyo ;
	int						nStrJisyo ;
	const Char*				pStrKey ;
	int						nStrKey ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntJisyo) ;
	if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntJisyo, &pStrJisyo, &nStrJisyo))) 
		goto	error ;

	if (TFAILED (lispMachine_skkGetSearchKey (pLM, &pStrKey, &nStrKey)))
		goto	error ;

	if (TFAILED (lispMachine_jOkuriSearchSubr (pLM, pStrJisyo, nStrJisyo, pStrKey, nStrKey, &pEntRetval)))
		goto	error ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*
 *	buffer ˼եɤ߹๽¤ǤϤʤˡcompletion  buffer 
 *	¤ǤϤʤ
 */
TLMRESULT
lispMachineState_JCompleteion (
	register TLispMachine*	pLM)
{
	return	LMR_ERROR ;
}


Boolean
lispMachine_skkOkuriArip (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntOkuriAri ;
	TLispEntity*			pValOkuriAri ;

	pEntOkuriAri	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_J_OKURI_ARI) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntOkuriAri, &pValOkuriAri)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pValOkuriAri)))
		return	False ;
	return	TFAILED (lispEntity_Nullp (pLispMgr, pValOkuriAri)) ;
}

Boolean
lispMachine_skkMergeAllEntryp (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntOkuriStrict ;
	TLispEntity*			pValOkuriStrict ;

	if (TFAILED (lispMachine_skkOkuriArip (pLM)))
		return	True ;

	pEntOkuriStrict	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_J_HENKAN_OKURI_STRICTLY) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntOkuriStrict, &pValOkuriStrict)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pValOkuriStrict)))
		return	True ;
	return	lispEntity_Nullp (pLispMgr, pValOkuriStrict) ;
}

Boolean
lispMachine_skkProcessOkuriEarlyp (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntEarly ;
	TLispEntity*			pValEarly ;

	pEntEarly	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_SKK_PROCESS_OKURI_EARLY) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntEarly, &pValEarly)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pValEarly)))
		return	False ;
	return	TFAILED (lispEntity_Nullp (pLispMgr, pValEarly)) ;
}

Boolean
lispMachine_skkGetOkurigana (
	register TLispMachine*	pLM,
	register const Char**	ppStrOkurigana,
	register int*			pnStrOkurigana)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntKey ;
	TLispEntity*	pValKey ;

	pEntKey	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_J_HENKAN_OKURIGANA) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntKey, &pValKey)))
		return	False ;
#if defined (DEBUG)
	fprintf (stderr, "j-henkan-okurigana = ") ;
	lispEntity_Print (pLispMgr, pValKey) ;
	fprintf (stderr, "\n") ;
#endif
	if (TFAILED (lispEntity_GetStringValue (pLispMgr, pValKey, ppStrOkurigana, pnStrOkurigana)))
		return	False ;
	return	True ;
}

Boolean
lispMachine_skkGetSearchKey (
	register TLispMachine*	pLM,
	register const Char**	ppStrKey,
	register int*			pnStrKey)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register Boolean		fOkuriAri ;
	register TLispEntity*	pEntKey ;
	TLispEntity*			pValKey ;

	fOkuriAri	= lispMachine_skkOkuriArip (pLM) ;
	if (fOkuriAri) {
		pEntKey	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_J_HENKAN_KEY) ;
	} else {
		pEntKey	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_J_SEARCH_KEY) ;
	}
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntKey, &pValKey)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pValKey, ppStrKey, pnStrKey)))
		return	False ;
#if defined (DEBUG)
	fprintf (stderr, "j-henkan-key or j-search-key = ") ;
	lispEntity_Print (pLispMgr, pValKey) ;
	fprintf (stderr, "\n") ;
#endif
	return	True ;
}

Boolean
lispMachine_jSearchServerSubr (
	register TLispMachine*		pLM,
	register PSKKSERVERJISYO	pJisyo,
	register TLispEntity**		ppEntRetval)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TVarbuffer		vbuf ;
	const Char*		pStrKey ;
	int				nStrKey ;
	const Char*		pStrResult ;
	int				nStrResult ;
	const Char*		pStrOkurigana ;
	int				nStrOkurigana ;
	Boolean			fOkuriAri ;
	TLispEntity*	pEntRetval ;

	fOkuriAri	= lispMachine_skkOkuriArip (pLM) ;
	if (TFAILED (lispMachine_skkGetSearchKey (pLM, &pStrKey, &nStrKey)))
		goto	error ;

	TVarbuffer_Initialize (&vbuf, sizeof (Char)) ;
	if (TFAILED (SkkServerJisyo_Search (pJisyo, pStrKey, nStrKey, &vbuf))) {
		/*	м open ˼Ԥν*/
		pEntRetval	= NULL ;
		goto	exit_func ;
	}
	if (fOkuriAri) {
		if (TFAILED (lispMachine_skkGetOkurigana  (pLM, &pStrOkurigana, &nStrOkurigana)))
			goto	error ;
	} else {
		pStrOkurigana	= NULL ;
		nStrOkurigana	= 0 ;
	}
	pStrResult	= TVarbuffer_GetBuffer (&vbuf) ;
	nStrResult	= TVarbuffer_GetUsage (&vbuf) ;
	if (nStrResult <= 0) {
		lispMgr_CreateVector (pLispMgr, NULL, 0, &pEntRetval) ;
	} else {
		Boolean			fOkuriEarly ;
		TLispEntity*	pEnt0th ;
		TLispEntity*	pEnt2th ;
		
		fOkuriEarly	= lispMachine_skkProcessOkuriEarlyp (pLM) ;
		if (TFAILED (lispMachine_computeHenkanVectors (pLM, pStrResult, nStrResult, pStrOkurigana, nStrOkurigana, fOkuriAri, fOkuriEarly, &pEntRetval))) 
			goto	error ;
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
		if (TSUCCEEDED (lispMachine_skkMergeAllEntryp (pLM))) {
			lispEntity_GetCar   (pLispMgr, pEntRetval, &pEnt0th) ;
			lispEntity_GetCaddr (pLispMgr, pEntRetval, &pEnt2th) ;
			lispMachine_jVectorAdd (pLM, pEnt0th, pEnt2th, &pEntRetval) ;
		} else {
			lispEntity_GetCaddr (pLispMgr, pEntRetval, &pEntRetval) ;
		}
	}
  exit_func:
	TVarbuffer_Uninitialize (&vbuf) ;
	*ppEntRetval	= pEntRetval ;
	return	True ;

  error:
	TVarbuffer_Uninitialize (&vbuf) ;
	return	False ;
}

Boolean
lispMachine_jSearchJisyoFile (
	register TLispMachine*	pLM,
	register const Char*	pStrFile,
	register int			nStrFile,
	register int			nLimit,
	register TLispEntity**	ppEntRetval)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TVarbuffer		vbuf ;
	const Char*		pStrKey ;
	int				nStrKey ;
	const Char*		pStrResult ;
	int				nStrResult ;
	const Char*		pStrOkurigana ;
	int				nStrOkurigana ;
	Boolean			fOkuri ;
	Boolean			fOkuriEarly ;
	TLispEntity*	pEnt0th ;
	TLispEntity*	pEnt2th ;
	TLispEntity*	pEntRetval ;

	if (TFAILED (TVarbuffer_Initialize (&vbuf, sizeof (Char))))
		goto	error ;
	fOkuri	= lispMachine_skkOkuriArip (pLM) ;
	if (TFAILED (lispMachine_skkGetSearchKey (pLM, &pStrKey, &nStrKey)))
		goto	error ;
	if (TFAILED (lispMachine_jSearchJisyoFileSubr (pStrFile, nStrFile, pStrKey, nStrKey, fOkuri, nLimit, &vbuf)))
		goto	error ;
	if (fOkuri) {
		if (TFAILED (lispMachine_skkGetOkurigana  (pLM, &pStrOkurigana, &nStrOkurigana)))
			goto	error ;
		fOkuriEarly		= lispMachine_skkProcessOkuriEarlyp (pLM) ;
	} else {
		pStrOkurigana	= NULL ;
		nStrOkurigana	= 0 ;
		fOkuriEarly		= False ;
	}
	pStrResult	= TVarbuffer_GetBuffer (&vbuf) ;
	nStrResult	= TVarbuffer_GetUsage  (&vbuf) ;
	if (TFAILED (lispMachine_computeHenkanVectors (pLM, pStrResult, nStrResult, pStrOkurigana, nStrOkurigana, fOkuri, fOkuriEarly, &pEntRetval))) 
		goto	error ;
	if (TSUCCEEDED (lispMachine_skkMergeAllEntryp (pLM))) {
		lispEntity_GetCar   (pLispMgr, pEntRetval, &pEnt0th) ;
		lispEntity_GetCaddr (pLispMgr, pEntRetval, &pEnt2th) ;
		lispMachine_jVectorAdd (pLM, pEnt2th, pEnt0th, &pEntRetval) ;
	} else {
		lispEntity_GetCaddr (pLispMgr, pEntRetval, &pEntRetval) ;
	}
	TVarbuffer_Uninitialize (&vbuf) ;
	*ppEntRetval	= pEntRetval ;
	return	True ;

  error:
	TVarbuffer_Uninitialize (&vbuf) ;
	return	False ;
}

Boolean
lispMachine_jSearchJisyoFileSubr (
	register const Char*	pStrFile,
	register int			nStrFile,
	register const Char*	pStrKey,
	register int			nStrKey,
	register Boolean		fOkuri,
	register int			nLimit,
	register TVarbuffer*	pvbuf)
{
	if (nLimit > 0) {
		register PSKKSORTEDJISYO	pJisyo ;

		pJisyo	= SkkSortedJisyo_Find (pStrFile, nStrFile) ;
		if (pJisyo == NULL) {
			pJisyo	= SkkSortedJisyo_Register (pStrFile, nStrFile, -1) ;
			if (pJisyo == NULL)
				return	False ;
		}
		if (TFAILED (SkkSortedJisyo_Search (pJisyo, pStrKey, nStrKey, fOkuri, pvbuf)))
			return	False ;
	} else {
		register PSKKJISYO	pJisyo ;

		pJisyo	= SkkJisyo_Find (pStrFile, nStrFile) ;
		if (pJisyo == NULL) {
			pJisyo	= SkkJisyo_Register (pStrFile, nStrFile, -1) ;
			if (pJisyo == NULL)
				return	False ;
		}
		if (TFAILED (SkkJisyo_Search (pJisyo, pStrKey, nStrKey, fOkuri, pvbuf)))
			return	False ;
	}
	return	True ;
}

Boolean
lispMachine_jOkuriSearchSubr (
	register TLispMachine*	pLM,
	register const Char*	pStrFile,
	register int			nStrFile,
	register const Char*	pStrHenkanKey,
	register int			nStrHenkanKey,
	register TLispEntity**	ppEntRetval)
{
	TVarbuffer			vbuf ;
	register PSKKJISYO	pJisyo ;
	register Boolean	fRetval	= False ;

	pJisyo	= SkkJisyo_Find (pStrFile, nStrFile) ;
	if (pJisyo == NULL) {
		pJisyo	= SkkJisyo_Register (pStrFile, nStrFile, -1) ;
		if (pJisyo == NULL)
			return	False ;
	}
	TVarbuffer_Initialize (&vbuf, sizeof (Char)) ;
	if (TFAILED (SkkJisyo_OkuriSearch (pJisyo, pStrHenkanKey, nStrHenkanKey, &vbuf)))
		goto	error ;
	fRetval	= lispMachine_makeCandidateVectorFromString (pLM->m_pLispMgr, &vbuf, ppEntRetval) ;
  error:
	TVarbuffer_Uninitialize (&vbuf) ;
	return	fRetval ;
}

Boolean
lispMachine_makeCandidateVectorFromString (
	register TLispManager*	pLispMgr,
	register TVarbuffer*	pvbuf,
	register TLispEntity**	ppEntReturn)
{
	TVarbuffer				vbufEnt ;
	register const Char*	pCh	;
	register const Char*	pHead ;
	register int			nCh ;
	register int			nUse ;
	register Boolean		fRetval	= False ;
	TLispEntity*			pEntString ;
	TLispEntity*			pEntVector ;
	register TLispEntity**	ppEntElement ;
	register int			nEntElement ;

	if (TFAILED (TVarbuffer_Initialize (&vbufEnt, sizeof (TLispEntity*))))
		return	False ;

	pCh	= TVarbuffer_GetBuffer (pvbuf) ;
	nCh	= TVarbuffer_GetUsage  (pvbuf) ;
	pHead	= pCh ;

	while (nCh > 0) {
		while (nCh > 0 && *pCh != '/') {
			pCh	++ ;
			nCh -- ;
		}
		nUse	= pCh - pHead ;
		if (nUse > 0) {
			if (TFAILED (lispMgr_CreateString (pLispMgr, pHead, nUse, &pEntString)) ||
				TFAILED (TVarbuffer_Add (&vbufEnt, &pEntString, 1))) {
				nCh	= -1 ;
				break;
			}
			lispEntity_AddRef (pLispMgr, pEntString) ;
		}
		if (nCh > 0) {
			pCh	++ ;
			nCh -- ;
			pHead	= pCh ;
		}
	}

	ppEntElement	= TVarbuffer_GetBuffer (&vbufEnt) ;
	nEntElement		= TVarbuffer_GetUsage  (&vbufEnt) ;
	if (nCh == 0)
		fRetval	= lispMgr_CreateVector (pLispMgr, ppEntElement, nEntElement, &pEntVector) ;
	while (nEntElement -- > 0) {
		lispEntity_Release (pLispMgr, *ppEntElement ++) ;
	}
	TVarbuffer_Uninitialize (&vbufEnt) ;
	return	fRetval ;
}

/*
 *	skk8.6  j-compute-henkan-vectors  C ѴΡ
 *	ȤȤ buffer-substring Ѥ current-buffer 
 *	оݤˤƤϤ buffer ¸
 *	ƤʤȤͳʸФƽԤ
 *	ˤƤ롣
 */
Boolean
lispMachine_computeHenkanVectors (
	register TLispMachine*	pLM,
	register const Char*	pString,
	register int			nString,
	register const Char*	pOkurigana,
	register int			nOkurigana,
	register Boolean		fOkuriAri,
	register Boolean		fSkkProcessOkuriEarly,
	register TLispEntity**	ppEntRetval)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TVarbuffer				vbufV [4] ;
	TLispEntity*			apEntVector [4] ;
	TLispEntity*			pEntity ;
	register int			i ;
	register int			nStage ;
	register Boolean		fContinue ;
	register Boolean		fRetval ;

	for (i = 0 ; i < 4 ; i ++)
		if (TFAILED (TVarbuffer_Initialize (&vbufV [i], sizeof (TLispEntity*))))
			return	False ;

	/*	ֺǽ ``/'' ɤФɬפ롣*/
	if (*pString == '/') {
		pString	++ ;
		nString	-- ;
	}
	nStage		= 1 ;
	fContinue	= True ;
	while (fContinue && nString > 0) {
		register const Char*	pItem ;
		register int			nItem ;
		register const Char*	ptr ;
		register int			nptr ;

		ptr		= pString ;
		nptr	= nString ;
		while (nptr > 0 && *ptr != '/') {
			ptr	++ ;
			nptr -- ;
		}
		pItem	= pString ;
		nItem	= ptr - pString ;
		pString	= ptr  + 1 ;
		nString	= nptr - 1 ;
		if (TFAILED (fOkuriAri)) {
			if (fSkkProcessOkuriEarly && (nItem > 0 && *pItem == '[')) {
				fContinue	= False ;
				continue ;
			}
		}
		if (TFAILED (lispMgr_CreateString (pLispMgr, pItem, nItem, &pEntity)))
			return	False ;
		lispEntity_AddRef (pLispMgr, pEntity) ;

		if (TFAILED (fOkuriAri)) {
			TVarbuffer_Add (&vbufV [0], &pEntity, 1) ;
		} else if (nItem > 0 && *pItem == '[' && nStage <= 2) {
			if (nOkurigana == (nItem - 1) && 
				!Cstrncmp (pItem + 1, pOkurigana, nOkurigana)) {
				nStage	= 3 ;
			} else {
				nStage	= 2 ;
			}
			TVarbuffer_Add (&vbufV [1], &pEntity, 1) ;
		} else if (nItem > 0 && *pItem == ']' && nStage == 3) {
			nStage	= 4 ;
			TVarbuffer_Add (&vbufV [3], &pEntity, 1) ;
		} else if (nStage == 1) {
			TVarbuffer_Add (&vbufV [0], &pEntity, 1) ;
		} else if (nStage == 2) {
			TVarbuffer_Add (&vbufV [1], &pEntity, 1) ;
		} else if (nStage == 3) {
			TVarbuffer_Add (&vbufV [2], &pEntity, 1) ;
		} else if (nStage == 4) {
			TVarbuffer_Add (&vbufV [3], &pEntity, 1) ;
		}
	}
	for (i = 0 ; i < 4 ; i ++) {
		register TLispEntity**	ppEntity ;
		register int			nEntity ;

		ppEntity	= TVarbuffer_GetBuffer (&vbufV [i]) ;
		nEntity		= TVarbuffer_GetUsage  (&vbufV [i]) ;

		if (TFAILED (lispMgr_CreateVector (pLispMgr, ppEntity, nEntity, &apEntVector [i])))
			return	False ;
		lispEntity_AddRef (pLispMgr, apEntVector [i]) ;

		while (nEntity -- > 0) 
			lispEntity_Release (pLispMgr, *ppEntity ++) ;
	}
	fRetval	= lispMgr_CreateList (pLispMgr, apEntVector, 4, ppEntRetval) ;
	for (i = 0 ; i < 4 ; i ++) 
		lispEntity_Release (pLispMgr, apEntVector [i]) ;
	return	fRetval ;
}

Boolean
lispMachine_jVectorAdd (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntU,
	register TLispEntity*	pEntV,
	register TLispEntity**	ppEntRetval)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TVarbuffer		vbuf ;
	TLispEntity**	ppEntU ;
	int				lu ;
	TLispEntity**	ppEntV ;
	int				lv ;
	Boolean			fRetval ;
	register int	i ;

	if (TFAILED (TVarbuffer_Initialize     (&vbuf, sizeof (TLispEntity*))) ||
		TFAILED (lispEntity_GetVectorValue (pLispMgr, pEntU, &ppEntU, &lu)) ||
		TFAILED (TVarbuffer_Add            (&vbuf, ppEntU, lu)))
		return	False ;
	if (TFAILED (lispEntity_GetVectorValue (pLispMgr, pEntV, &ppEntV, &lv)))
		return	False ;
	for (i = 0 ; i < lv ; i ++) {
		if (TFAILED (lispMachine_jVectorMem (pLM, *ppEntV, pEntU, &fRetval)))
			return	False ;
		if (TFAILED (fRetval)) {
			if (TFAILED (TVarbuffer_Add (&vbuf, ppEntV, 1)))
				return	False ;
		}
		ppEntV	++ ;
	}
	fRetval	= lispMgr_CreateVector (pLispMgr, TVarbuffer_GetBuffer (&vbuf), TVarbuffer_GetUsage (&vbuf), ppEntRetval) ;
	TVarbuffer_Uninitialize (&vbuf) ;
	return	fRetval ;
}

Boolean
lispMachine_jVectorMem (
	register TLispMachine*		pLM,
	register TLispEntity*		pEntE,
	register TLispEntity*		pEntV,
	register Boolean*			pfRetval)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register int			i ;
	TLispEntity**	ppEntity ;
	int				l ;
	const Char*		pStr ;
	int				nStr ;
	const Char*		pStrE ;
	int				nStrE ;


	if (TFAILED (lispEntity_GetVectorValue (pLispMgr, pEntV, &ppEntity, &l)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntE, &pStrE, &nStrE)))
		return	False ;
	for (i = 0 ; i < l ; i ++) {
		if (TFAILED (lispEntity_GetStringValue (pLispMgr, *ppEntity ++, &pStr, &nStr)))
			return	False ;
		if (nStr == nStrE && !Cstrncmp (pStr, pStrE, nStrE)) {
			*pfRetval	= True ;
			return	True ;
		}
	}
	*pfRetval	= False ;
	return	True ;
}

/*	ǳݤ줿 ServerList פˤʤä release 뤳ȡ
 */
Boolean
lispMachine_getSkkServerList (
	register TLispMachine*	pLM,
	register TLispEntity**	ppValServerList)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntServerList ;
	register TLispEntity*	pEntServerHost ;
	TLispEntity*	pValServerList ;
	TLispEntity*	pValServerHost ;
	TLispEntity*	pEntity ;
	TLispEntity*	pEntNil ;

	assert (pLM != NULL) ;
	assert (ppValServerList != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	pEntServerList	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_SKK_SERVER_LIST) ;
	assert (pEntServerList != NULL) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntServerList, &pValServerList)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pValServerList))) 
		return	False ;
	if (TFAILED (lispEntity_Nullp (pLispMgr, pValServerList))) 
		goto	exit_func ;

	pEntServerHost	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_SKK_SERVER_HOST) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntServerHost, &pValServerHost)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pValServerHost)) ||
		TSUCCEEDED (lispEntity_Nullp (pLispMgr, pValServerHost)))
		goto	exit_func ;

	if (TFAILED (lispMgr_CreateNil (pLispMgr, &pEntNil)) ||
		TFAILED (lispMgr_CreateConscell (pLispMgr, pValServerHost, pEntNil, &pEntity)) ||
		TFAILED (lispMgr_CreateList (pLispMgr, &pEntity, 1, &pValServerList)))
		return	False ;
	
 exit_func:
	assert (pValServerList != NULL) ;
	lispEntity_AddRef (pLispMgr, pValServerList) ;
#if defined (DEBUG)
	fprintf (stderr, "skk-server-list = ") ;
	lispEntity_Print (pLispMgr, pValServerList) ;
	fprintf (stderr, "\n") ;
#endif
	*ppValServerList	= pValServerList ;
	return	True ;
}

