#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*
 *	(transporse-chars ARG)
 */
TLMRESULT
lispMachineState_TransposeChars (
	register TLispMachine* pLM)
{
	return	LMR_RETURN ;
}

/*
 */
TLMRESULT
lispMachineState_SetMark (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntPOS ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntMark ;

	assert (pLM      != NULL) ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	lispMachineCode_GetCurrentBuffer (pLM, &pEntBuffer) ;
	lispEntity_GetCar     (pLispMgr, pEntArglist, &pEntPOS) ;
	lispBuffer_MarkMarker (pLispMgr, pEntBuffer, &pEntMark) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntPOS))) {
		/*	nil $B$J$i%P%C%U%!$+$i<h$j=|$/!#(B*/
		lispBuffer_RemoveMarker (pLispMgr, pEntMark) ;
	} else {
		TLispNumber		numPOS ;
		register int	nPOS ;
		int				nBufferTop, nBufferEnd ;

		if (TFAILED (lispEntity_GetNumberValueOrMarkerPosition (pLispMgr, pEntPOS, &numPOS)) ||
			numPOS.m_fFloatp) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
		nPOS	= numPOS.m_Value.m_lLong ;
		/*	$B%P%C%U%!$KDI2C$7$F!"(B*/
		lispBuffer_AddMarker (pLispMgr, pEntBuffer, pEntMark) ;
		/*	$B%P%C%U%!Fb$N0LCV$rD4@0$9$k!#(B*/
		lispBuffer_PointBufferTop (pLispMgr, pEntBuffer, &nBufferTop) ;
		lispBuffer_PointBufferEnd (pLispMgr, pEntBuffer, &nBufferEnd) ;
		if (nPOS < nBufferTop)
			nPOS	= nBufferTop ;
		if (nPOS > nBufferEnd)
			nPOS	= nBufferEnd ;
		lispMarker_SetBufferPosition (pLispMgr, pEntMark, pEntBuffer, nPOS) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntMark) ;
	return	LMR_RETURN ;
}

/*	(mark &optional FORCE)
 */
TLMRESULT
lispMachineState_Mark (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntCurBuffer ;
	TLispEntity*	pEntMark ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntFORCE ;
	int				nPos ;
	TLispEntity*	pEntRetval ;

	assert (pLM      != NULL) ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	lispMachineCode_GetCurrentBuffer (pLM, &pEntCurBuffer) ;
	assert (pEntCurBuffer != NULL) ;
	lispEntity_GetCar     (pLispMgr, pEntArglist, &pEntFORCE) ;
	lispBuffer_MarkMarker (pLispMgr, pEntCurBuffer, &pEntMark) ;
	assert (pEntMark != NULL) ;
	lispMarker_GetBufferPosition (pLispMgr, pEntMark, &pEntBuffer, &nPos) ;
	if (pEntBuffer != pEntCurBuffer || nPos < 1) {
		/*	inactive */
		if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntFORCE))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	} else {
		/*	active */
		if (TFAILED (lispMgr_CreateInteger (pLispMgr, nPos, &pEntRetval)))
			return	LMR_ERROR ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

/*	(count-lines START END)
 */
TLMRESULT
lispMachineState_CountLines (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*		pEntArglist ;
	TLispEntity*		pEntCurBuffer ;
	TLispEntity*		pEntSTART ;
	TLispEntity*		pEntEND ;
	TLispEntity*		pEntRetval ;
	TBufStringMarker	mk ;
	register Char		cc ;
	TLispNumber			numSTART, numEND ;
	register int		nStart, nEnd, nUsage, nLines ;
	int					nBufferTop, nBufferEnd, nLength ;

	assert (pLM      != NULL) ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	assert (pEntArglist != NULL) ;
	lispMachineCode_GetCurrentBuffer (pLM, &pEntCurBuffer) ;
	assert (pEntCurBuffer != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntSTART)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pEntArglist, &pEntEND)) ||
		TFAILED (lispEntity_GetNumberValueOrMarkerPosition (pLispMgr, pEntSTART, &numSTART)) ||
		numSTART.m_fFloatp ||
		TFAILED (lispEntity_GetNumberValueOrMarkerPosition (pLispMgr, pEntEND,   &numEND)) ||
		numEND.m_fFloatp) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	nStart	= numSTART.m_Value.m_lLong ;
	nEnd	= numEND.m_Value.m_lLong ;

	lispBuffer_GetFullString  (pLispMgr, pEntCurBuffer, &mk, &nLength) ;
	lispBuffer_PointBufferTop (pLispMgr, pEntCurBuffer, &nBufferTop) ;
	lispBuffer_PointBufferEnd (pLispMgr, pEntCurBuffer, &nBufferEnd) ;
	if (nEnd < nBufferTop || nStart> nEnd || nStart > nBufferEnd) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}

	TBufStringMarker_Forward (&mk, nStart - nBufferTop) ;
	nUsage	= nEnd - nStart ;
	nLines	= 0 ;
	while (nUsage -- > 0) {
		cc		= TBufStringMarker_GetChar (&mk) ;
		TBufStringMarker_Forward (&mk, 1) ;
		if (cc == '\n' || cc == '\r') 
			nLines	++ ;
	}
	if (TFAILED (lispMgr_CreateInteger (pLispMgr, nLines, &pEntRetval)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}
