#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

TLMRESULT
lispMachineState_QueueCreate (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pQueue ;
	TLispEntity*	pNil ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pTail ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	
	lispMgr_CreateNil (pLispMgr, &pNil) ;
	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pNil, pNil, &pQueue)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pQueue) ;
	if (TFAILED (lispMgr_InternSymbolA (pLispMgr, "QUEUE", 5, &pSymbol)))
		return	LMR_ERROR ;
	lispEntity_SetCar (pLispMgr, pQueue, pSymbol) ;
	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pNil, pNil, &pTail)))
		return	LMR_ERROR ;
	lispEntity_SetCdr (pLispMgr, pQueue, pTail) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_QueueAll (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pQueue ;
	TLispEntity*	pRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	assert (pArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pQueue)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pQueue, &pRetval))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pRetval) ;
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_QueueEnqueue (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pQueue ;
	TLispEntity*	pQueueCdr ;
	TLispEntity*	pQueueCadr ;
	TLispEntity*	pQueueCddr ;
	TLispEntity*	pNil ;
	TLispEntity*	pElt ;
	TLispEntity*	pElementcell ;

	pLispMgr	= pLM->m_pLispMgr ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	assert (pArglist != NULL) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pQueue)) ||
		TFAILED (lispEntity_Listp   (pLispMgr, pQueue)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pArglist, &pElt))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispEntity_GetCdr (pLispMgr, pQueue, &pQueueCdr)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pQueue, &pQueueCadr))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMgr_CreateNil (pLispMgr, &pNil) ;
	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pElt, pNil, &pElementcell)))
		return	LMR_ERROR ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pQueueCadr))) {
		lispEntity_SetCdr (pLispMgr, pQueueCdr, pElementcell) ;
		lispEntity_SetCar (pLispMgr, pQueueCdr, pElementcell) ;
	} else {
		if (TFAILED (lispEntity_GetCddr (pLispMgr, pQueue, &pQueueCddr))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
		lispEntity_SetCdr (pLispMgr, pQueueCddr, pElementcell) ;
		lispEntity_SetCdr (pLispMgr, pQueueCdr,  pElementcell) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pElementcell) ;
	return	LMR_RETURN ;
}

