#include "AfxWin.h"
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include <time.h>
#include <sys/time.h>
#include "lmachinep.h"

static	TLMRESULT	lispMachineState_sitForStep		(TLispMachine*) ;
static	TLMRESULT	lispMachineState_sitForFinalize	(TLispMachine*) ;

/*	built-in function:
 *		(ding)
 *
 *	٥Ĥ餹
 */
TLMRESULT
lispMachineState_Ding (
	register TLispMachine*	pLM)
{
	return	LMR_RETURN ;
}

/*	built-in function:
 *		(make-character charset code1 code2)
 *
 *	괺Ŭ˼롣skk8.6 򸫤 EUC-JP 
 *	charset  lc-jp Τ褦EUC-JP ä charset 
 *	Τ
 */
TLMRESULT
lispMachineState_MakeCharacter (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntCharset ;
	TLispEntity*	pEntCode ;
	long			lCode ;
	long			lCharset ;
	unsigned long	uCode ;
	Char			cc ;
	TLispEntity*	pEntRetval ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntCharset) ;
	if (TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntCharset, &lCharset)))
		goto	error ;
	if (lCharset < KCHARSET_ASCII || lCharset >= MAX_CHARSET)
		goto	error ;
	lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist) ;

	uCode	= 0 ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntArglist))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntCode)) ||
			TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntCode, &lCode)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist)))
			goto	error ;
		uCode	= (uCode << 8) | (unsigned char)lCode ;
	}
	/*	94 ʸ 96 ʸΰ㤤դƥޥ򤫤롣
	 *	ꤵƤΤȹͤ
	 */
	if (lCharset == KCHARSET_ASCII) {
		cc	= Char_Make (lCharset, uCode & 0x7F) ;
	} else if (KCHARSET_JISX0208_1978 <= lCharset && lCharset <= KCHARSET_JISX0212_1990) {
		cc	= Char_Make (lCharset, uCode & 0x7F7F) ;
	} else {
		cc	= Char_Make (lCharset, uCode) ;
	}
	if (TFAILED (lispMgr_CreateInteger (pLispMgr, cc, &pEntRetval)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*	built-in function:
 *		(current-time-string &optional SPECIFIED-TIME)
 *
 *	ʹ֤ɤʸη current time ֤
 *	եޥåȤ `Sun Sep 16 01:03:52 1973' Ǥ롣
 *	⤷Ϳ줿顢current time ˤλ
 *	եޥåȤ롣
 */
TLMRESULT
lispMachineState_CurrentTimeString (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntTime ;
	time_t			t ;
	char			achBuffer [256] ;
	Char			aChBuffer [256] ;
	const char*		pStrTime ;
	TLispEntity*	pEntRetval ;
	register int	nLength ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntTime) ;
	if (TFAILED (lispEntity_Nullp (pLispMgr, pEntTime))) {
		TLispEntity	*pEntHigh, *pEntLow ;
		long		lHigh, lLow ;

		if (TFAILED (lispEntity_Consp (pLispMgr, pEntTime)))
			goto	error ;
		lispEntity_GetCar (pLispMgr, pEntTime, &pEntHigh) ;
		lispEntity_GetCdr (pLispMgr, pEntTime, &pEntLow) ;
		if (TSUCCEEDED (lispEntity_Consp (pLispMgr, pEntLow)))
			lispEntity_GetCar (pLispMgr, pEntLow, &pEntLow) ;
		if (TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntHigh, &lHigh)) ||
			TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntLow,  &lLow)))
			goto	error ;
		t	= ((unsigned long)lHigh & 0xFFFF) << 16 | ((unsigned long)lLow & 0xFFFF) ;
	} else {
		t	= time (NULL) ;
	}
	pStrTime	= ctime (&t) ;
	if (pStrTime == NULL)
		goto	error ;
	strncpy (achBuffer, pStrTime, sizeof (achBuffer) - 1) ;
	achBuffer [sizeof (achBuffer) - 1]	= '\0' ;
	nLength		= strlen (achBuffer) ;
	while (nLength > 0 && (achBuffer [nLength - 1] == '\n' || achBuffer [nLength - 1] == '\r'))
		nLength	-- ;
	achBuffer [nLength]	= '\0' ;
	strtocstr (aChBuffer, pStrTime, nLength) ;
	aChBuffer [nLength]	= '\0' ;
	if (TFAILED (lispMgr_CreateString (pLispMgr, aChBuffer, Cstrlen (aChBuffer), &pEntRetval)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;

  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*
 */
TLMRESULT
lispMachineState_SitFor (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	register Boolean		fEnableInterval	= True ;
	TLispEntity*			pEntArglist ;
	TLispEntity*			pEntSeconds ;
	TLispEntity*			pEntNodisp ;
	long					lSec = 0, lMsec = 0 ;
	struct timeval			tv ;

	pLispMgr	= pLM->m_pLispMgr ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntSeconds)) ||
		TFAILED (lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TSUCCEEDED (lispEntity_Tp (pLispMgr, pEntSeconds))) {
		fEnableInterval	= False ;
	} else {
		if (TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntSeconds, &lSec))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
	}
	if (TFAILED (lispEntity_Nullp (pLispMgr, pEntArglist))) {
		TLispEntity*	pEntMsec ;

		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntMsec)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist)) ||
			TFAILED (lispEntity_GetCar (pLispMgr, pEntArglist, &pEntNodisp))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
		if (TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntMsec, &lMsec))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
	} else {
		/*	set nil */
		lispMgr_CreateNil (pLispMgr, &pEntNodisp) ;
	}

	lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PushVReg (pLM, LM_VREG_1) ;
	lispMachineCode_PushVReg (pLM, LM_VREG_2) ;
	lispMachineCode_PushVReg (pLM, LM_VREG_3) ;

	lispMachineCode_SetLReg  (pLM, LM_LREG_1, pEntNodisp) ;
	lispMachineCode_SetVRegI (pLM, LM_VREG_1, fEnableInterval) ;
	if (fEnableInterval) {
		gettimeofday (&tv, NULL) ;
		tv.tv_sec	+= lSec ;
		tv.tv_usec	+= lMsec * 1000 ;
		lispMachineCode_SetVRegI (pLM, LM_VREG_2, tv.tv_sec) ;
		lispMachineCode_SetVRegI (pLM, LM_VREG_3, tv.tv_usec) ;
	}
	lispMachineCode_SetState (pLM, lispMachineState_sitForStep) ;
	if (fEnableInterval) {
		return	LMR_TICK ;
	} else {
		return	LMR_SUSPEND ;
	}
}

TLMRESULT
lispMachineState_sitForStep (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntEvents ;
	TLispEntity*	pValEvents ;
	struct timeval	tv ;
	long			lSec, lUSec, lEnableInterval ;

	pEntEvents	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_UNREAD_COMMAND_EVENTS) ;
	assert (pEntEvents != NULL) ;
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntEvents, &pValEvents)) ||
		TFAILED (lispEntity_Nullp (pLispMgr, pValEvents))) {
		lispMachineCode_SetState (pLM, lispMachineState_sitForFinalize) ;
		lispMachineCode_SetVRegI (pLM, LM_VREG_1, 0) ;
		return	LMR_CONTINUE ;
	}

	lispMachineCode_GetVRegI (pLM, LM_VREG_1, &lEnableInterval) ;
#if defined (DEBUG)
	fprintf (stderr, "(sit-for-step %ld)\n", lEnableInterval) ;
#endif
	if (lEnableInterval <= 0)
		return	LMR_TICK ;
	lispMachineCode_GetVRegI (pLM, LM_VREG_2, &lSec) ;
	lispMachineCode_GetVRegI (pLM, LM_VREG_3, &lUSec) ;
	gettimeofday (&tv, NULL) ;
#if defined (DEBUG)
	fprintf (stderr, "(%ld, %ld) <> (%ld, %ld)\n", tv.tv_sec, tv.tv_usec, lSec, lUSec) ;
#endif
	if (tv.tv_sec > lSec || (tv.tv_sec == lSec && tv.tv_usec >= lUSec)) {
		lispMachineCode_SetState (pLM, lispMachineState_sitForFinalize) ;
		return	LMR_CONTINUE ;
	}
#if defined (DEBUG)
	fprintf (stderr, "(sit-for-step) returns tick\n") ;
#endif
	return	LMR_TICK ;
}

TLMRESULT
lispMachineState_sitForFinalize (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntRetval ;
	TLispEntity*	pEntNodisp ;
	long			lEnableInterval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;

	lispMachineCode_GetVRegI (pLM, LM_VREG_1, &lEnableInterval) ;
	if (lEnableInterval) {
		lispMgr_CreateT   (pLispMgr, &pEntRetval) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	}

	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pEntNodisp) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntNodisp))) {
		/*	ľɬס*/
		lispMachine_UpdateAllFrame (pLM) ;
	}

	lispMachineCode_PopLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PopVReg (pLM, LM_VREG_3) ;
	lispMachineCode_PopVReg (pLM, LM_VREG_2) ;
	lispMachineCode_PopVReg (pLM, LM_VREG_1) ;

	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

