#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

/*
 *	(make-marker)
 *
 *	ؤʤޡ򿷤ä֤
 */
TLMRESULT
lispMachineState_MakeMarker (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntMarker ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	if (TFAILED (lispMgr_CreateMarker (pLispMgr, &pEntMarker)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntMarker) ;
	return	LMR_RETURN ;
}

/*
 *
 *(*)
 *	move-marker  set-marker  alias Ǥ롣
 */
TLMRESULT
lispMachineState_SetMarker (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMarker ;
	TLispEntity*	pEntPosition ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntMkBuffer ;
	TLispNumber		pos ;
	int				nPointBufferTop, nPointBufferEnd ;
	register int	nPos ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntMarker) ;
	if (TFAILED (lispEntity_Markerp (pLispMgr, pEntMarker)))
		goto	error_return ;
	lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntPosition) ;

	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntPosition))) {
		lispMarker_GetBufferPosition (pLispMgr, pEntMarker, &pEntMkBuffer, NULL) ;
		if (pEntMkBuffer != NULL)
			lispBuffer_RemoveMarker (pLispMgr, pEntMarker) ;
		pEntBuffer	= NULL ;
		nPos		= 0 ;
	} else {
		if (TFAILED (lispEntity_GetNumberValueOrMarkerPosition (pLispMgr, pEntPosition, &pos)) ||
			pos.m_fFloatp)
			goto	error_return ;
		lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist) ;
		lispEntity_GetCar (pLispMgr, pEntArglist, &pEntBuffer) ;
		if (TFAILED (lispEntity_Bufferp (pLispMgr, pEntBuffer))) {
			if (TFAILED (lispEntity_Nullp (pLispMgr, pEntBuffer))) 
				goto	error_return ;
			lispMachineCode_GetCurrentBuffer (pLM, &pEntBuffer) ;
		}
		lispBuffer_PointBufferTop (pLispMgr, pEntBuffer, &nPointBufferTop) ;
		lispBuffer_PointBufferEnd (pLispMgr, pEntBuffer, &nPointBufferEnd) ;
		nPos	= pos.m_Value.m_lLong ;
		if (nPos < nPointBufferTop)
			nPos	= nPointBufferTop ;
		if (nPos > nPointBufferEnd)
			nPos	= nPointBufferEnd ;
#if defined (DEBUG)
		fprintf (stderr, "set-marker: top, end, pos = %d, %d, %d\n", 
				 nPointBufferTop, nPointBufferEnd, nPos) ;
#endif
		lispMarker_GetBufferPosition (pLispMgr, pEntMarker, &pEntMkBuffer, NULL) ;
		if (pEntMkBuffer != pEntBuffer) 
			lispBuffer_AddMarker (pLispMgr, pEntBuffer, pEntMarker) ;
	}
	lispMarker_SetBufferPosition (pLispMgr, pEntMarker, pEntBuffer, nPos) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntMarker) ;
	return	LMR_RETURN ;

 error_return:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*
 *	(marker-position MARKER)
 *
 *	MARKER λؤƤȤ֤
 */
TLMRESULT
lispMachineState_MarkerPosition (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMarker ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntRetval ;
	int				nPosition ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntMarker) ;
	if (TFAILED (lispEntity_Markerp (pLispMgr, pEntMarker))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMarker_GetBufferPosition (pLispMgr, pEntMarker, &pEntBuffer, &nPosition) ;
	if (pEntBuffer == NULL) {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	} else {
		int		nPointBufferTop ;
		lispBuffer_PointBufferTop (pLispMgr, pEntBuffer, &nPointBufferTop) ;
		nPosition	= nPosition - nPointBufferTop + 1 ;
		lispMgr_CreateInteger (pLispMgr, nPosition, &pEntRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

/*
 *	(marker-buffer MARKER)
 */
TLMRESULT
lispMachineState_MarkerBuffer (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMarker ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntMarker) ;
	if (TFAILED (lispEntity_Markerp (pLispMgr, pEntMarker))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMarker_GetBufferPosition (pLispMgr, pEntMarker, &pEntBuffer, NULL) ;
	if (pEntBuffer == NULL) {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	} else {
		pEntRetval	= pEntBuffer ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

/*
 *	(marker-insertion-type MARKER)
 */
TLMRESULT
lispMachineState_MarkerInsertionType (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMarker ;
	Boolean			fType ;
	TLispEntity*	pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntMarker) ;
	if (TFAILED (lispEntity_Markerp (pLispMgr, pEntMarker))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	lispMarker_GetInsertionType (pLispMgr, pEntMarker, &fType) ;
	if (TSUCCEEDED (fType)) {
		lispMgr_CreateT   (pLispMgr, &pEntRetval) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

/*
 *	(copy-marker MARKER &optional TYPE)
 *
 *	MARKER Ʊؤޡ֤ʤ
 *	current buffer ΤξؤƤ뿷ޡ롣
 */
TLMRESULT
lispMachineState_CopyMarker (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntMarker ;
	TLispEntity*	pEntType ;
	TLispEntity*	pEntBuffer ;
	TLispEntity*	pEntRetval ;
	int				nPos ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntMarker) ;
	lispEntity_GetCdr (pLispMgr, pEntArglist, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntType) ;

	if (TSUCCEEDED (lispEntity_Markerp (pLispMgr, pEntMarker))) {
		lispMarker_GetBufferPosition (pLispMgr, pEntMarker, &pEntBuffer, &nPos) ;
	} else if (TSUCCEEDED (lispEntity_Integerp (pLispMgr, pEntMarker))) {
		long	lPosition ;
		int		nPointBufferTop, nPointBufferEnd ;

		(void) lispEntity_GetIntegerValue (pLispMgr, pEntMarker, &lPosition) ;
		lispMachineCode_GetCurrentBuffer (pLM, &pEntBuffer) ;
		lispBuffer_PointBufferTop (pLispMgr, pEntBuffer, &nPointBufferTop) ;
		lispBuffer_PointBufferEnd (pLispMgr, pEntBuffer, &nPointBufferEnd) ;
		nPos	= lPosition + nPointBufferTop ;
		if (nPos < nPointBufferTop)
			nPos	= nPointBufferTop ;
		if (nPos > nPointBufferEnd)
			nPos	= nPointBufferEnd ;
	} else {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMachineCode_CreateMarker (pLM, pEntBuffer, nPos, &pEntRetval)))
		return	LMR_ERROR ;
	if (TFAILED (lispEntity_Nullp (pLispMgr, pEntType))) 
		lispMarker_SetInsertionType (pLispMgr, pEntRetval, True) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

