#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	TLMRESULT	lispMachineState_letStarStep1		(TLispMachine*) ;
static	TLMRESULT	lispMachineState_letStarStep2		(TLispMachine*) ;
static	TLMRESULT	lispMachineState_letStarEvalBody	(TLispMachine*) ;
static	TLMRESULT	lispMachineState_letStarFinalize	(TLispMachine*) ;

static	TLMRESULT	lispMachineState_letStep1		(TLispMachine*) ;
static	TLMRESULT	lispMachineState_letStep2		(TLispMachine*) ;
static	TLMRESULT	lispMachineState_letEvalBody	(TLispMachine*) ;
static	TLMRESULT	lispMachineState_letFinalize	(TLispMachine*) ;

TLMRESULT
lispMachineState_LetStar (
	register TLispMachine* pLM)
{
	TLispEntity*	pNil ;

#if defined (DEBUG_LV99)
	{
		TLispEntity*	hACC ;
		lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &hACC) ;
		fprintf (stderr, "state = 'let*' : ACC = ") ;
		lispEntity_Print (pLM->m_pLispMgr, hACC) ;
		fprintf (stderr, "\n") ;
	}
#endif
	
	lispMgr_CreateNil (pLM->m_pLispMgr, &pNil) ;

	lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_4) ;
	lispMachineCode_Car      (pLM, LM_LREG_1, LM_LREG_ACC) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_2, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_3, pNil) ;
	lispMachineCode_Cdr      (pLM, LM_LREG_4, LM_LREG_ACC) ;
	lispMachineCode_SetState (pLM, &lispMachineState_letStarStep1) ;
	return	LMR_CONTINUE ;
}

/*	private */
TLMRESULT
lispMachineState_letStarStep1 (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pValueform ;
	TLispEntity*	pVarlist ;
	TLispEntity*	pCAR ;
	TLispEntity*	pCDR ;
	TLispEntity*	pCons ;
	TLispEntity*	pOrgValue ;
	TLispEntity*	pTail ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pValue ;
	TLispEntity*	pNil ;
	int			iType ;
	
	pLispMgr	= pLM->m_pLispMgr ;

	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pValueform) ;
	/*lispMachineCode_GetLReg (pLM, LM_LREG_2, &pVarlistTop) ;*/
	lispMachineCode_GetLReg (pLM, LM_LREG_3, &pVarlist) ;

	/*	nil äƤ*/
	lispMgr_CreateNil (pLispMgr, &pNil) ;

	while (TFAILED (lispEntity_Nullp (pLispMgr, pValueform))) {
		if (TFAILED (lispEntity_GetCar  (pLispMgr, pValueform, &pCAR))) {
			lispMachineCode_SetError (pLM) ;
			lispMachineCode_SetState (pLM, &lispMachineState_letStarFinalize) ;
			return	LMR_CONTINUE ;
		}
		(void) lispEntity_GetType (pLispMgr, pCAR, &iType) ;
		switch (iType) {
		case	LISPENTITY_CONSCELL:
			if (TFAILED (lispEntity_GetCar  (pLispMgr, pCAR, &pSymbol)) ||
				TFAILED (lispEntity_GetCadr (pLispMgr, pCAR, &pValue))  ||
				TFAILED (lispEntity_GetCddr (pLispMgr, pCAR, &pCDR))    ||
				TFAILED (lispEntity_Nullp   (pLispMgr, pCDR)))
				goto	error_occur ;
			goto	common ;
			
		case	LISPENTITY_SYMBOL:
			pSymbol	= pCAR ;
			pValue	= pNil ;
		common:
			/*	Ȥ SYMBOL ˳դƤͤФ*/
			if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pSymbol, &pOrgValue)) ||
				pOrgValue == NULL) {
				/*	ξˤ VOID äξ*/
				lispMgr_CreateVoid (pLispMgr, &pOrgValue) ;
			}
			if (TFAILED (lispEntity_Nullp (pLispMgr, pVarlist))) {
				lispMgr_CreateConscell (pLispMgr, pNil, pNil, &pTail) ;
				lispEntity_SetCdr      (pLispMgr, pVarlist, pTail) ;
			} else {
				lispMgr_CreateConscell (pLispMgr, pNil, pNil, &pTail) ;
				lispMachineCode_SetLReg (pLM, LM_LREG_2, pTail) ;
			}
			lispMgr_CreateConscell (pLispMgr, pSymbol, pOrgValue, &pCons) ;
			lispEntity_SetCar      (pLispMgr, pTail,   pCons) ;
			pVarlist	= pTail ;

			if (iType == LISPENTITY_SYMBOL) {
				/* ``let*'' ʤΤǽ֤ͤꤷƹԤ*/
				lispMachine_SetCurrentSymbolValue (pLM, pSymbol, pNil) ;
#if defined (DEBUG_LV99)
				fprintf (stderr, "let*-bind: ") ;
				lispEntity_Print (pLispMgr, pSymbol) ;
				fprintf (stderr, " <- nil\n") ;
#endif
			} else {
				lispMachineCode_SetLReg (pLM, LM_LREG_1, pValueform) ;
				lispMachineCode_SetLReg (pLM, LM_LREG_3, pVarlist) ;

				/*	VALUEFORM  VALUE ¦ EVAL ɬפ롣*/
				lispMachineCode_Evaln   (pLM, pValue, &lispMachineState_letStarStep2) ;
				return	LMR_CONTINUE ;
			}
			break ;

		default:
		error_occur:
			lispMachineCode_SetError (pLM) ;
			lispMachineCode_SetState (pLM, &lispMachineState_letStarFinalize) ;
			return	LMR_CONTINUE ;
		}
		lispEntity_GetCdr (pLispMgr, pValueform, &pCDR) ;
		pValueform	= pCDR ;
	}
	lispMachineCode_MoveLReg (pLM, LM_LREG_ACC, LM_LREG_4) ;
	lispMachineCode_SetState (pLM, &lispMachineState_letStarEvalBody) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_letStarStep2 (register TLispMachine* pLM)
{
	TLispEntity*	pValue ;
	TLispEntity*	pCar ;
	TLispEntity*	pSymbol ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) {
		lispMachineCode_SetState (pLM, &lispMachineState_letStarFinalize) ;
	} else {
		lispMachineCode_GetLReg    (pLM, LM_LREG_ACC, &pValue) ;
		lispMachineCode_GetLReg    (pLM, LM_LREG_3,   &pCar) ;
		lispEntity_GetCaar         (pLM->m_pLispMgr,  pCar, &pSymbol) ;
#if defined (DEBUG_LV99)
		fprintf (stderr, "let*-bind: ") ;
		lispEntity_Print (pLM->m_pLispMgr, pSymbol) ;
		fprintf (stderr, " <- ") ;
		lispEntity_Print (pLM->m_pLispMgr, pValue) ;
		fprintf (stderr, "\n") ;
#endif
		lispMachine_SetCurrentSymbolValue (pLM, pSymbol, pValue) ;
		lispMachineCode_Cdr        (pLM, LM_LREG_1,   LM_LREG_1) ;
		lispMachineCode_SetState (pLM, &lispMachineState_letStarStep1) ;
	}
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_letStarEvalBody (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pCAR ;

	pLispMgr	= pLM->m_pLispMgr ;

	/*	顼ȯкƬ롣*/
	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) {
		lispMachineCode_SetState (pLM, &lispMachineState_letStarFinalize) ;
		return	LMR_CONTINUE ;
	}
	lispMachineCode_GetLReg (pLM, LM_LREG_4, &pArglist) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pArglist))) {
		lispMachineCode_SetState (pLM, &lispMachineState_letStarFinalize) ;
		return	LMR_CONTINUE ;
	}
	(void) lispEntity_GetCar  (pLispMgr, pArglist, &pCAR) ;
	assert (pCAR != NULL) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pCAR) ;
	lispMachineCode_Cdr     (pLM, LM_LREG_4,   LM_LREG_4) ;
	lispMachineCode_Evaln   (pLM, pCAR, &lispMachineState_letStarEvalBody) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_letStarFinalize (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pVarlist ;
	TLispEntity*	pVarpair ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pValue ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	/*	bind 򸵤᤹*/
	lispMachineCode_GetLReg (pLM, LM_LREG_2, &pVarlist) ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pVarlist))) {
		(void) lispEntity_GetCar (pLispMgr, pVarlist, &pVarpair) ;
		(void) lispEntity_GetCar (pLispMgr, pVarpair, &pSymbol) ;
		(void) lispEntity_GetCdr (pLispMgr, pVarpair, &pValue) ;
#if defined (DEBUG_LV99)
		fprintf (stderr, "let*-finalize: ") ;
		lispEntity_Print (pLispMgr, pSymbol) ;
		fprintf (stderr, " <- ") ;
		lispEntity_Print (pLispMgr, pValue) ;
		fprintf (stderr, "\n") ;
#endif
		lispMachine_SetCurrentSymbolValue (pLM, pSymbol, pValue) ;
		(void) lispEntity_GetCdr (pLispMgr, pVarlist, &pVarlist) ;
	}
	/*	register 롣*/
	lispMachineCode_PopLReg (pLM, LM_LREG_4) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_1) ;
	/*	ACC ϤΤޤ֤*/
	return	LMR_RETURN ;
}

TLMRESULT
lispMachineState_Let (register TLispMachine* pLM)
{
	TLispEntity*	pNil ;

	lispMgr_CreateNil (pLM->m_pLispMgr, &pNil) ;

	lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_4) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_5) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_6) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_7) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_8) ;
	
	lispMachineCode_Car      (pLM, LM_LREG_1, LM_LREG_ACC) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_2, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_3, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_4, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_5, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_6, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_7, pNil) ;
	lispMachineCode_Cdr      (pLM, LM_LREG_8, LM_LREG_ACC) ;
	
	lispMachineCode_SetState (pLM, &lispMachineState_letStep1) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_letStep1 (register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pValueform ;
	TLispEntity*	pVarlist ;
	TLispEntity*	pValuelist ;
	TLispEntity*	pOrgValuelist ;
	TLispEntity*	pCAR ;
	TLispEntity*	pCDR ;
	TLispEntity*	pOrgValue ;
	TLispEntity*	pTail ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pValue ;
	TLispEntity*	pNil ;
	int			iType ;
	
	pLispMgr	= pLM->m_pLispMgr ;

	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pValueform) ;
	/*lispMachineCode_GetLReg (pLM, LM_LREG_2, &pVarlistTop) ;*/
	lispMachineCode_GetLReg (pLM, LM_LREG_3, &pVarlist) ;
	/*lispMachineCode_GetLReg (pLM, LM_LREG_4, &pValuelistTop) ;*/
	lispMachineCode_GetLReg (pLM, LM_LREG_5, &pValuelist) ;
	/*lispMachineCode_GetLReg (pLM, LM_LREG_6, &pOrgValuelistTop) ;*/
	lispMachineCode_GetLReg (pLM, LM_LREG_7, &pOrgValuelist) ;

	/*	nil äƤ*/
	lispMgr_CreateNil (pLispMgr, &pNil) ;

	while (TFAILED (lispEntity_Nullp (pLispMgr, pValueform))) {
		if (TFAILED (lispEntity_GetCar  (pLispMgr, pValueform, &pCAR))) {
			lispMachineCode_SetError (pLM) ;
			lispMachineCode_SetState (pLM, &lispMachineState_letStarFinalize) ;
			return	LMR_CONTINUE ;
		}
		(void) lispEntity_GetType (pLispMgr, pCAR, &iType) ;
		switch (iType) {
		case	LISPENTITY_CONSCELL:
			if (TFAILED (lispEntity_GetCar  (pLispMgr, pCAR, &pSymbol)) ||
				TFAILED (lispEntity_GetCadr (pLispMgr, pCAR, &pValue))  ||
				TFAILED (lispEntity_GetCddr (pLispMgr, pCAR, &pCDR))    ||
				TFAILED (lispEntity_Nullp   (pLispMgr, pCDR)))
				goto	error_occur ;
			goto	common ;
			
		case	LISPENTITY_SYMBOL:
			pSymbol	= pCAR ;
			pValue	= pNil ;
		common:
			/*	Ȥ SYMBOL ˳դƤͤФ*/
			if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pSymbol, &pOrgValue)) ||
				pOrgValue == NULL) {
				/*	ξˤ VOID äξ*/
				lispMgr_CreateVoid (pLispMgr, &pOrgValue) ;
			}
			/*	bind  symbol  (list) 롣*/
			lispMgr_CreateConscell (pLispMgr, pSymbol, pNil, &pTail) ;
			if (TFAILED (lispEntity_Nullp (pLispMgr, pVarlist))) {
				lispEntity_SetCdr       (pLispMgr, pVarlist, pTail) ;
			} else {
				lispMachineCode_SetLReg (pLM, LM_LREG_2, pTail) ;
			}
			pVarlist		= pTail ;
			
			/*	bind  symbol  bind Ƥͤ롣*/
			lispMgr_CreateConscell (pLispMgr, pOrgValue, pNil, &pTail) ;
			if (TFAILED (lispEntity_Nullp (pLispMgr, pOrgValuelist))) {
				lispEntity_SetCdr       (pLispMgr, pOrgValuelist, pTail) ;
			} else {
				lispMachineCode_SetLReg (pLM, LM_LREG_6, pTail) ;
			}
			pOrgValuelist	= pTail ;

			/*	bind ͤ롣*/
			if (iType == LISPENTITY_SYMBOL) {
				/*	ξˤ nil  bind 롣*/
				lispMgr_CreateConscell (pLispMgr, pNil, pNil, &pTail) ;
				if (TFAILED (lispEntity_Nullp (pLispMgr, pValuelist))) {
					lispEntity_SetCdr (pLispMgr, pValuelist, pTail) ;
				} else {
					lispMachineCode_SetLReg (pLM, LM_LREG_4, pTail) ;
				}
				pValuelist	= pTail ;
			} else {
				lispMachineCode_SetLReg (pLM, LM_LREG_1, pValueform) ;
				lispMachineCode_SetLReg (pLM, LM_LREG_3, pVarlist) ;
				lispMachineCode_SetLReg (pLM, LM_LREG_5, pValuelist) ;
				lispMachineCode_SetLReg (pLM, LM_LREG_7, pOrgValuelist) ;
				
				/*	VALUEFORM  VALUE ¦ EVAL ɬפ롣*/
				lispMachineCode_Evaln   (pLM, pValue, &lispMachineState_letStep2) ;
				return	LMR_CONTINUE ;
			}
			break ;
			
		default:
		error_occur:
			lispMachineCode_SetError (pLM) ;
			lispMachineCode_SetState (pLM, &lispMachineState_letFinalize) ;
			return	LMR_CONTINUE ;
		}
		lispEntity_GetCdr (pLispMgr, pValueform, &pCDR) ;
		pValueform	= pCDR ;
	}

	/*	bind 롣*/
	lispMachineCode_GetLReg (pLM, LM_LREG_2, &pVarlist) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_4, &pValuelist) ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pVarlist))) {
		(void) lispEntity_GetCar (pLispMgr, pVarlist,   &pSymbol) ;
		(void) lispEntity_GetCar (pLispMgr, pValuelist, &pValue) ;
		lispMachine_SetCurrentSymbolValue (pLM, pSymbol, pValue) ;
		(void) lispEntity_GetCdr (pLispMgr, pVarlist,   &pVarlist) ;
		(void) lispEntity_GetCdr (pLispMgr, pValuelist, &pValuelist) ;
	}
	
	lispMachineCode_MoveLReg (pLM, LM_LREG_ACC, LM_LREG_8) ;
	lispMachineCode_SetState (pLM, &lispMachineState_letEvalBody) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_letStep2 (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pValue ;
	TLispEntity*	pTail ;
	TLispEntity*	pNil ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) {
		lispMachineCode_SetState (pLM, &lispMachineState_letFinalize) ;
	} else {
		pLispMgr	= pLM->m_pLispMgr ;
		lispMgr_CreateNil (pLispMgr, &pNil) ;
		
		lispMachineCode_GetLReg    (pLM, LM_LREG_ACC, &pValue) ;
#if defined (DEBUG_LV99)
		fprintf (stderr, "state = 'let-step2' : ACC = ") ;
		lispEntity_Print (pLispMgr, pValue) ;
		fprintf (stderr, "\n") ;
#endif
		lispMgr_CreateConscell (pLispMgr, pValue, pNil, &pTail) ;
		lispMachineCode_SetTail (pLM, LM_LREG_4, LM_LREG_5, pTail) ;
		lispMachineCode_Cdr     (pLM, LM_LREG_1, LM_LREG_1) ;
		lispMachineCode_SetState (pLM, &lispMachineState_letStep1) ;
	}
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_letEvalBody (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pCAR ;

	pLispMgr	= pLM->m_pLispMgr ;

	/*	顼ȯкƬ롣*/
	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) {
		lispMachineCode_SetState (pLM, &lispMachineState_letFinalize) ;
		return	LMR_CONTINUE ;
	}
	lispMachineCode_GetLReg (pLM, LM_LREG_8, &pArglist) ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pArglist))) {
		lispMachineCode_SetState (pLM, &lispMachineState_letFinalize) ;
		return	LMR_CONTINUE ;
	}
	(void) lispEntity_GetCar  (pLispMgr, pArglist, &pCAR) ;
	assert (pCAR != NULL) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pCAR) ;
	lispMachineCode_Cdr     (pLM, LM_LREG_8,   LM_LREG_8) ;
	lispMachineCode_Evaln   (pLM, pCAR, &lispMachineState_letEvalBody) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_letFinalize (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pVarlist ;
	TLispEntity*	pOrgValuelist ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pValue ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	/*	bind 򸵤᤹*/
	lispMachineCode_GetLReg (pLM, LM_LREG_2, &pVarlist) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_6, &pOrgValuelist) ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pVarlist))) {
		(void) lispEntity_GetCar (pLispMgr, pVarlist,      &pSymbol) ;
		(void) lispEntity_GetCar (pLispMgr, pOrgValuelist, &pValue) ;
		lispMachine_SetCurrentSymbolValue (pLM, pSymbol, pValue) ;
		(void) lispEntity_GetCdr (pLispMgr, pVarlist,      &pVarlist) ;
		(void) lispEntity_GetCdr (pLispMgr, pOrgValuelist, &pOrgValuelist) ;
	}
	/*	register 롣*/
	lispMachineCode_PopLReg (pLM, LM_LREG_8) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_7) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_6) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_5) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_4) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_1) ;
	/*	ACC ϤΤޤ֤*/
	return	LMR_RETURN ;
}

