#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	TLMRESULT	lispMachineState_evalLambdaPreBindArg	(TLispMachine* pLM) ;
static	TLMRESULT	lispMachineState_evalLambdaBindArg		(TLispMachine* pLM) ;
static	TLMRESULT	lispMachineState_evalLambdaBody			(TLispMachine* pLM) ;
static	TLMRESULT	lispMachineState_evalLambdaFinalize		(TLispMachine* pLM) ;

/*
 *	ϡ
 *	LM_LREG_ACC	... (lambda &rest CDR)
 */
TLMRESULT
lispMachineState_Lambda (TLispMachine* pLM)
{
	/*	Ϥ self-quoting ƤΤȤư*/
	assert (pLM != NULL) ;
	return	LMR_RETURN ;
}

/*
 *	ϡ
 *	LM_LREG_ACC	... ((lambda ARGS BODY) ARG1 ... ARGn)
 *
 *	쥸λȤϼ̤ꡣ
 *	LM_LREG_1	... lambda Ϥ󡣥ꥹȡ
 *	LM_LREG_2	... lambda Ρꥹȡ(lambda ARG BODY...) η
 *	LM_LREG_3	... ɾ̤ΥꥹȤƬ
 *	LM_LREG_4	... ɾ̤ΥꥹȤκǸǡ
 *	LM_LREG_5	... ΤȤȤ bind ƤͤΥꥹȤƬ
 *	LM_LREG_6	... ΤȤȤ bind ƤͤΥꥹȤκǸǡ
 *	LM_LREG_7	... ȤͿƤ SYMBOL Ƭ
 */
TLMRESULT
lispMachineState_EvalLambdaForm (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntCar ;
	TLispEntity*	pEntCdr ;
	TLispEntity*	pEntCdar ;
	TLispEntity*	pEntCadar ;
	TLispEntity*	pNil ;

#if defined (DEBUG_LV99)
	fprintf (stderr, "state = eval-lambda\n") ;
#endif
	lispMachineCode_PushLReg (pLM, LM_LREG_1) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_5) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_6) ;
	lispMachineCode_PushLReg (pLM, LM_LREG_7) ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntCar) ;
	lispEntity_GetCdr  (pLispMgr, pEntCar,     &pEntCdar) ;
	lispEntity_GetCar  (pLispMgr, pEntCdar,    &pEntCadar) ;
#if defined (DEBUG)
	fprintf (stderr, "lambda: argument-list = ") ;
	lispEntity_Print (pLispMgr, pEntCar) ;
	fprintf (stderr, "\n") ;
	fprintf (stderr, "lambda: body-list = ") ;
	lispEntity_Print (pLispMgr, pEntCdar) ;
	fprintf (stderr, "\n") ;
	fprintf (stderr, "lambda: symbol-list = ") ;
	lispEntity_Print (pLispMgr, pEntCadar) ;
	fprintf (stderr, "\n") ;
#endif
	lispMachineCode_SetLReg (pLM, LM_LREG_1, pEntCadar) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_2, pEntCdar) ;
	lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntCdr) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_3, pEntCdr) ;

	lispMgr_CreateNil (pLispMgr, &pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_5, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_6, pNil) ;
	lispMachineCode_SetLReg  (pLM, LM_LREG_7, pNil) ;
	pLM->m_pState	= &lispMachineState_evalLambdaPreBindArg ;
	return	LMR_CONTINUE ;
}

/*
 *	 SYMBOL ͿƤ VALUE ȴФơΥꥹ
 *	ꡢLM_LREG_5 롣
 *
 *	LM_LREG_1 ˤä LM_LREG_7 ¸Ƥ롣
 *
 *	LM_LREG_3 ˤ SYMBOL ˰Ū BIND  VALUE Ѱդ
 *	롣
 *
 *	顢funcall  apply ӹΤϡǤ롣
 */
TLMRESULT
lispMachineState_evalLambdaPreBindArg (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pSymbollist ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pOrgValue ;
	TLispEntity*	pNil ;
	TLispEntity*	pTail ;
	TLispEntity*	pOrgValuelist ;

#if defined (DEBUG_LV99)
	fprintf (stderr, "state = eval-lambda-pre-bind-arg\n") ;
#endif
	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMgr_CreateNil (pLispMgr, &pNil) ;
	
	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pSymbollist) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_6, &pOrgValuelist) ;
	assert (pSymbollist != NULL) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_7, pSymbollist) ;
#if defined (DEBUG)
	fprintf (stderr, "p-lambda: symbol-list = ") ;
	lispEntity_Print (pLispMgr, pSymbollist) ;
	fprintf (stderr, "\n") ;
#endif
	
	while (TFAILED (lispEntity_Nullp (pLispMgr, pSymbollist))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pSymbollist, &pSymbol)) ||
			TFAILED (lispEntity_Symbolp (pLispMgr, pSymbol))) 
			break ;
		if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pSymbol, &pOrgValue)) ||
			pOrgValue == NULL)
			lispMgr_CreateVoid (pLispMgr, &pOrgValue) ;

#if defined (DEBUG_LV99)
		fprintf (stderr, "pre-bind: ") ;
		lispEntity_Print (pLispMgr, pSymbol) ;
		fprintf (stderr, " <- ") ;
		lispEntity_Print (pLispMgr, pOrgValue) ;
		fprintf (stderr, "\n") ;
#endif

		lispMgr_CreateConscell (pLispMgr, pOrgValue, pNil, &pTail) ;
		if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pOrgValuelist))) {
			lispMachineCode_SetLReg (pLM, LM_LREG_5, pTail) ;
			pOrgValuelist	= pTail ;
		} else {
			lispEntity_SetCdr (pLispMgr, pOrgValuelist, pTail) ;
		}
		pOrgValuelist	= pTail ;
		if (TFAILED (lispEntity_GetCdr (pLispMgr, pSymbollist, &pSymbollist)))
			break ;
	}
	if (pSymbollist == NULL ||
		TFAILED (lispEntity_Nullp (pLispMgr, pSymbollist))) {
		lispMachineCode_SetError (pLM) ;
		pLM->m_pState	= &lispMachineState_evalLambdaFinalize ;
	} else {
		pLM->m_pState	= &lispMachineState_evalLambdaBindArg ;
	}
	return	LMR_CONTINUE ;
}

/*
 *	ʳǤϡ
 *	LM_LREG_1	
 *	LM_LREG_3	
 *	LM_LREG_5
 */
TLMRESULT
lispMachineState_evalLambdaBindArg (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pSymbollist ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pNil ;
	TLispEntity*	pValueList ;
	TLispEntity*	pValue ;
	TLispEntity*	pNextSymbol ;
	TLispEntity*	pNextValue ;
	int			nArgument ;
	Boolean		fOptional, fRest ;

#if defined (DEBUG_LV99)
	fprintf (stderr, "state = eval-lambda-bind-arg\n") ;
#endif
	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMgr_CreateNil (pLispMgr, &pNil) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_1, &pSymbollist) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_3, &pValueList) ;
	fOptional	= FALSE ;
	fRest		= FALSE ;
	nArgument	= 0 ;
#if defined (DEBUG_LV99)
	fprintf (stderr, "LREG_1 = ") ;
	lispEntity_Print (pLispMgr, pSymbollist) ;
	fprintf (stderr, "\n") ;
	fprintf (stderr, "LREG_3 = ") ;
	lispEntity_Print (pLispMgr, pValueList) ;
	fprintf (stderr, "\n") ;
#endif
	
	while (TFAILED (lispEntity_Nullp (pLispMgr, pSymbollist))) {
		/*assert (!lispEntity_Nullp (pLispMgr, pValueList)) ;*/

		if (TFAILED (lispEntity_GetCar (pLispMgr, pSymbollist, &pSymbol)) ||
			TFAILED (lispEntity_Symbolp (pLispMgr, pSymbol)))
			goto	error_occur ;

		if (TSUCCEEDED (lispEntity_Optionalp (pLispMgr, pSymbol))) {
			if (TFAILED (lispEntity_GetCdr (pLispMgr, pSymbollist, &pNextSymbol)) ||
				lispEntity_Nullp (pLispMgr, pNextSymbol)) {
#if defined (DEBUG) || 1
				fprintf (stderr, "Wrong number of arguments: , %d\n", nArgument) ;
#endif
				goto	error_occur ;
			}
			pSymbollist	= pNextSymbol ;
			fOptional	= TRUE ;
			continue ;
		}
		if (TSUCCEEDED (lispEntity_Restp (pLispMgr, pSymbol))) {
			if (TFAILED (lispEntity_GetCdr (pLispMgr, pSymbollist, &pNextSymbol)) ||
				lispEntity_Nullp (pLispMgr, pNextSymbol)) {
#if defined (DEBUG) || 1
				fprintf (stderr, "Wrong number of arguments: , %d\n", nArgument) ;
#endif
				goto	error_occur ;
			}
			pSymbollist	= pNextSymbol ;
			fRest		= TRUE ;
			continue ;
		}

		if (fRest) {
			pValue		= pValueList ;
			(void) lispMgr_CreateNil (pLispMgr, &pValueList) ;
			fRest		= FALSE ;
			fOptional	= TRUE ;
		} else {
			if ((!fOptional && lispEntity_Nullp (pLispMgr, pValueList)) ||
				TFAILED (lispEntity_GetCar (pLispMgr, pValueList,  &pValue))) {
#if defined (DEBUG) || 1
				fprintf (stderr, "Wrong number of arguments: , %d\n", nArgument) ;
#endif
				goto	error_occur ;
			}
		}
		lispMachine_SetCurrentSymbolValue (pLM, pSymbol, pValue) ;

		if (TFAILED (lispEntity_GetCdr (pLispMgr, pSymbollist, &pNextSymbol)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pValueList,  &pNextValue))) {
			return	FALSE ;
		}
		pSymbollist	= pNextSymbol ;
		pValueList	= pNextValue ;
		nArgument	++ ;
	}

	if (TFAILED (lispEntity_Nullp (pLispMgr, pValueList))) {
#if defined (DEBUG) || 1
		fprintf (stderr, "Wrong number of arguments: , %d\n", nArgument) ;
#endif
		goto	error_occur ;
	}

	pLM->m_pState	= &lispMachineState_evalLambdaBody ;
	lispMachineCode_Cdr      (pLM, LM_LREG_2,   LM_LREG_2) ;
	lispMachineCode_MoveLReg (pLM, LM_LREG_ACC, LM_LREG_2) ;
	return	LMR_CONTINUE ;

 error_occur:
	lispMachineCode_SetError (pLM) ;
	pLM->m_pState	= &lispMachineState_evalLambdaFinalize ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_evalLambdaBody (TLispMachine* pLM)
{
	TLispEntity*	pBody ;
	TLispEntity*	pForm ;
	
#if defined (DEBUG_LV99)
	fprintf (stderr, "state = eval-lambda-body\n") ;
#endif
	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM)) {
		pLM->m_pState	= &lispMachineState_evalLambdaFinalize ;
		return	LMR_CONTINUE ;
	}
	lispMachineCode_GetLReg (pLM, LM_LREG_2, &pBody) ;
#if defined (DEBUG_LV99)
	fprintf (stderr, "body = ") ;
	lispEntity_Print (pLM->m_pLispMgr, pBody) ;
	fprintf (stderr, "\n") ;
#endif

	if (TSUCCEEDED (lispEntity_Nullp (pLM->m_pLispMgr, pBody))) {
		pLM->m_pState	= &lispMachineState_evalLambdaFinalize ;
		return	LMR_CONTINUE ;
	}
	if (TFAILED (lispEntity_GetCar (pLM->m_pLispMgr, pBody, &pForm))) {
		lispMachineCode_SetError (pLM) ;
		pLM->m_pState	= &lispMachineState_evalLambdaFinalize ;
		return	LMR_CONTINUE ;
	}
	
	lispMachineCode_Cdr   (pLM, LM_LREG_2, LM_LREG_2) ;
	lispMachineCode_Evaln (pLM, pForm, &lispMachineState_evalLambdaBody) ;
	return	LMR_CONTINUE ;
}

TLMRESULT
lispMachineState_evalLambdaFinalize (TLispMachine* pLM)
{
	TLispManager*	pLispMgr ;
	TLispEntity*	pSymbollist ;
	TLispEntity*	pValuelist ;
	TLispEntity*	pSymbol ;
	TLispEntity*	pValue ;
	
#if defined (DEBUG_LV99)
	fprintf (stderr, "state = eval-lambda-finialize\n") ;
#endif
	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_7, &pSymbollist) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_5, &pValuelist) ;

	while (TFAILED (lispEntity_Nullp (pLispMgr, pSymbollist))) {
		(void) lispEntity_GetCar (pLispMgr, pSymbollist, &pSymbol) ;
		(void) lispEntity_GetCar (pLispMgr, pValuelist,  &pValue) ;
#if defined (DEBUG_LV99)
		fprintf (stderr, "lambda-finalize: ") ;
		lispEntity_Print (pLispMgr, pSymbol) ;
		fprintf (stderr, " <- ") ;
		lispEntity_Print (pLispMgr, pValue) ;
		fprintf (stderr, "\n") ;
#endif
		lispMachine_SetCurrentSymbolValue (pLM, pSymbol, pValue) ;
		(void) lispEntity_GetCdr (pLispMgr, pSymbollist, &pSymbollist) ;
		(void) lispEntity_GetCdr (pLispMgr, pValuelist,  &pValuelist) ;
	}

	lispMachineCode_PopLReg (pLM, LM_LREG_7) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_6) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_5) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_3) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_2) ;
	lispMachineCode_PopLReg (pLM, LM_LREG_1) ;
	return	LMR_RETURN ;
}



