#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	TLMRESULT	lispMachineState_readCharFinalize	(TLispMachine*) ;
static	TLMRESULT	lispMachineState_readEventLoop 		(TLispMachine*) ;

TLMRESULT
lispMachineState_ReadChar (
	register TLispMachine*	pLM)
{
	/*
	 *	ʸʳꤨʤ褦ˤʤäƤΤǡ
	 *	¤ read-event == read-char Ǥ롣
	 */
	lispMachineCode_PushState (pLM, &lispMachineState_readCharFinalize) ;
	return	lispMachineState_ReadEvent (pLM) ;
}

TLMRESULT
lispMachineState_readCharFinalize (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntKey ;
	TLispEntity*	pEntRetval ;
	long			lValue ;
	register Char	cc ;

	assert (pLM != NULL) ;
	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM))
		return	LMR_RETURN ;

	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntKey) ;

	/*	Non-character input ǤХ顼ˤʤ롣*/
	if (TFAILED (lispEntity_GetIntegerValue (pLispMgr, pEntKey, &lValue))) 
		goto	error ;
	cc	= (Char) lValue ;
	if (Char_Charset (cc) < 0 || Char_Charset (cc) >= MAX_CHARSET) {
		if (Char_Charset (cc) != KCHARSET_XCHAR)
			goto	error ;
	}
	/*	x-event ǤϤʤ integer ˤ롣*/
	if (TFAILED (lispMgr_CreateInteger (pLispMgr, lValue, &pEntRetval)))
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
  error:
	lispMachineCode_SetError (pLM) ;
	return	LMR_RETURN ;
}

/*
 *	(read-event &optional PROMPT INHERIT-INPUT-METHOD)
 *
 *	Read an event object from the input stream.
 *	If the optional argument PROMPT is non-nil, display that as a prompt.
 *	If the optional argument INHERIT-INPUT-METHOD is non-nil and some
 *	input method is turned on in the current buffer, that input method
 *	is used for reading a character.
 */
TLMRESULT
lispMachineState_ReadEvent (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pArglist ;
	TLispEntity*	pPROMPT	;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
#if defined (DEBUG)
	fprintf (stderr, "(read-event) arglist = ") ;
	lispEntity_Print (pLispMgr, pArglist) ;
	fprintf (stderr, "\n") ;
#endif
	assert (pArglist != NULL) ;
	if (TSUCCEEDED (lispEntity_GetCar (pLispMgr, pArglist, &pPROMPT)) &&
		TFAILED    (lispEntity_Nullp (pLispMgr, pPROMPT))) {
		assert (pPROMPT != NULL) ;
		if (TFAILED (lispMachineCode_SetMessage (pLM, pPROMPT))) {
			lispMachineCode_SetError (pLM) ;
			return	LMR_RETURN ;
		}
	}
	lispMachineCode_SetState (pLM, &lispMachineState_readEventLoop) ;
	return	lispMachineState_readEventLoop (pLM) ;
}

/*	private functions */
/*
 *
 */
TLMRESULT
lispMachineState_readEventLoop (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*	pEntUnreadCmdChar ;
	TLispEntity*	pEntUnreadCmdEvents ;
	TLispEntity*	pEntKey ;
	TLispEntity*	pEntLastKey ;
	long			lValue ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;

	if (LISPMACHINE_EXCEPTIONORSIGNALP (pLM))
		return	LMR_RETURN ;

	/*	unread-command-char ꤵƤաĤ
	 *	ɤ߹ɬפ롣*/
	pEntUnreadCmdChar	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_UNREAD_COMMAND_CHAR) ;
	if (TSUCCEEDED (lispMachine_GetCurrentSymbolValue (pLM, pEntUnreadCmdChar, &pEntLastKey)) &&
		TSUCCEEDED (lispEntity_GetIntegerValue (pLispMgr, pEntLastKey, &lValue)) &&
		lValue > 0) {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntLastKey) ;
		if (TFAILED (lispMgr_CreateInteger (pLispMgr, -1, &pEntLastKey)))
			return	LMR_ERROR ;
#if defined (DEBUG)
		fprintf (stderr, "(read-char) read from unread-command-char (%ld)\n", lValue) ;
#endif
		lispMachine_SetCurrentSymbolValue (pLM, pEntUnreadCmdChar, pEntLastKey) ;
		return	LMR_RETURN ;
	}
	/*	unread-command-char ꤵƤʤСunread-command-events
	 *	̤ѥޤäƤ뤫ɤå롣*/
	pEntUnreadCmdEvents	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_UNREAD_COMMAND_EVENTS) ;
	lispMachine_GetCurrentSymbolValue (pLM, pEntUnreadCmdEvents, &pEntKey) ;

	/*	Ǥܤʤ顢key ϤԤġ*/
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntKey))) 
		return	LMR_SUSPEND ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntKey, &pEntLastKey)))
		return	LMR_SUSPEND ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntLastKey) ;
	lispEntity_GetCdr (pLispMgr, pEntKey, &pEntKey) ;
	lispMachine_SetCurrentSymbolValue (pLM, pEntUnreadCmdEvents, pEntKey) ;
#if defined (DEBUG)
	fprintf (stderr, "(read-char) read from unread-command-events (") ;
	lispEntity_Print (pLispMgr, pEntLastKey) ;
	fprintf (stderr, ")\n") ;
	fprintf (stderr, "(read-char) unread-command-events = ") ;
	lispEntity_Print (pLispMgr, pEntKey) ;
	fprintf (stderr, "\n") ;
#endif
	return	LMR_RETURN ;
}
	
/*
 *	δؿϡCommand Loop ؤΥϤɤݤƤơ
 *	Call-interactively  Command Loop ȯԤä褿ִִֽ
 *	˥եå夹Ȥư򤹤롣
 */
TLMRESULT
lispMachineState_ThisCommandKeys (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	const Char*		pString ;
	int				nString ;
	TLispEntity*	pEntKeys ;

	assert (pLM      != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetThisCommandKeys (pLM, &pString, &nString) ;
	if (TFAILED (lispMgr_CreateString (pLispMgr, pString, nString, &pEntKeys))) 
		return	LMR_ERROR ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntKeys) ;
	return	LMR_RETURN ;
}

