#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

TLMRESULT
lispMachineState_Getenv (
	register TLispMachine* pLM)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*	pEntArglist ;
	TLispEntity*	pEntVAR ;
	TVarbuffer		vbuf ;
	register char*	pDest ;
	TLispEntity*	pEntRetval ;
	const char*		pResult ;
	const Char*		pString ;
	int				nString ;

	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	lispEntity_GetCar (pLispMgr, pEntArglist, &pEntVAR) ;
	if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntVAR, &pString, &nString))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	/*	ɤ٤*/
	if (TFAILED (TVarbuffer_Initialize (&vbuf, sizeof (char))) ||
		TFAILED (TVarbuffer_Require (&vbuf, nString + 1)))
		return	LMR_ERROR ;
	pDest	= TVarbuffer_GetBuffer (&vbuf) ;
	cstrtostr (pDest, pString, nString) ;
	*(pDest + nString)	= '\0' ;
	pResult	= getenv (pDest) ;
	TVarbuffer_Uninitialize (&vbuf) ;

	if (pResult != NULL) {
		TVarbuffer	vbufChar ;
		register Char*		pChResult ;
		register int		nResult ;

		if (TFAILED (TVarbuffer_Initialize (&vbufChar, sizeof (Char))))
			return	LMR_ERROR ;
		nResult		= strlen (pResult) ;
		if (TFAILED (TVarbuffer_Require (&vbufChar, nResult)))
			return	LMR_ERROR ;
		pChResult	= TVarbuffer_GetBuffer (&vbufChar) ;
		strtocstr (pChResult, pResult, nResult) ;
		if (TFAILED (lispMgr_CreateString (pLispMgr, pChResult, nResult, &pEntRetval)))
			return	LMR_ERROR ;
		TVarbuffer_Uninitialize (&vbufChar) ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pEntRetval) ;
	}
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}


