#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

static	Boolean	lispMachine_putAlist (TLispManager*, TLispEntity*, TLispEntity*, TLispEntity*, TLispEntity**) ;
static	Boolean	lispMachine_modifyAlist	(TLispManager*, TLispEntity*, TLispEntity*, TLispEntity**) ;

/*
 *	(put-alist ITEM VALUE ALIST)
 *
 *	ITEM  VALUE 򥻥åȤ褦 ALIST 롣
 *	⤷ car  ITEM Ǥ pair ¸ߤ顢 cdr  VALUE 
 *	֤롣
 *	⤷ʥڥʤС(ITEM . VALUE) Ȥڥ
 *	car ڥ cdr  ALIST Ǥ뿷ꥹȤä֤
 */
TLMRESULT
lispMachineState_PutAlist (
	register TLispMachine*	pLM)
{
	register TLispManager*		pLispMgr ;
	TLispEntity*		pArglist ;
	TLispEntity*		pItem ;
	TLispEntity*		pValue ;
	TLispEntity*		pAlist ;
	TLispEntity*		pRetval ;
	TLispEntity*		pCdr ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pArglist, &pItem))  ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pArglist, &pCdr))   ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pCdr,     &pValue)) ||
		TFAILED (lispEntity_GetCadr (pLispMgr, pCdr,     &pAlist)) ||
		TFAILED (lispEntity_Listp   (pLispMgr, pAlist))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_RETURN ;
	}
	if (TFAILED (lispMachine_putAlist (pLispMgr, pItem, pValue, pAlist, &pRetval))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pRetval) ;
	}
	return	LMR_RETURN ;
}

/*
 *
 */
TLMRESULT
lispMachineState_ModifyAlist (
	register TLispMachine*	pLM)
{
	register TLispManager*		pLispMgr ;
	TLispEntity*		pEntArglist ;
	TLispEntity*		pEntModifier ;
	TLispEntity*		pEntDefault ;
	TLispEntity*		pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntModifier)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntDefault)) ||
		TFAILED (lispMachine_modifyAlist (pLispMgr, pEntModifier, pEntDefault, &pEntRetval))) {
		lispMachineCode_SetError (pLM) ;
	} else {
		lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	}
	return	LMR_RETURN ;
}

/*
 *	(set-modified-alist SYMBOL MODIFIER)
 *
 *	alist MODIFIER Ǥ SYMBOL  bound 줿 alist 
 *	store 롣⤷ SYMBOL  bound ƤʤСǽ nil 
 *	set 롣
 */
TLMRESULT
lispMachineState_SetModifiedAlist (
	register TLispMachine*	pLM)
{
	register TLispManager*		pLispMgr ;
	TLispEntity*		pEntArglist ;
	TLispEntity*		pEntSymbol ;
	TLispEntity*		pEntModifier ;
	TLispEntity*		pEntValue ;
	TLispEntity*		pEntRetval ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	lispMachineCode_GetLReg (pLM, LM_LREG_ACC, &pEntArglist) ;
	if (TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntSymbol)) ||
		TFAILED (lispEntity_Symbolp (pLispMgr, pEntSymbol)) ||
		TFAILED (lispEntity_GetCdr  (pLispMgr, pEntArglist, &pEntArglist)) ||
		TFAILED (lispEntity_GetCar  (pLispMgr, pEntArglist, &pEntModifier))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_ERROR ;
	}
	if (TFAILED (lispMachine_GetCurrentSymbolValue (pLM, pEntSymbol, &pEntValue)) ||
		TSUCCEEDED (lispEntity_Voidp (pLispMgr, pEntValue))) {
		lispMgr_CreateNil (pLispMgr, &pEntValue) ;
		lispMachine_SetCurrentSymbolValue (pLM, pEntSymbol, pEntValue) ;
	}
	if (TFAILED (lispMachine_modifyAlist (pLispMgr, pEntModifier, pEntValue, &pEntRetval))) {
		lispMachineCode_SetError (pLM) ;
		return	LMR_ERROR ;
	}
	lispMachine_SetCurrentSymbolValue (pLM, pEntSymbol, pEntRetval) ;
	lispMachineCode_SetLReg (pLM, LM_LREG_ACC, pEntRetval) ;
	return	LMR_RETURN ;
}

Boolean
lispMachine_putAlist (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntItem,
	register TLispEntity*	pEntValue,
	register TLispEntity*	pEntAlist,
	register TLispEntity**	ppEntRetval)
{
	TLispEntity*	pEntAlistBack ;
	TLispEntity*	pEntNextAlist ;
	TLispEntity*	pEntNewPair ;
	TLispEntity*	pEntNewAlist ;
	TLispEntity*	pEntPair ;
	Boolean			fResult ;

	pEntAlistBack	= pEntAlist ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntAlist))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntAlist, &pEntPair))) {
			return	False ;
		}
		if (TSUCCEEDED (lispEntity_Consp (pLispMgr, pEntPair))) {
			TLispEntity*	pEntCar ;
			(void) lispEntity_GetCar (pLispMgr, pEntPair, &pEntCar) ;
			if (TSUCCEEDED (lispEntity_Equal (pLispMgr, pEntCar, pEntItem))) {
				lispEntity_SetCdr (pLispMgr, pEntPair, pEntValue) ;
				*ppEntRetval	= pEntAlistBack ;
				return	True ;
			}
		}
		if (TFAILED (lispEntity_GetCdr (pLispMgr, pEntAlist, &pEntNextAlist))) 
			return	False ;
		pEntAlist	= pEntNextAlist ;
	}
	if (TFAILED (lispMgr_CreateConscell (pLispMgr, pEntItem, pEntValue, &pEntNewPair)) ||
		pEntNewPair == NULL)
		return	False ;
	lispEntity_AddRef (pLispMgr, pEntNewPair) ;
	fResult	= lispMgr_CreateConscell (pLispMgr, pEntNewPair, pEntAlistBack, &pEntNewAlist) ;
	lispEntity_Release (pLispMgr, pEntNewPair) ;
	*ppEntRetval	= pEntNewAlist ;
	return	fResult ;
}

Boolean
lispMachine_modifyAlist (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntModifier,
	register TLispEntity*	pEntDefault,
	register TLispEntity**	ppEntRetval)
{
	TLispEntity*	pEntItem ;
	TLispEntity*	pEntValue ;
	TLispEntity*	pEntCar ;
	TLispEntity*	pEntCdr ;
	TLispEntity*	pEntAlist ;
	TLispEntity*	pEntNewAlist ;

	pEntAlist	= pEntDefault ;
	lispEntity_AddRef (pLispMgr, pEntAlist) ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntModifier))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntModifier, &pEntCar)))
			return	False ;
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntCar, &pEntItem)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntCar, &pEntValue))) 
			return	False ;
		lispMachine_putAlist (pLispMgr, pEntItem, pEntValue, pEntAlist, &pEntNewAlist) ;
		lispEntity_AddRef  (pLispMgr, pEntNewAlist) ;
		lispEntity_Release (pLispMgr, pEntAlist) ;
		pEntAlist	= pEntNewAlist ;
		if (TFAILED (lispEntity_GetCdr (pLispMgr, pEntModifier, &pEntCdr)))
			return	False ;
		pEntModifier	= pEntCdr ;
	}
	*ppEntRetval	= pEntAlist ;
	return	True ;
}

