/* # SKKIME'98 (Simple Kana-Kanji Input Method Editor for Windows'98)
 * skkserver.c
 * This file is part of skkime'98.
 * Copyright (C) 1999
 * Takashi SAKAMOTO (tatari_sakamoto@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netdb.h>
#include "jisyop.h"
#include "cstring.h"

/*
 *	Definitions
 */
#define	SKKSERV_BYE			(0)
#define	SKKSERV_SEARCH		(1)
#define	SKKSERV_VERSION		(2)
#define	SKKSERV_HOSTNAME	(3)

#define	SKKSERV_BUFSIZE		(512)
#define	MAX_SKKSERVERS		(4)

#define	EOL					(0x0A)

/*
 *	Prototypes
 */
static	Boolean	skkServerJisyo_createSocket (PSKKSERVERJISYO) ;
static	Boolean	skkServerJisyo_recreateSocket (PSKKSERVERJISYO) ;
static	Boolean	skkServerJisyo_sendCommand (PSKKSERVERJISYO, int, const Char*, int) ;
static	Boolean	skkServerJisyo_closeConnection (PSKKSERVERJISYO) ;
static	Boolean	skkServerJisyo_getResult (PSKKSERVERJISYO, TVarbuffer*) ;
static	void	skkServerJisyo_clearResult (PSKKSERVERJISYO) ;
static	Boolean	skkServerJisyo_openConnection (PSKKSERVERJISYO) ;

/*
 *	Global Variable
 */
static	PSKKSERVERJISYO	pSkkserverJisyo	= NULL ;

/*
 *	Global functions
 */
PSKKSERVERJISYO
SkkServerJisyo_Find (
	register const Char*	pHostName,
	register int			nHostName)
{
	char			szHostname [MAX_HOSTNAME] ;
	register PSKKSERVERJISYO	pJisyo ;
	register int				nResult ;

	cstrtostr (szHostname, pHostName, (nHostName < MAX_HOSTNAME)? nHostName : MAX_HOSTNAME) ;
	szHostname [MAX_HOSTNAME - 1]	= '\0' ;

	pJisyo		= pSkkserverJisyo ;
	while (pJisyo != NULL) {
		nResult	= strcmp (pJisyo->m_szHostname, szHostname) ;
		if (!nResult)
			return	pJisyo ;
		pJisyo		= pJisyo->m_pNext ;
	}
	return	NULL ;
}

/*
 *	skkserv ̿뤿 socket ؿ
 *()
 *	äˤʤ
 *()
 *	skk-server-host		lisp ѿ skk-server-host ФΥۥ̾
 *	skk-portnum			lisp ѿ skk-portnum ݡֹ档
 */
PSKKSERVERJISYO
SkkServerJisyo_Register (
	register const Char*	pHostName,
	register int			nHostName,
	register int			nPortNum)
{
	char			szHostname [MAX_HOSTNAME] ;
	register PSKKSERVERJISYO	pJisyo ;
	register PSKKSERVERJISYO	pNewJisyo ;
	register int				nResult ;

	cstrtostr (szHostname, pHostName, (nHostName < MAX_HOSTNAME)? nHostName : MAX_HOSTNAME) ;
	if (nHostName < MAX_HOSTNAME) {
		szHostname [nHostName]			= '\0' ;
	} else {
		szHostname [MAX_HOSTNAME - 1]	= '\0' ;
	}

	pJisyo		= pSkkserverJisyo ;
	while (pJisyo != NULL) {
		nResult	= strcmp (pJisyo->m_szHostname, szHostname) ;
		if (!nResult)
			return	pJisyo ;
		pJisyo		= pJisyo->m_pNext ;
	}
	pNewJisyo	= MALLOC (sizeof (SKKSERVERJISYO)) ;
	if (pNewJisyo == NULL)
		return	NULL ;

	pNewJisyo->m_pNext		= pSkkserverJisyo ;
	pSkkserverJisyo			= pNewJisyo ;

	pNewJisyo->m_fInit		= True ;
	/* 񥵡Ф³뤿ѿ*/
	strcpy (pNewJisyo->m_szHostname, szHostname) ;
	pNewJisyo->m_nPortNum	= nPortNum ;
	pNewJisyo->m_pHostent	= NULL ;
	pNewJisyo->m_hSocket	= INVALID_SOCKET ;
	pNewJisyo->m_fConnect	= False ;
	pNewJisyo->m_fUsed		= False ;
	skkServerJisyo_createSocket (pNewJisyo) ;
	return	pNewJisyo ;
}

Boolean
SkkServerJisyo_Search (
	register PSKKSERVERJISYO	pJisyo,
	register const Char*		pKey,
	register int				nKey,
	register TVarbuffer*		pvbuf)
{
	char	ch ;

	if (TFAILED (pJisyo->m_fConnect)) {
		if (TFAILED (skkServerJisyo_openConnection (pJisyo)))
			return	False ;
	}
	/* С˸Ԥ褦ؼ롣*/
	if (TFAILED (skkServerJisyo_sendCommand (pJisyo, SKKSERV_SEARCH, pKey, nKey))) {
		skkServerJisyo_closeConnection (pJisyo) ;
		return	True ;
	}
	if (read (pJisyo->m_hSocket, &ch, sizeof (char)) <= 0) {
		perror ("read") ;
		skkServerJisyo_closeConnection (pJisyo) ;
		return	True ;
	}
	switch (ch){
	case '0' :
		break ;

	case '1' :
		return	skkServerJisyo_getResult (pJisyo, pvbuf) ;

	case '4' :
		skkServerJisyo_clearResult (pJisyo) ;
		break ;

	case '9' :
		break ;

	default :
		skkServerJisyo_clearResult (pJisyo) ;
		break ;
	}
	return	True ;
}

/*
 *	Local functions
 */
Boolean
skkServerJisyo_closeConnection (
	register PSKKSERVERJISYO	pJisyo)
{
	pJisyo->m_fConnect	= False ;
	close (pJisyo->m_hSocket) ;
	pJisyo->m_hSocket	= INVALID_SOCKET ;
	return	True ;
}

Boolean
skkServerJisyo_createSocket (
	register PSKKSERVERJISYO	pJisyo)
{
	struct protoent*	pProto ;

	if (pJisyo == NULL || TFAILED (pJisyo->m_fInit))
		return	False ;

	/* Protocol ꡣ*/
	pProto		= getprotobyname ("tcp") ;
	if (pProto == NULL)
		return	False ;
	/* åȤ */
	pJisyo->m_hSocket	= socket (AF_INET, SOCK_STREAM, pProto->p_proto) ;
	if (pJisyo->m_hSocket == INVALID_SOCKET)
		return	FALSE ;
	/* ФξФ*/
	memset ((char *)&(pJisyo->m_address), 0, sizeof (pJisyo->m_address)) ;
	pJisyo->m_address.sin_family	= AF_INET ;
	pJisyo->m_pHostent				= gethostbyname (pJisyo->m_szHostname) ;
	if (pJisyo->m_pHostent == NULL){
		shutdown (pJisyo->m_hSocket, 2) ;
		close (pJisyo->m_hSocket) ;
		pJisyo->m_hSocket			= INVALID_SOCKET ;
		return	False ;
	}
	memcpy (&(pJisyo->m_address.sin_addr), pJisyo->m_pHostent->h_addr, pJisyo->m_pHostent->h_length) ;
	pJisyo->m_address.sin_port	= htons ((unsigned short)pJisyo->m_nPortNum) ;

	/* ³ˤƤʤϴλƤ֤ˤ롣*/
	pJisyo->m_fConnect	= False ;
	pJisyo->m_fUsed		= True ;
	return	True ;
}

/*
 * SKK server Ȥ³λؿ
 */
Boolean
skkServerJisyo_closeServer (
	register PSKKSERVERJISYO	pJisyo)
{
	if (pJisyo == NULL || TFAILED (pJisyo->m_fConnect))
		return	True ;
	if (pJisyo->m_hSocket != INVALID_SOCKET){
		skkServerJisyo_sendCommand (pJisyo, SKKSERV_BYE, NULL, 0) ;
		shutdown (pJisyo->m_hSocket, 2) ;
		close (pJisyo->m_hSocket) ;
	}
	pJisyo->m_hSocket	= INVALID_SOCKET ;
	pJisyo->m_fConnect	= False ;
	return	True ;
}

Boolean
skkServerJisyo_recreateSocket (
	register PSKKSERVERJISYO	pJisyo)
{
	struct protoent*	pProto ;
	
	if (pJisyo == NULL || TFAILED (pJisyo->m_fUsed) || 
		TSUCCEEDED (pJisyo->m_fConnect) || 
		pJisyo->m_hSocket != INVALID_SOCKET)
		return	False ;

	/* Protocol ꡣ*/
	pProto		= getprotobyname ("tcp") ;
	if (pProto == NULL)
		return	False ;
	/* åȤ */
	pJisyo->m_hSocket	= socket (AF_INET, SOCK_STREAM, pProto->p_proto) ;
	if (pJisyo->m_hSocket == INVALID_SOCKET)
		return	False ;
	/* ФξФ*/
	memset ((char *)&(pJisyo->m_address), 0, sizeof (pJisyo->m_address)) ;
	pJisyo->m_address.sin_family	= AF_INET ;
	pJisyo->m_pHostent				= gethostbyname (pJisyo->m_szHostname) ;
	if (pJisyo->m_pHostent == NULL){
		shutdown (pJisyo->m_hSocket, 2) ;
		close (pJisyo->m_hSocket) ;
		pJisyo->m_hSocket			= INVALID_SOCKET ;
		return	FALSE ;
	}
	memcpy (&(pJisyo->m_address.sin_addr), pJisyo->m_pHostent->h_addr, pJisyo->m_pHostent->h_length) ;
	pJisyo->m_address.sin_port	= htons ((unsigned short)pJisyo->m_nPortNum) ;
	/* ³ˤƤʤϴλƤ֤ˤ롣*/
	pJisyo->m_fConnect			= False ;
	return	True ;	
}

/*
 * socket Ѱդskkerv ³ؿ
 *----
 */
Boolean
skkServerJisyo_openConnection (
	register PSKKSERVERJISYO	pJisyo)
{
	/* skkerv ̿뤿ΥåȤפޤ*/
	if (pJisyo->m_fConnect)
		return	True ;
	/* SOCKET Ƥʤä...*/
	if (pJisyo->m_hSocket == INVALID_SOCKET &&
		TFAILED (skkServerJisyo_recreateSocket (pJisyo)))
		return	False ;
	/* ³׵ᡣ*/
	if (connect (pJisyo->m_hSocket, (struct sockaddr*)&(pJisyo->m_address), sizeof (pJisyo->m_address)) < 0){
		perror ("connect") ;
		shutdown (pJisyo->m_hSocket, 2) ;
		close (pJisyo->m_hSocket) ;
		pJisyo->m_hSocket	= INVALID_SOCKET ;
		pJisyo->m_fConnect	= False ;
		return	False ;
	}
	/* ³*/
	pJisyo->m_fConnect	= True ;
	return	True ;
}

/*
 * skkserv  message ؿ
 */
Boolean
skkServerJisyo_sendCommand (
	register PSKKSERVERJISYO	pJisyo,
	register int				nCmd,
	register const Char*		pString,
	register int				nString)
{
	char			szBuffer [3] ;
	register int	nUsage ;
	TVarbuffer		vbuf ;

	assert (pJisyo->m_fConnect != False) ;

	switch (nCmd) {
	case	SKKSERV_BYE :
	case	SKKSERV_VERSION :
	case	SKKSERV_HOSTNAME :
		szBuffer [0]	= '0' + nCmd ;
		send (pJisyo->m_hSocket, szBuffer, 1, 0) ;
		break ;

	case SKKSERV_SEARCH :
		if (TFAILED (TVarbuffer_Initialize (&vbuf, sizeof (char))))
			return	False ;
		TVarbuffer_Add (&vbuf, "1", 1) ;
		nUsage	= 0 ;
		while (nString > 0) {
			switch (Char_Charset (*pString)) {
			case	KCHARSET_JISX0201_1976:
				if (Char_IsAscii (*pString)) 
					goto	ascii_char ;
				szBuffer [0]	= 0x8E ;
				szBuffer [1]	= (char) *pString ;
				nUsage			= 2 ;
				break ;
			case	KCHARSET_JISX0208_1978:
			case	KCHARSET_JISX0208_1983:
				szBuffer [0]	= (char)(Char_Code (*pString) >> 8) | 0x80 ;
				szBuffer [1]	= (char)(Char_Code (*pString)     ) | 0x80 ;
				nUsage			= 2 ;
				break ;
			case	KCHARSET_JISX0212_1990:
				szBuffer [0]	= (char)0x8F ;
				szBuffer [1]	= (char)(Char_Code (*pString) >> 8) | 0x80 ;
				szBuffer [2]	= (char)(Char_Code (*pString)     ) | 0x80 ;
				nUsage			= 3 ;
				break ;
			case	KCHARSET_ASCII:
				goto	ascii_char ;
			default:
				if (!Char_IsAscii (*pString)) 
					goto	skip ;
			  ascii_char:
				szBuffer [0]	= (char) *pString ;
				nUsage			= 1 ;
				break ;
			}
			if (TFAILED (TVarbuffer_Add (&vbuf, szBuffer, nUsage)))
				return	False ;
		  skip:
			pString	++ ;
			nString	-- ;
		}
		TVarbuffer_Add (&vbuf, " \n", 2) ;
		if (send (pJisyo->m_hSocket, (char *)TVarbuffer_GetBuffer (&vbuf), TVarbuffer_GetUsage (&vbuf), 0) < 0)
			perror ("send") ;
		TVarbuffer_Uninitialize (&vbuf) ;
		break ;

	default :
		return	False ;
	}
	return	True ;
}

/*
 *	skkserv ʸؿ
 *-----
 *	ɤΰ̤Ĺʸ󤬵äΤȽʤΤǡĹ
 *	ХåեǼäƤ롣
 */
Boolean
skkServerJisyo_getResult (
	register PSKKSERVERJISYO	pJisyo,
	register TVarbuffer*		pvbuf)
{
	char					szBuffer [SKKSERV_BUFSIZE] ;
	Char					schDest  [SKKSERV_BUFSIZE] ;
	register Char			cc ;
	register char*			ptr ;
	register int			nptr ;
	register Char*			pDest ;
	register int			nDest ;
	register int			nState ;
	register unsigned short	wc ;
	register char*			pBuffer ;
	register int			nBuffer ;

	pBuffer	= szBuffer ;
	nBuffer	= NELEMENTS (szBuffer) ;
	pDest	= schDest ;
	nDest	= NELEMENTS (schDest) ;
	nState	= 0 ;
	wc		= 0 ;
	for ( ; ; ) {
		nptr	= read (pJisyo->m_hSocket, szBuffer, sizeof (szBuffer)) ;
		ptr		= szBuffer ;
		while (nptr > 0) {
			switch (nState) {
			case	0:
				if (*ptr == (char)0x8E) {
					nState	= 3 ;
					break ;
				} else if (*ptr == (char)0x8F) {
					nState	= 2 ;
					break ;
				} else if ((*ptr & 0x80) != 0) {
					wc		= *ptr & 0x7F ;
					nState	= 1 ;
					break ;
				}
				if (*ptr == EOL)
					goto	exit_loop ;
				cc	= Char_MakeAscii (*ptr) ;
				goto	push_state ;
			case	1:
				wc	= (wc << 8) | ((*ptr) & 0x7F) ;
				cc	= Char_Make (KCHARSET_JISX0208_1983, wc) ;
				goto	push_state ;
			case	2:
				cc	= Char_Make (KCHARSET_JISX0201_1976, (unsigned char)(*ptr)) ;
				goto	push_state ;
			case	3:
				wc	= (unsigned char)(*ptr) & 0x7F ;
				nState	= 4 ;
				break ;
			case	4:
				wc	= (wc << 8) | ((*ptr) & 0x7F) ;
				cc	= Char_Make (KCHARSET_JISX0212_1990, wc) ;
				/*goto	push_state ;*/
			  push_state:
				if (nDest == 0) {
					if (TFAILED (TVarbuffer_Add (pvbuf, schDest, NELEMENTS (schDest))))
						return	False ;
					pDest		= schDest ;
					nDest		= NELEMENTS (schDest) ;
				}
				*pDest ++	= cc ;
				nDest  -- ;
				nState	= 0 ;
				wc		= 0 ;
				break ;
			default:
				return	False ;
			}
			ptr  ++ ;
			nptr -- ;
		}
	}
  exit_loop:
	if (nDest < NELEMENTS (schDest)) {
		if (TFAILED (TVarbuffer_Add (pvbuf, schDest, NELEMENTS (schDest) - nDest)))
			return	False ;
	}
	return	True ;
}

/*
 *	Фμ򥯥ꥢؿ
 *	ФˤŪʽλʸʤä 1  search
 *	˼Ԥư skkserv clone  skkserv ϰۤʤ롣
 *	˺ää
 */
void
skkServerJisyo_clearResult (
	register PSKKSERVERJISYO	pJisyo)
{
	char	szBuffer [SKKSERV_BUFSIZE] ;

	(void) read (pJisyo->m_hSocket, szBuffer, sizeof (szBuffer)) ;
	return ;
}

