#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"

Boolean
lispMgr_CreateXEvent (
	register TLispManager* 			pLispMgr,
	register TLispEntity*			pEntValue,
	register const XEvent*			pEvent,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*				pEntity ;
	register TLispXEventInt*	pEv ;

	assert (pLispMgr    != NULL) ;
	assert (pEntValue   != NULL) ;
	assert (ppEntReturn != NULL) ;

	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, sizeof (TLispXEventInt), &pEntity)))
		return	False ;
		
	pEntity->m_iType	= LISPENTITY_XEVENT ;
	pEv					= lispEntity_GetXEventPtr (pEntity) ;
	pEv					= (TLispXEventInt *)(pEntity + 1) ;
	pEv->m_pEntValue	= pEntValue ;
	lispEntity_AddRef (pLispMgr, pEntValue) ;
	memcpy (&pEv->m_evX, pEvent, sizeof (XEvent)) ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;
	*ppEntReturn		= pEntity ;
	return	True ;
}

void
lispMgr_DestroyXEvent (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity)
{
	register TLispXEventInt*	pEv	= lispEntity_GetXEventPtr (pEntity) ;
	
	assert (pLispMgr != NULL) ;
	assert (pEntity  != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_XEVENT) ;

	lispEntity_Release (pLispMgr, pEv->m_pEntValue) ;
	pEv->m_pEntValue	= NULL ;
	return ;
}

