#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"
#include "cstring.h"

#define	lispEntity_GetSymbolPtr(ptr)	((TLispSymbol *)((TLispEntity *)(ptr) + 1))

static	Boolean	lispMgr_registerSymbol        (TLispManager*, TLispEntity*) ;
static	Boolean	lispMgr_collectSymbolGarbage  (TLispManager*, TLispEntity*) ;
static	Boolean	lispMgr_createSymbol		  (TLispManager*, const Char*, int, TLispEntity** const) ;
static	Boolean	lispMgr_createSymbolA		  (TLispManager*, const char*, int, TLispEntity** const) ;

/*	inline functions */
static inline int
lispMgr_createSymbolHashkey (
	register const Char*	pString,
	register int			nString)
{
#if defined (DEBUG)
	register int	iRetval ;
#endif
	assert (pString != NULL) ;
	assert (nString > 0) ;

#if defined (DEBUG)
	iRetval	= ((unsigned)((int)*pString + nString * 13)) % LISPMGR_SIZE_SYMBOL_HASH ;
	assert (0 <= iRetval && iRetval < LISPMGR_SIZE_SYMBOL_HASH) ;
	return	iRetval ;
#else
	return	((unsigned)((int)*pString + nString * 13)) % LISPMGR_SIZE_SYMBOL_HASH ;
#endif
}

static inline int
lispMgr_createSymbolHashkeyA (
	register const char*	pString,
	register int			nString)
{
#if defined (DEBUG)
	register int	iRetval ;
#endif
	assert (pString != NULL) ;
	assert (nString > 0) ;

#if defined (DEBUG)
	iRetval	= ((unsigned)((int)Char_MakeAscii (*pString) + nString * 13)) % LISPMGR_SIZE_SYMBOL_HASH ;
	assert (0 <= iRetval && iRetval < LISPMGR_SIZE_SYMBOL_HASH) ;
	return	iRetval ;
#else
	return	((unsigned)((int)Char_MakeAscii (*pString) + nString * 13)) % LISPMGR_SIZE_SYMBOL_HASH ;
#endif
}

/*	global functions */


/*	LISP ܥ롣LISP ܥϽʣϵʤ*/
Boolean
lispMgr_CreateSymbol (
	register TLispManager*			pLispMgr,
	register const Char*			pSymName,
	register int					nSymName,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*	pEntity ;
	if (TFAILED (lispMgr_createSymbol (pLispMgr, pSymName, nSymName, &pEntity)))
		return	False ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;
	*ppEntReturn	= pEntity ;
	return	True ;
}

Boolean
lispMgr_CreateSymbolA (
	register TLispManager*			pLispMgr,
	register const char*			pSymName,
	register int					nSymName,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*	pEntity ;
	if (TFAILED (lispMgr_createSymbolA (pLispMgr, pSymName, nSymName, &pEntity)))
		return	False ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;
	*ppEntReturn	= pEntity ;
	return	True ;
}

Boolean
lispMgr_InternSymbol (
	register TLispManager*			pLispMgr,
	register const Char*			pSymName,
	register int					nSymName,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*	pEntity ;

	assert (pLispMgr    != NULL) ;
	assert (pSymName    != NULL && nSymName > 0) ;
	assert (ppEntReturn != NULL) ;

	if (TFAILED (lispMgr_SearchSymbol (pLispMgr, pSymName, nSymName, &pEntity)))
		return	False ;
	
	if (pEntity == NULL) {
		if (TFAILED (lispMgr_createSymbol (pLispMgr, pSymName, nSymName, &pEntity)))
			return	False ;
		lispMgr_registerSymbol (pLispMgr, pEntity) ;
	}
	*ppEntReturn	= pEntity ;
	return	True ;
}

Boolean
lispMgr_InternSymbolA (
	register TLispManager*			pLispMgr,
	register const char*			pSymName,
	register int					nSymName,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*	pEntity ;

	assert (pLispMgr    != NULL) ;
	assert (pSymName    != NULL && nSymName > 0) ;
	assert (ppEntReturn != NULL) ;

	if (TFAILED (lispMgr_SearchSymbolA (pLispMgr, pSymName, nSymName, &pEntity)))
		return	False ;
	
	if (pEntity == NULL) {
		if (TFAILED (lispMgr_createSymbolA (pLispMgr, pSymName, nSymName, &pEntity)))
			return	False ;
		lispMgr_registerSymbol (pLispMgr, pEntity) ;
	}
	*ppEntReturn	= pEntity ;
	return	True ;
}

Boolean
lispMgr_CollectSymbolGarbage (
	register TLispManager* pLispMgr)
{
	register TLispEntity**	ppEntity ;
	register int			i ;
	
	/*	Conscell, Vector 黲ȤƤƤ ENTITY  Mark 줿*/
	ppEntity	= pLispMgr->m_apSymbolListTop ;
	for (i = 0 ; i < LISPMGR_SIZE_SYMBOL_HASH ; i ++) 
		lispMgr_collectSymbolGarbage (pLispMgr, *ppEntity ++) ;
	return	True ;
}

/*
 *	intern-soft Ѥ global ǤʤФʤʤ
 */
Boolean
lispMgr_SearchSymbol (
	register TLispManager*		pLispMgr,
	register const Char*		pString,
	register int				nString,
	register TLispEntity**		ppSymbolRet)
{
	register TLispEntity*	pEntity ;
	register TLispEntity*	pRetvalue ;
	register TLispSymbol*	pSymbol ;
	register int			iHashKey ;
	register int			iCompare ;

	assert (pString != NULL) ;
	assert (nString > 0) ;

	iHashKey	= lispMgr_createSymbolHashkey (pString, nString) ;
	pEntity		= pLispMgr->m_apSymbolListTop [iHashKey] ;
	pRetvalue	= NULL ;
	
	while (pEntity != NULL) {
		assert (pEntity->m_iType == LISPENTITY_SYMBOL) ;
		pSymbol		= lispEntity_GetSymbolPtr (pEntity) ;
		iCompare	= cmemcmp (pSymbol->m_achName, pSymbol->m_nLength, pString, nString) ;

		if (iCompare > 0) {
			/*	ڤ > Ƥ --> ꡣ*/
			pEntity	= pEntity->m_pLeft ;
		} else if (iCompare < 0) {
			/*	ڤ < Ƥ --> ꡣ*/
			pEntity	= pEntity->m_pRight ;
		} else {
			/*	դäν*/
			pRetvalue	= pEntity ;
			break ;
		}
	}
	*ppSymbolRet	= pRetvalue ;
	return	True ;
}

Boolean
lispMgr_SearchSymbolA (
	register TLispManager*		pLispMgr,
	register const char*		pString,
	register int				nString,
	register TLispEntity**		ppSymbolRet)
{
	register TLispEntity*	pEntity ;
	register TLispEntity*	pRetvalue ;
	register TLispSymbol*	pSymbol ;
	register int			iHashKey ;
	register int			iCompare ;

	assert (pString != NULL) ;
	assert (nString > 0) ;

	iHashKey	= lispMgr_createSymbolHashkeyA (pString, nString) ;
	pEntity		= pLispMgr->m_apSymbolListTop [iHashKey] ;
	pRetvalue	= NULL ;
	
	while (pEntity != NULL) {
		assert (pEntity->m_iType == LISPENTITY_SYMBOL) ;
		pSymbol		= lispEntity_GetSymbolPtr (pEntity) ;
		iCompare	= cmemccmp (pSymbol->m_achName, pSymbol->m_nLength, pString, nString) ;
		
		if (iCompare > 0) {
			/*	ڤ > Ƥ --> ꡣ*/
			pEntity	= pEntity->m_pLeft ;
		} else if (iCompare < 0) {
			/*	ڤ < Ƥ --> ꡣ*/
			pEntity	= pEntity->m_pRight ;
		} else {
			/*	դäν*/
			pRetvalue	= pEntity ;
			break ;
		}
	}
	*ppSymbolRet	= pRetvalue ;
	return	True ;
}

/*
 *	unintern Ѥ Unregister  global ǤʤФʤʤ
 */
Boolean
lispMgr_UnregisterSymbol (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity)
{
	register TLispSymbol*	pSymbol ;
	register int			iHashkey ;

	assert (pLispMgr != NULL) ;
	assert (pEntity  != NULL) ;

	assert (pEntity != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_SYMBOL) ;

	pSymbol		= lispEntity_GetSymbolPtr (pEntity) ;
	iHashkey	= lispMgr_createSymbolHashkey (pSymbol->m_achName, pSymbol->m_nLength) ;
	if (pEntity->m_pLeft == NULL) {
		if (pSymbol->m_pParent != NULL) {
			assert (pSymbol->m_pParent != NULL) ;
			assert (pSymbol->m_pParent->m_pLeft  == pEntity ||
					pSymbol->m_pParent->m_pRight == pEntity) ;
			if (pSymbol->m_pParent->m_pLeft == pEntity) {
				pSymbol->m_pParent->m_pLeft	= pEntity->m_pRight ;
			} else {
				pSymbol->m_pParent->m_pRight= pEntity->m_pRight ;
			}
		} else {
			assert (pLispMgr->m_apSymbolListTop [iHashkey] == pEntity) ;
			pLispMgr->m_apSymbolListTop [iHashkey]	= pEntity->m_pRight ;
		}
		/*	ʬλҶοƤѹ롣*/
		if (pEntity->m_pRight != NULL) {
			register TLispSymbol*	pSymRight ;
			pSymRight	= lispEntity_GetSymbolPtr (pEntity->m_pRight) ;
			pSymRight->m_pParent	= pSymbol->m_pParent ;
		}
	} else if (pEntity->m_pRight == NULL) {
		register TLispSymbol*	pSymLeft ;
		if (pSymbol->m_pParent != NULL) {
			assert (pSymbol->m_pParent != NULL) ;
			assert (pSymbol->m_pParent->m_pLeft  == pEntity ||
					pSymbol->m_pParent->m_pRight == pEntity) ;
			if (pSymbol->m_pParent->m_pLeft == pEntity) {
				pSymbol->m_pParent->m_pLeft	= pEntity->m_pLeft ;
			} else {
				pSymbol->m_pParent->m_pRight	= pEntity->m_pLeft ;
			}
		} else {
			assert (pLispMgr->m_apSymbolListTop [iHashkey] == pEntity) ;
			pLispMgr->m_apSymbolListTop [iHashkey]	= pEntity->m_pLeft ;
		}
		/*	ʬλҶοƤѹ롣*/
		pSymLeft	= lispEntity_GetSymbolPtr (pEntity->m_pLeft) ;
		pSymLeft->m_pParent	= pSymbol->m_pParent ;
	} else {
		register TLispEntity*	pChild ;
		register TLispSymbol*	pSymLeft ;

		pChild	= pEntity->m_pLeft ;
		while (pChild->m_pRight != NULL) 
			pChild	= pChild->m_pRight ;
		pChild->m_pRight	= pEntity->m_pRight ;

		if (pSymbol->m_pParent != NULL) {
			assert (pSymbol->m_pParent != NULL) ;
			assert (pSymbol->m_pParent->m_pLeft  == pEntity ||
					pSymbol->m_pParent->m_pRight == pEntity) ;
			
			if (pSymbol->m_pParent->m_pLeft == pEntity) {
				pSymbol->m_pParent->m_pLeft	= pEntity->m_pLeft ;
			} else {
				pSymbol->m_pParent->m_pRight= pEntity->m_pLeft ;
			}
		} else {
			assert (pLispMgr->m_apSymbolListTop [iHashkey] == pEntity) ;
			pLispMgr->m_apSymbolListTop [iHashkey]	= pEntity->m_pLeft ;
		}
		pSymLeft			= lispEntity_GetSymbolPtr (pEntity->m_pLeft) ;
		pSymLeft->m_pParent	= pSymbol->m_pParent ;
	}

	pSymbol->m_pParent	= NULL ;
	pEntity->m_pLeft	= NULL ;
	pEntity->m_pRight	= NULL ;

	return	True ;
}

Boolean
lispMgr_registerSymbol (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity)
{
	register TLispSymbol*	pNewSymbol ;
	register const Char*	pNewSymName ;
	register int			nNewSymName ;
	register int			iHashKey ;
	register TLispEntity*	pRoot ;
	register TLispSymbol*	pSymbol ;
	register int			iCompare ;
	
	assert (pLispMgr != NULL) ;
	assert (pEntity  != NULL) ;
	assert (pEntity->m_iType == LISPENTITY_SYMBOL) ;

	pNewSymbol	= lispEntity_GetSymbolPtr (pEntity) ;
	pNewSymName	= pNewSymbol->m_achName ;
	nNewSymName	= pNewSymbol->m_nLength ;
	assert (nNewSymName > 0) ;
	
	pEntity->m_pLeft	= NULL ;
	pEntity->m_pRight	= NULL ;

	iHashKey	= lispMgr_createSymbolHashkey (pNewSymName, nNewSymName) ;
	if (pLispMgr->m_apSymbolListTop [iHashKey] == NULL) {
		pLispMgr->m_apSymbolListTop [iHashKey]	= pEntity ;
		pNewSymbol->m_pParent	= NULL ;
		return	True ;
	}

	pRoot	= pLispMgr->m_apSymbolListTop [iHashKey] ;
	while (pRoot != NULL) {
		assert (pRoot->m_iType == LISPENTITY_SYMBOL) ;
		pSymbol		= lispEntity_GetSymbolPtr (pRoot) ;
		iCompare	= cmemcmp (pSymbol->m_achName, pSymbol->m_nLength, pNewSymName, nNewSymName) ;
		assert (iCompare != 0) ;
		
		if (iCompare > 0) {
			if (pRoot->m_pLeft == NULL) {
				pRoot->m_pLeft		= pEntity ;
				pNewSymbol->m_pParent	= pRoot ;
				return	True ;
			}
			pRoot	= pRoot->m_pLeft ;
		} else {
			if (pRoot->m_pRight == NULL) {
				pRoot->m_pRight		= pEntity ;
				pNewSymbol->m_pParent	= pRoot ;
				return	True ;
			}
			pRoot	= pRoot->m_pRight ;
		}
	}
	return	False ;
}

Boolean
lispMgr_collectSymbolGarbage (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity)
{
	assert (pLispMgr != NULL) ;

	if (pEntity == NULL)
		return	True ;

	if (pEntity->m_pLeft != NULL)
		lispMgr_collectSymbolGarbage (pLispMgr, pEntity->m_pLeft) ;

	if (pEntity->m_pRight != NULL)
		lispMgr_collectSymbolGarbage (pLispMgr, pEntity->m_pRight) ;

	if (pEntity->m_lReferCount == 0 && pEntity->m_iMarker != pLispMgr->m_iMarker) {
		lispMgr_UnregisterSymbol (pLispMgr, pEntity) ;
		lispMgr_DestroyEntity (pLispMgr, pEntity) ;
	} else {
		pEntity->m_iMarker	= pLispMgr->m_iMarker ;
	}
	return	True ;
}

Boolean
lispMgr_createSymbol (
	register TLispManager*			pLispMgr,
	register const Char*			pSymName,
	register int					nSymName,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*			pEntity ;
	register TLispSymbol*	pSymbol ;
	register size_t			nSize ;

	assert (pLispMgr    != NULL) ;
	assert (pSymName    != NULL && nSymName > 0) ;
	assert (ppEntReturn != NULL) ;

	nSize	= sizeof (Char) * (nSymName - 1) + sizeof (TLispSymbol) ;
	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, nSize, &pEntity)))
		return	False ;
		
	pEntity->m_iType	= LISPENTITY_SYMBOL ;
	pSymbol				= lispEntity_GetSymbolPtr (pEntity) ;
	memcpy (pSymbol->m_achName, pSymName, sizeof (Char) * nSymName) ;
	pSymbol->m_nLength	= nSymName ;

	*ppEntReturn	= pEntity ;
	return	True ;
}

Boolean
lispMgr_createSymbolA (
	register TLispManager*			pLispMgr,
	register const char*			pSymName,
	register int					nSymName,
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*			pEntity ;
	register TLispSymbol*	pSymbol ;
	register size_t			nSize ;

	assert (pLispMgr    != NULL) ;
	assert (pSymName    != NULL && nSymName > 0) ;
	assert (ppEntReturn != NULL) ;

	nSize	= sizeof (Char) * (nSymName - 1) + sizeof (TLispSymbol) ;
	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, nSize, &pEntity)))
		return	False ;
		
	pEntity->m_iType	= LISPENTITY_SYMBOL ;
	pSymbol				= lispEntity_GetSymbolPtr (pEntity) ;
	strtocstr (pSymbol->m_achName, pSymName, nSymName) ;
	pSymbol->m_nLength	= nSymName ;

	*ppEntReturn	= pEntity ;
	return	True ;
}

