#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"
#include "cstring.h"
#include "varbuffer.h"
#if defined (WIN32)
#include "unicodemap.h"
#endif

static	Boolean	appendList		(TLispManager*, TLispEntity*, TLispEntity**, TLispEntity**) ;
static	Boolean	appendVector	(TLispManager*, TLispEntity*, TLispEntity**, TLispEntity**) ;
static	Boolean	appendString	(TLispManager*, TLispEntity*, TLispEntity**, TLispEntity**) ;
static	Boolean	lispMgr_deleteDelqCommon	(TLispManager*, TLispEntity*, TLispEntity*, Boolean (*)(TLispManager*, TLispEntity*, TLispEntity*), TLispEntity**) ;
static	Boolean	lispEntity_fakeEq	(TLispManager*, TLispEntity*, TLispEntity*) ;

/*	Library Global Function */	
/*
 *	եɤ߹ߡᤷ塢֤
 */
Boolean
lispMgr_Load (
	register TLispManager*			pLispMgr,
	register const Char*			pFileName,
	register int					nFileNameLen,
	register TLispEntity** const	ppReturn)
{
	TVarbuffer		vbufFileName ;
#if defined (WIN32)
	LPCWSTR			pchFileName ;
	wchar_t			wc ;
#else
	const char*		pchFileName ;
	char			ch ;
#endif
	TLispEntity*	pRetval ;

#if defined (WIN32)
	if (TFAILED (TVarbuffer_Initialize (&vbufFileName, sizeof (wchar_t)))) 
		return	False ;
	while (nFileNameLen > 0) {
		wc	= Char_ToUnicode (*pFileName ++) ;
		if (TFAILED (TVarbuffer_Add (&vbufFileName, &wc, 1)))
			return	False ;
		nFileNameLen	-- ;
	}
	wc	= '\0' ;
	if (TFAILED (TVarbuffer_Add (&vbufFileName, &wc, 1)))
		return	False ;
#else
	if (TFAILED (TVarbuffer_Initialize (&vbufFileName, sizeof (char))))
		return	False ;
	while (nFileNameLen > 0) {
		/*	ASCII ʳʸǧʤȤˤ롣*/
		if (!Char_IsAscii (*pFileName))
			return	False ;
		ch	= (char) *pFileName ;
		if (TFAILED (TVarbuffer_Add (&vbufFileName, &ch, 1)))
			return	False ;
		pFileName		++ ;
		nFileNameLen	-- ;
	}
	ch	= '\0' ;
	if (TFAILED (TVarbuffer_Add (&vbufFileName, &ch, 1)))
		return	False ;
#endif
	pchFileName	= TVarbuffer_GetBuffer (&vbufFileName) ;
	pRetval		= lispMgr_ParseFile (pLispMgr, pchFileName) ;
	TVarbuffer_Uninitialize (&vbufFileName) ;

	*ppReturn	= pRetval ;
	return	(pRetval == NULL)? False : True ;
}

Boolean
lispMgr_Append (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pSequence,
	register TLispEntity** const	ppReturn)
{
	TLispEntity*	pHead ;
	TLispEntity*	pTail ;
	int				iType ;

	pHead		= NULL ;
	pTail		= NULL ;

	if (TFAILED (lispEntity_Nullp (pLispMgr, pSequence))) {
		TLispEntity*	pArg ;
		TLispEntity*	pNextSequence ;

		pArg	= NULL ;
		for ( ; ; ) {
			if (TFAILED (lispEntity_GetCar    (pLispMgr, pSequence, &pArg)) ||
				TFAILED (lispEntity_Sequencep (pLispMgr, pArg)) ||
				TFAILED (lispEntity_GetCdr    (pLispMgr, pSequence, &pNextSequence))) {
				if (pHead != NULL)
					lispEntity_Release (pLispMgr, pHead) ;
				return	False ;
			}
			if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pNextSequence))) 
				break ;
			lispEntity_GetType (pLispMgr, pArg, &iType) ;
			switch (iType) {
			case	LISPENTITY_CONSCELL:
				if (TFAILED (appendList (pLispMgr, pArg, &pHead, &pTail))) 
					goto	exit_loop ;
				break ;
			case	LISPENTITY_VECTOR:
				if (TFAILED (appendVector (pLispMgr, pArg, &pHead, &pTail)))
					goto	exit_loop ;
				break ;
			case	LISPENTITY_STRING:
				if (TFAILED (appendString (pLispMgr, pArg, &pHead, &pTail)))
					goto	exit_loop ;
				break ;
			default:
				break ;
			}
			pSequence	= pNextSequence ;
		}
	exit_loop:
		if (pTail != NULL && pArg != NULL) {
			if (TFAILED (lispEntity_SetCdr (pLispMgr, pTail, pArg))) {
				if (pHead != NULL)
					lispEntity_Release (pLispMgr, pHead) ;
				return	False ;
			}
		}
	}
	if (pHead == NULL) {
		lispMgr_CreateNil (pLispMgr, &pHead) ;
	} else {
		lispEntity_Release (pLispMgr, pHead) ;
	}
	*ppReturn	= pHead ;
	return	True ;
}

Boolean
lispMgr_Nreverse (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pList,
	register TLispEntity**	ppReturn)
{
	TVarbuffer		vbufEntity ;
	TLispEntity*	pRetval	= NULL ;
	TLispEntity*	pCar ;
	TLispEntity*	pNextList ;
	int				nEntity ;

	if (TFAILED (TVarbuffer_Initialize (&vbufEntity, sizeof (TLispEntity *))))
		return	False ;

	while (TFAILED (lispEntity_Nullp (pLispMgr, pList))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pList, &pCar)) ||
			TFAILED (TVarbuffer_Add (&vbufEntity, &pCar, 1)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pList, &pNextList)))
			goto	error_occur ;
		pList	= pNextList ;
	}
	nEntity		= TVarbuffer_GetUsage (&vbufEntity) ;
	if (nEntity > 0) {
		TLispEntity*	pHead ;
		TLispEntity*	pTail ;
		TLispEntity*	pNewTail ;
		TLispEntity*	pNil ;
		TLispEntity**	ppEntity ;
		
		lispMgr_CreateNil (pLispMgr, &pNil) ;
		ppEntity	= (TLispEntity **)TVarbuffer_GetBuffer (&vbufEntity) + nEntity - 1 ;
		if (TFAILED (lispMgr_CreateConscell (pLispMgr, *ppEntity, pNil, &pHead))) {
			pHead	= NULL ;
			goto	create_error ;
		}
		lispEntity_AddRef (pLispMgr, pHead) ;
		ppEntity	-- ;
		nEntity		-- ;
		pTail		= pHead ;

		while (nEntity > 0) {
			if (TFAILED (lispMgr_CreateConscell (pLispMgr, *ppEntity, pNil, &pNewTail))) {
				lispEntity_Release (pLispMgr, pHead) ;
				pHead	= NULL ;
				goto	create_error ;
			}
			lispEntity_SetCdr (pLispMgr, pTail, pNewTail) ;
			pTail	= pNewTail ;
			ppEntity	-- ;
			nEntity		-- ;
		}
	create_error:
		pRetval	= pHead ;
	} else {
		lispMgr_CreateNil (pLispMgr, &pRetval) ;
		lispEntity_AddRef (pLispMgr, pRetval) ;
	}
 error_occur:
	TVarbuffer_Uninitialize (&vbufEntity) ;
	*ppReturn	= pRetval ;
	if (pRetval != NULL) {
		lispEntity_Release (pLispMgr, pRetval) ;
		return	True ;
	} else {
		return	False ;
	}
}

Boolean
lispMgr_Delete (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pElt,
	register TLispEntity*	pList,
	register TLispEntity**	ppReturn)
{
	return	lispMgr_deleteDelqCommon (pLispMgr, pElt, pList, &lispEntity_Equal, ppReturn) ;
}

Boolean
lispMgr_Delq (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pElt,
	register TLispEntity*	pList,
	register TLispEntity**	ppReturn)
{
	return	lispMgr_deleteDelqCommon (pLispMgr, pElt, pList, &lispEntity_fakeEq, ppReturn) ;
}

/*	ʲ private function */
Boolean
appendList (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity,
	register TLispEntity**	ppListHead,
	register TLispEntity**	ppListTail)
{
	register TLispEntity*	pHead ;
	TLispEntity*	pTail ;
	TLispEntity*	pCar ;
	TLispEntity*	pCdr ;
	TLispEntity*	pNewTail ;
	TLispEntity*	pNil ;

	assert (pLispMgr   != NULL) ;
	assert (pEntity    != NULL) ;
	assert (ppListHead != NULL) ;
	assert (ppListTail != NULL) ;

	pHead	= *ppListHead ;
	pTail	= *ppListTail ;
	lispMgr_CreateNil (pLispMgr, &pNil) ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntity))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntity, &pCar)))
			return	False ;
		if (TFAILED (lispMgr_CreateConscell (pLispMgr, pCar, pNil, &pNewTail)))
			return	False ;
		if (pTail == NULL) {
			assert (pHead == NULL) ;
			lispEntity_AddRef (pLispMgr, pNewTail) ;
			pHead	= pNewTail ;
		} else {
			lispEntity_SetCdr (pLispMgr, pTail, pNewTail) ;
		}
		pTail	= pNewTail ;
		if (TFAILED (lispEntity_GetCdr (pLispMgr, pEntity, &pCdr)))
			return	False ;
		pEntity	= pCdr ;
	}
	*ppListHead	= pHead ;
	*ppListTail	= pTail ;
	return	True ;
}

Boolean
appendVector (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity,
	register TLispEntity**	ppListHead,
	register TLispEntity**	ppListTail)
{
	TLispEntity*	pHead ;
	TLispEntity*	pTail ;
	TLispEntity*	pNewTail ;
	TLispEntity*	pNil ;
	TLispEntity**	ppElements ;
	int				nElements ;

	assert (pLispMgr   != NULL) ;
	assert (pEntity    != NULL) ;
	assert (ppListHead != NULL) ;
	assert (ppListTail != NULL) ;

	lispMgr_CreateNil (pLispMgr, &pNil) ;
	if (TFAILED (lispEntity_GetVectorValue (pLispMgr, pEntity, &ppElements, &nElements)))
		return	False ;

	if (ppElements != NULL && nElements > 0) {
		pHead	= *ppListHead ;
		pTail	= *ppListTail ;
		while (nElements > 0) {
			if (TFAILED (lispMgr_CreateConscell (pLispMgr, *ppElements, pNil, &pNewTail)))
				break ;
			if (pTail == NULL) {
				assert (pHead == NULL) ;
				lispEntity_AddRef (pLispMgr, pNewTail) ;
				pHead	= pNewTail ;
			} else {
				lispEntity_SetCdr (pLispMgr, pTail, pNewTail) ;
			}
			pTail	= pNewTail ;
			ppElements	++ ;
			nElements	-- ;
		}
		*ppListHead	= pHead ;
		*ppListTail	= pTail ;
	}
	return	(nElements > 0)? False : True ;
}

Boolean
appendString (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity,
	register TLispEntity**	ppListHead,
	register TLispEntity**	ppListTail)
{
	TLispEntity*	pHead ;
	TLispEntity*	pTail ;
	TLispEntity*	pNewTail ;
	TLispEntity*	pNil ;
	TLispEntity*	pInteger ;
	const Char*		pString ;
	int				nLength ;

	assert (pLispMgr   != NULL) ;
	assert (pEntity    != NULL) ;
	assert (ppListHead != NULL) ;
	assert (ppListTail != NULL) ;

	lispMgr_CreateNil (pLispMgr, &pNil) ;
	if (TFAILED (lispEntity_GetStringValue (pLispMgr, pEntity, &pString, &nLength)))
		return	False ;
	if (pString != NULL && nLength > 0) {
		pHead	= *ppListHead ;
		pTail	= *ppListTail ;
		while (nLength > 0) {
			if (TFAILED (lispMgr_CreateConscell (pLispMgr, pNil, pNil, &pNewTail)))
				break ;
			if (pTail == NULL) {
				assert (pHead == NULL) ;
				lispEntity_AddRef (pLispMgr, pNewTail) ;
				pHead	= pNewTail ;
			} else {
				lispEntity_SetCdr (pLispMgr, pTail, pNewTail) ;
			}
			if (TFAILED (lispMgr_CreateInteger (pLispMgr, *pString, &pInteger)))
				break ;
			lispEntity_SetCar (pLispMgr, pNewTail, pInteger) ;
			pTail	= pNewTail ;
			pString	++ ;
			nLength	-- ;
		}
		*ppListHead	= pHead ;
		*ppListTail	= pTail ;
	}
	return	(nLength > 0)? False : True ;
}

Boolean
lispMgr_deleteDelqCommon (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pElt,
	register TLispEntity*	pList,
	register Boolean			(*pCompFunc)(TLispManager*, TLispEntity*, TLispEntity*),
	register TLispEntity**	ppReturn)
{
	TLispEntity*	pListElt ;
	TLispEntity*	pHead ;
	TLispEntity*	pPrevList ;
	TLispEntity*	pNextList ;

	assert (pLispMgr  != NULL) ;
	assert (pElt      != NULL) ;
	assert (pList     != NULL) ;
	assert (pCompFunc != NULL) ;
	assert (ppReturn  != NULL) ;

	if (TFAILED (lispEntity_Listp (pLispMgr, pList)))
		return	False ;

	while (TFAILED (lispEntity_Nullp (pLispMgr, pList))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pList, &pListElt)))
			return	False ;

		if (TFAILED ((*pCompFunc) (pLispMgr, pElt, pListElt)))
			break ;
		if (TFAILED (lispEntity_GetCdr (pLispMgr, pList, &pNextList)))
			return	False ;
		pList	= pNextList ;
	}
	pHead		= pList ;
	pPrevList	= NULL ;
	while (TFAILED (lispEntity_Nullp (pLispMgr, pList))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pList, &pListElt)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pList, &pNextList)))
			return	False ;

		if (TSUCCEEDED ((*pCompFunc) (pLispMgr, pElt, pListElt))) {
			assert (pPrevList != NULL) ;
			lispEntity_SetCdr (pLispMgr, pPrevList, pNextList) ;
		} else {
			pPrevList	= pList ;
		}
		pList		= pNextList ;
	}
	*ppReturn	= pHead ;
	return	True ;
}

Boolean
lispEntity_fakeEq (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pLeft,
	register TLispEntity*	pRight)
{
	return	(pLeft == pRight) ;
}

