#include "local.h"
#include "jisyop.h"
#include "cstring.h"

#define	TEXTBUFSIZE	(1024)

/*
 *	Private Prototypes
 */
static	Boolean		skkJisyo_searchWithFileptr (KFILE*, const Char*, int, Boolean, TVarbuffer*) ;
static	Boolean		skkJisyo_tryCompletionWithFileptr (KFILE*, const Char*, int, TVarbuffer*) ;
static	Boolean		skkJisyo_okuriSearchWithFileptr (KFILE*, const Char* const, const int, TVarbuffer*) ;
static	Boolean		skkJisyo_okuriSearchCheckCandidate (KFILE*, const Char* const, const int, TVarbuffer*) ;
static	Boolean		skkJisyo_okuriSearchFound (KFILE*, const Char* const, const int, TVarbuffer*) ;

/*
 *	Global Variables
 */
static	PSKKJISYO	pLocalJisyosTop	= NULL ;

/*
 *	Functions 
 */

/*
 *	ꤵ줿ѥμꤵ줿ʸ沽ˡȤϿؿ
 */
PSKKJISYO
SkkJisyo_Register (
	register const Char*	pFileName,
	register int			nFileName,
	register int			nCodingSystem)
{
	TCHAR		strPath [PATH_MAX] ;
	KFILE		kf ;
	PSKKJISYO	pJisyo ;
	PSKKJISYO	pPrevJisyo ;
	PSKKJISYO	pNewJisyo ;
	int			nResult ;

	/*	ɽʸºݤ OS  filesystem ˻ȤäƤ coding system 
	 *	ʸѴ롣 ASCII ܤˤʤäƤ롣*/
	cstrtostr (strPath, pFileName, (nFileName < PATH_MAX)? nFileName : PATH_MAX) ;
	if (nFileName < PATH_MAX) {
		strPath [nFileName]		= '\0' ;
	} else {
		strPath [PATH_MAX - 1]	= '\0' ;
	}

	/* ϿƤ뼭Ǥ뤫Ĵ٤롣*/
	pJisyo		= pLocalJisyosTop ;
	pPrevJisyo	= NULL ;
	while (pJisyo != NULL){
		nResult	= strcmp (pJisyo->m_tszPath, strPath) ;
		if (!nResult)
			return	pJisyo ;
		if (nResult > 0)
			break ;
		pPrevJisyo	= pJisyo ;
		pJisyo		= pJisyo->m_pNext ;
	}

	/* ե뤿Υǡΰݤ롣*/
	pNewJisyo	= MALLOC (sizeof (SKKJISYO)) ;
	if (pNewJisyo == NULL)
		return	NULL ;
	strcpy (pNewJisyo->m_tszPath, strPath) ;

	KFile_Init (&kf) ;
	if (!KFile_Open (&kf, pNewJisyo->m_tszPath, KCODING_SYSTEM_UNKNOWN)) {
		/* ե뤬¸ߤʤСϿ뤳ȤϽʤ*/
		FREE (pNewJisyo) ;
		return	NULL ;
	}
	/* ʸ沽ˡ򸡽Ф롣*/
	pNewJisyo->m_nCodingSystem	= KFile_GetCodingSystem (&kf) ;
	KFile_Close (&kf) ;

	/* ꥹȤ˲ä롣*/
	pNewJisyo->m_pNext		= pJisyo ;
	if (pPrevJisyo == NULL){
		pLocalJisyosTop		= pNewJisyo ;
	} else {
		pPrevJisyo->m_pNext	= pNewJisyo ;
	}
	return	pNewJisyo ;
}

/*
 *	ꤵ줿ѥμؿ
 */
Boolean
SkkJisyo_Unregister (
	register const Char*	pFileName,
	register int			nFileName)
{
	TCHAR		strPath [PATH_MAX] ;
	PSKKJISYO	pJisyo ;
	PSKKJISYO	pPrevJisyo ;
	int			nResult ;

	/*	ɽʸºݤ OS  filesystem ˻ȤäƤ coding system 
	 *	ʸѴ롣 ASCII ܤˤʤäƤ롣*/
	cstrtostr (strPath, pFileName, (nFileName < PATH_MAX)? nFileName : PATH_MAX) ;
	if (nFileName < PATH_MAX) {
		strPath [nFileName]		= '\0' ;
	} else {
		strPath [PATH_MAX - 1]	= '\0' ;
	}

	pJisyo		= pLocalJisyosTop ;
	pPrevJisyo	= NULL ;
	while (pJisyo != NULL){
		nResult	= strcmp (pJisyo->m_tszPath, strPath) ;
		if (!nResult){
			if (pPrevJisyo != NULL){
				pLocalJisyosTop		= pJisyo->m_pNext ;
			} else {
				pPrevJisyo->m_pNext	= pJisyo->m_pNext ;
			}
			FREE (pJisyo) ;
			return	True ;
		}
		if (nResult > 0)
			return	False ;
		pPrevJisyo	= pJisyo ;
		pJisyo		= pJisyo->m_pNext ;
	}
	return	False ;
}

PSKKJISYO
SkkJisyo_Find (
	register const Char*	pFileName,
	register int			nFileName)
{
	TCHAR		strPath [PATH_MAX] ;
	PSKKJISYO	pJisyo ;
	int			nResult ;

	/*	ɽʸºݤ OS  filesystem ˻ȤäƤ coding system 
	 *	ʸѴ롣 ASCII ܤˤʤäƤ롣*/
	cstrtostr (strPath, pFileName, (nFileName < PATH_MAX)? nFileName : PATH_MAX) ;
	if (nFileName < PATH_MAX) {
		strPath [nFileName]		= '\0' ;
	} else {
		strPath [PATH_MAX - 1]	= '\0' ;
	}

	pJisyo		= pLocalJisyosTop ;
	while (pJisyo != NULL){
		nResult	= strcmp (pJisyo->m_tszPath, strPath) ;
		if (!nResult)
			return	pJisyo ;
		if (nResult > 0)
			return	NULL ;
		pJisyo		= pJisyo->m_pNext ;
	}
	return	NULL ;
}

/*
 *	Ϳ줿ǥ桼򸡺ؿ
 */
Boolean
SkkJisyo_Search (
	register PSKKJISYO		pJisyo,
	register const Char*	pKey,
	register int			nKey,
	register Boolean		fOkuri,
	register TVarbuffer*	pvbuf)
{
	KFILE		kf ;
	Boolean		fResult ;

	assert (pJisyo != NULL) ;
	/* 򳫤ʤä顢顼*/
	if (!KFile_Open (&kf, pJisyo->m_tszPath, pJisyo->m_nCodingSystem)) 
		return	False ;
	fResult	= skkJisyo_searchWithFileptr (&kf, pKey, nKey, fOkuri, pvbuf) ;
	KFile_Close (&kf) ;
	return	fResult ;
}

Boolean
SkkJisyo_OkuriSearch (
	register PSKKJISYO		pJisyo,
	register const Char*	pStrKey,
	register int			nStrKey,
	register TVarbuffer*	pvbuf)
{
	KFILE				kf ;
	register Boolean	fRetval ;

	/* 򳫤ʤä顢顼*/
	if (!KFile_Open (&kf, pJisyo->m_tszPath, pJisyo->m_nCodingSystem)) 
		return	False ;
	fRetval	= skkJisyo_okuriSearchWithFileptr (&kf, pStrKey, nStrKey, pvbuf) ;
	KFile_Close (&kf) ;
	return	fRetval ;
}

/*
 *	Ϳ줿䴰Ǥʤ桼򸡺ؿ
 */
Boolean
SkkJisyo_TryCompletion (
	register const Char*	pFileName,
	register int			nFileName,
	register const Char*	pKey,
	register int			nKey,
	register TVarbuffer*	pvbuf)
{	
	KFILE		kf ;
	PSKKJISYO	pJisyo ;
	Boolean		fResult ;

	pJisyo			= SkkJisyo_Find (pFileName, nFileName) ;
	if (pJisyo == NULL)
		return	False ;

	if (!KFile_Open (&kf, pJisyo->m_tszPath, pJisyo->m_nCodingSystem))
		return	False ;
	fResult			= skkJisyo_tryCompletionWithFileptr (&kf, pKey, nKey, pvbuf) ;
	KFile_Close (&kf) ;
	return	fResult ;
}

/*
 *	Private Functions
 */

/*
 *	EUC-JP 沽줿桼񤫤Ϳ줿ʸ򥭡
 *	Ѵõؿ
 */
Boolean
skkJisyo_searchWithFileptr (
	register KFILE*			pFile,
	register const Char*	pKey,
	register int			nKey,
	register Boolean		fOkuri,
	register TVarbuffer*	pvbuf)
{
	Char					szBuffer [TEXTBUFSIZE] ;
	register const Char*	ptr ;
	register int			nptr ;
	register Char*			pDest ;
	register int			nDest ;
	register Char			cc ;
	register Boolean		fFound ;

	if (pFile == NULL || pKey == NULL || nKey <= 0 || Char_IsNul (*pKey))
		return	True ;

	KFile_Rewind (pFile) ;
	if (fOkuri){
		KFile_FindsAtBeginningOfLineA (pFile, ";; okuri-ari entries.") ;
	} else {
		KFile_FindsAtBeginningOfLineA (pFile, ";; okuri-nasi entries.") ;
	}
	KFile_Nextline (pFile) ;

	fFound		= False ;
	ptr			= NULL ;
	for ( ; ; ){
		cc		= KFile_Getc (pFile) ;
		if (cc != ';') {
			ptr		= pKey ;
			nptr	= nKey ;
			while (cc != EOF && cc != '\n' && cc != '\r' && nptr > 0) {
				if (cc != *ptr)
					break ;
				cc	= KFile_Getc (pFile) ;
				ptr		++ ;
				nptr	-- ;
			}
			if (nptr == 0) {
				if (cc == ' ') {
					/* ξˤϸʸ󤬥ҥåȤȤˤʤ롣*/
					fFound	= TRUE ;
					break ;
				}
			}
		} else {
			register const char*	aptr ;
			
			/* ⤷ơ겾̾ꥨȥޤƤޤäΤ*/
			aptr	= (fOkuri)? ";; okuri-nasi entries." : ";; okuri-ari entries." ;
			while (*aptr != '\0' && !Char_DifferenceAscii (cc, *aptr)) {
				aptr	++ ;
				cc	= KFile_Getc (pFile) ;
			}
			/* ʾΥȥ򸡺뤳Ȥ̵*/
			if (*aptr == '\0' && cc == '\n')
				cc	= EOF ;
		}
		/* ƬޤɤФ*/
		while (cc != EOF && cc != '\n' && cc != '\r')
			cc	= KFile_Getc (pFile) ;
		/* եκǸƤˤϸ򽪤롣*/
		if (cc == EOF)
			break ;
	}
	/* Ĥʤäˤϲ⤷ʤ*/
	if (TFAILED (fFound))
		return	True ;

	while (cc = KFile_Getc (pFile), cc == ' ')
		;

	/*	ĤʸĹХåեáࡣ*/
	pDest	= szBuffer ;
	nDest	= NELEMENTS (szBuffer) ;
	while (cc != EOF && cc != '\n' && cc != '\r') {
		if (nDest == 0) {
			TVarbuffer_Add (pvbuf, szBuffer, NELEMENTS (szBuffer)) ;
			pDest	= szBuffer ;
			nDest	= NELEMENTS (szBuffer) ;
		}
		*pDest	++	= cc ;
		nDest	-- ;
		cc			= KFile_Getc (pFile) ;
	}
	if (nDest != NELEMENTS (szBuffer))
		TVarbuffer_Add (pvbuf, szBuffer, NELEMENTS (szBuffer) - nDest) ;
	return	True ;
}

Boolean
skkJisyo_tryCompletionWithFileptr (
	register KFILE*			pFile,
	register const Char*	pKey,
	register int			nKey,
	register TVarbuffer*	pvbuf)
{
	register const Char*	ptr ;
	register int			nptr ;
	Char					cc ;
	register Boolean		fFound ;

	if (pFile == NULL || pKey == NULL || nKey <= 0 || Char_IsNul (*pKey))
		return	True ;

	KFile_Rewind (pFile) ;
	KFile_FindsAtBeginningOfLineA (pFile, ";; okuri-nasi entries.") ;
	fFound		= False ;
	for ( ; ; ) {
		/* ΰ֤ǤϹƬƤΤȹͤ롣*/
		ptr			= pKey ;
		nptr		= nKey ;
		cc			= KFile_Getc (pFile) ;
		if (cc != ';'){
			while (cc != EOF && cc != '\n' && cc != '\r' && nptr > 0) {
				if (*ptr != cc)
					break ;
				ptr		++ ;
				nptr	-- ;
				cc	= KFile_Getc (pFile) ;
			}
			if (nptr == 0 && cc != EOF && cc != '\n' && cc != '\r') {
				static const Char	chSLASH	= '/' ;
				if (!fFound){
					TVarbuffer_Add (pvbuf, &chSLASH, 1) ;
					TVarbuffer_Add (pvbuf, pKey, nKey) ;
					fFound		= True ;
				} else {
					TVarbuffer_Add (pvbuf, pKey, nKey) ;
				}
				/* ξˤϸʸ󤬥ҥåȤȤˤʤ롣*/
				while (cc != EOF  && cc != '\n' && cc != '\r' && cc != ' ') {
					TVarbuffer_Add (pvbuf, &cc, 1) ;
					cc	= KFile_Getc (pFile) ;
				}
				TVarbuffer_Add (pvbuf, &chSLASH, 1) ;
			}
		} else {
			register const char*	aptr = ";; okuri-ari entries." ;
			
			/* ⤷ơ겾̾ꥨȥޤƤޤäΤ*/
			while (*aptr != '\0' && !Char_DifferenceAscii (cc, *aptr)) {
				aptr	++ ;
				cc	= KFile_Getc (pFile) ;
			}
			/* ʾΥȥ򸡺뤳Ȥ̵*/
			if (*aptr == '\0' && cc == '\n')
				cc	= EOF ;
		}
		/* ƬޤɤФ*/
		while (cc != EOF && cc != '\n' && cc != '\r')
			cc	= KFile_Getc (pFile) ;
		/* եκǸƤˤϸ򽪤롣*/
		if (cc == EOF)
			break ;
	}
	return	True ;
}

Boolean
skkJisyo_okuriSearchWithFileptr (
	register KFILE*				pFile,
	register const Char* const	pStrKey,
	register const int			nStrKey,
	register TVarbuffer*		pvbuf)
{
	register Char			cc ;
	register int			nCount ;
	register const Char*	ptr ;
	register int			nptr ;

	KFile_Rewind (pFile) ;
	KFile_FindsAtBeginningOfLineA (pFile, ";; okuri-ari entries.") ;
	while (cc = KFile_Getc (pFile), cc != EOF) {
		if (cc != ';') {
			/*	ѴȲޤǰפ뤫Ĵ٤롣*/
			ptr		= pStrKey ;
			nptr	= nStrKey ;
			while (cc == *ptr && cc != ' ' && nptr > 0) {
				cc	= KFile_Getc (pFile) ;
				ptr  ++ ;
				nptr -- ;
			}
			/*	԰פˤʤäƤ(ϿƤζʸ
			 *	ޤǲʸ뤫Ĵ٤롣*/
			nCount	= 0 ;
			while (cc != ' ' && cc != EOF && cc != '\n' && cc != '\r') {
				cc	= KFile_Getc (pFile) ;
				nCount	++ ;
			}
			/*	ʸ1ʸǤ ȤȤϡ``r'' Τ褦
			 *	ʥ ``'' ޤǰפƤ뤳Ȥ̣Ƥ롣*/
			if (nCount == 1 && cc == ' ') {
				if (TFAILED (skkJisyo_okuriSearchCheckCandidate (pFile, ptr, nptr, pvbuf)))
					return	False ;
				continue ;
			}
		} else {
			register const char*	aptr ;

			/* ⤷ơ겾̾ꥨȥޤƤޤäΤ*/
			aptr		= ";; okuri-nasi entries." ;
			while (*aptr != '\0' && !Char_DifferenceAscii (cc, *aptr)) {
				aptr	++ ;
				cc	= KFile_Getc (pFile) ;
			}
			/* ʾΥȥ򸡺뤳Ȥ̵*/
			if (*aptr == '\0' && cc == '\n')
				cc	= EOF ;
		}
		while (cc != EOF && cc != '\n' && cc != '\r')
			cc	= KFile_Getc (pFile) ;
		if (cc == EOF)
			break ;
	}
	return	True ;
}

Boolean
skkJisyo_okuriSearchCheckCandidate (
	register KFILE*				pFile,
	register const Char* const	pTail,
	register const int			nTail,
	register TVarbuffer*		pvbuf)
{
	register Char			cc ;
	register const Char*	ptr ;
	register int			nptr ;

	for ( ; ; ) {
		ptr		= pTail ;
		nptr	= nTail ;
		do {
			cc	= KFile_Getc (pFile) ;
		} while (cc != '[' && cc != EOF && cc != '\n' && cc != '\r') ;
		
		if (cc != '[')
			break ;
		
		/*	``Ӥs /Ƥӽ/ƽ/[/Ƥӽ/ƽ/]/[/Ƥӽ/ƽ/]/''
		 *	Τ褦ʷˤʤäƤΤǡ``['' μʸѴλĤ
		 *	ȴ˰פƤ뤫ɤȽꤹ롣*/
		while (cc = KFile_Getc (pFile), cc != '/' && *ptr == cc && nptr > 0) {
			ptr	 ++ ;
			nptr -- ;
		}
		/*	դäɤ */
		if (cc == '/')
			return	skkJisyo_okuriSearchFound (pFile, ptr, nptr, pvbuf) ;
	}
	/*	⤷ϥեκǸޤɤФɬפ뤬ξ­
	 *	Ƥ롣(break ξ郎)
	 *	while (cc != '[' && cc != EOF && cc != '\n' && cc != '\r')
	 *		cc	= KFile_Getc (pFile) ;
	 */
	return	True ;
}

Boolean
skkJisyo_okuriSearchFound (
	register KFILE*				pFile,
	register const Char* const	pOkuri,
	register const int			nOkuri,
	register TVarbuffer*		pvbuf)
{
	register Char*	pbuf ;
	register int	nbuf ;
	register Char	cc	= '\0' ;
	register int	nUse ;
	Char			achBuf [256] ;

	do {
		pbuf	= achBuf ;
		nbuf	= NELEMENTS (achBuf) ;
		while (nbuf > 0) {
			cc	= KFile_Getc (pFile) ;
			if (cc == '/' || cc == '[' || cc == EOF || cc == '\n' || cc == '\r')
				break ;
			*pbuf ++	= cc ;
			nbuf -- ;
		}
		nUse	= NELEMENTS (achBuf) - nbuf ;
		if (nUse > 0) {
			if (TFAILED (TVarbuffer_Add (pvbuf, achBuf, nUse)) ||
				TFAILED (TVarbuffer_Add (pvbuf, pOkuri, nOkuri)))
				return	False ;
		}
	}	while (cc != '[' && cc != EOF && cc != '\n' && cc != '\r') ;

	while (cc != EOF && cc != '\n' && cc != '\r') 
		cc	= KFile_Getc (pFile) ;
	return	True ;
}

