#include "local.h"
#include <stdio.h>
#include <assert.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "lmachinep.h"
#include "TTerminal.h"
#include "TFrame.h"
#include "cstring.h"
#include "ttext.h"

typedef struct tagTDisplayState {
	void	(*m_pPutsFunc)(struct tagTDisplayState*, Widget, const Char*, int, int) ;
	Widget	m_wgTerminal ;
}	TDisplayState ;

typedef struct tagTLMWindowUpdateArg {
	int					m_nLines, m_nRest, m_nCursor, m_nWidth, m_nGuessChar ;
	TFontSet*			m_pFontSet ;
	XRectangle*			m_pRC ;
	TBufStringMarker*	m_pMkBuffer ;
	Boolean				m_fVariable, m_fHaveFocus ;
}	TLMWindowUpdateArg ;

static	Boolean	lispMachine_updateWindowBuffer	(TLispMachine*, TLispEntity*, TLispEntity*) ;
static	Boolean	lispMachine_updateWindowMessage	(TLispMachine*, TLispEntity*, TLispEntity*) ;
static	Boolean	lispMachine_updateWindowModeline	(TLispMachine*, TLispEntity*, Widget, TFontSet*, int, TLispEntity*) ;
static	Boolean	lispMachine_createLongWindowModelineString	(TVarbuffer*, TLispMachine*, TLispEntity*, TFontSet*, int, TLispEntity*) ;
static	Boolean	lispMachine_createShortWindowModelineString	(TVarbuffer*, TLispMachine*, TLispEntity*, TFontSet*, int, TLispEntity*) ;
static	Boolean	lispMachine_addStringToWindowModeline	(TVarbuffer*, TFontSet*, int, const Char*, int) ;
static	void	lispMachine_windowPutchar1	(TDisplayState*, Widget, const Char*, int, int) ;
static	void	lispMachine_windowPutchar2	(TDisplayState*, Widget, const Char*, int, int) ;
static	Boolean	lispMachine_windowHaveModelinep	(TLispMachine*, TLispEntity*, TLispEntity**) ;


static inline	void
lispMachine_updateWindowBufferWithFrame (
	register Widget					wgTerminal,
	register TLMWindowUpdateArg*	pArg)
{
	register int				nLines, nRest, nUsage, nCheck, nCursor ;
	register int				nWidth, nCount, nPoint, nGuessChar ;
	register Boolean			fHaveFocus, fVariable ;
	register Char*				pDest ; 
	register Char*				pTop ; 
	static const Char			chSPC	= 0x20 ;
	register TFontSet*			pFontSet ;
	register TBufStringMarker*	pMkBuffer ;
	TDisplayState				state ;
	TSize						sz, szSPC ;
	Char						cc ;
	TVarbuffer					vbufText ;
	register XRectangle*		pRC ;

	if (TFAILED (TVarbuffer_Initialize (&vbufText, sizeof (Char))))
		return ;

	nLines		= pArg->m_nLines ;
	nRest		= pArg->m_nRest ;
	fVariable	= pArg->m_fVariable ;
	nGuessChar	= pArg->m_nGuessChar ;
	pMkBuffer	= pArg->m_pMkBuffer ;
	pRC			= pArg->m_pRC ;
	pFontSet	= pArg->m_pFontSet ;
	fHaveFocus	= pArg->m_fHaveFocus ;
	nCursor		= pArg->m_nCursor ;
	nWidth		= pArg->m_nWidth ;

	if (TSUCCEEDED (fHaveFocus)) {
		state.m_pPutsFunc	= &lispMachine_windowPutchar1 ;
	} else {
		state.m_pPutsFunc	= &lispMachine_windowPutchar2 ;
	}
#if defined (DEBUG) || 0
	fprintf (stderr, "Cursor(%d), Rest(%d), Width(%d)\n",
			 nCursor, nRest, nWidth) ;
#endif
	TGetTextExtents (pFontSet, &chSPC, 1, &szSPC) ;

	/*	˼ȴ֤ΤȤäƤ٤襨󥸥
	 */
	while ((fVariable || nLines > 0) && nRest > 0) {
		/*
		 *	԰֤ޤϥХåեκǸޤã顢break 롣
		 *	ХåեκǸޤǲԤʤä顢ˤ
		 *	õˤʤΤǤޤ
		 */
		nCheck	= (nRest < nGuessChar)? nRest : nGuessChar ;
		nCount	= nCheck ;
		if (TFAILED (TVarbuffer_Require (&vbufText, nCheck)))
			goto	skip ;
		pDest	= TVarbuffer_GetBuffer (&vbufText) ;
		nUsage	= 0 ;
		while (nCount > 0) {
			cc	= TBufStringMarker_GetChar (pMkBuffer) ;
#if defined (DEBUG) || 0
			fprintf (stderr, "[0x%04lx](%d), ", cc, nCount) ;
#endif
			TBufStringMarker_Forward (pMkBuffer, 1) ;
			nCount	-- ;
			if (cc == '\n')
				break ;
			*pDest ++	= cc ;
			nUsage	++ ;
		}
#if defined (DEBUG) || 0
		fprintf (stderr, "\n") ;
#endif
		/*
		 *	ºݤˤɤ٤(pixelñ)ȤäƤޤäΤ򤳤
		 *	롣
		 */
		TGetTextExtents (pFontSet, TVarbuffer_GetBuffer (&vbufText), nUsage, &sz) ;

		/*
		 *	ԤƤޤν
		 */
		if (nWidth < (sz.cx + szSPC.cx)) {
			register int			nMin, nMax, nPoint ;
			/*
			 *	1ԤƤޤΤ2ʬõ롣õ
			 *	ޥȻפäġ
			 */
			nMin	= 0 ;
			nMax	= nUsage - 1 ;
			pTop	= TVarbuffer_GetBuffer (&vbufText) ;

			while (nPoint = (nMin + nMax) / 2, nMin < nMax) {
				TGetTextExtents (pFontSet, pTop, nPoint, &sz) ;
				if ((sz.cx + szSPC.cx) < nWidth) {
					TGetTextExtents (pFontSet, pTop, nPoint + 1, &sz) ;
					if ((sz.cx + szSPC.cx) >= nWidth)
						break ;
					nMin	= nPoint + 1 ;
				} else {
					nMax	= nPoint - 1 ;
				}
			}
			/*	ޤ֤backslashɽ뤿 1 ĸ餹Τ
			 *	1ʸʸɽǤʤΤϤޤ*/
			if (nPoint < 1) 
				nPoint	= 1 ;
			(state.m_pPutsFunc)(&state, wgTerminal, pTop, nPoint, nCursor) ;
#if defined (DEBUG) || 0
			fprintf (stderr, "nRest(%d), nCheck(%d), nCount(%d), nCursor(%d), nUsage(%d), nPoint(%d)\n",
					 nRest, nCheck, nCount, nCursor, nUsage, nPoint) ;
#endif
			/*	դƤʬ᤹*/
			TBufStringMarker_Backward (pMkBuffer, ((nCheck - nCount) - nPoint)) ;
#if defined (DEBUG) || 0
			fprintf (stderr, "nRest(%d) -= nPoint(%d)\n", nRest, nPoint) ;
#endif
			nRest	-= nPoint ;
			nCursor	-= nPoint ;
			TFrame_Putchar (wgTerminal, '\\') ;
			TFrame_Putchar (wgTerminal, '\\') ;
			TFrame_Putchar (wgTerminal, '\n') ;
			nWidth	= pRC->width ;
			nLines	-- ;
		} else {
			register int	nForward	= nCheck - nCount ;
#if defined (DEBUG) || 0
			fprintf (stderr, "nRest(%d), nCheck(%d), nCount(%d), nCursor(%d), nUsage(%d)\n",
					 nRest, nCheck, nCount, nCursor, nUsage) ;
#endif
			pTop	= TVarbuffer_GetBuffer (&vbufText) ;
			nPoint	= nUsage ;
#if defined (DEBUG) || 0
			fprintf (stderr, "nRest(%d) -= (nCheck(%d) - nCount(%d))(%d)\n",
					 nRest, nCheck, nCount, nForward) ;
#endif
			nRest	-= nForward ;
			if (nPoint > 0) {
				(state.m_pPutsFunc)(&state, wgTerminal, pTop, nPoint, nCursor) ;
				nWidth	-= sz.cx ;
			}

			/*
			 *	ٲԤΰ֤˥뤬Ƥ꤬ȯ롣
			 */
			if (nCursor == nPoint && fHaveFocus) {
				if (szSPC.cx >= nWidth) {
					TFrame_Putchar (wgTerminal, '\\') ;
					TFrame_Putchar (wgTerminal, '\n') ;
					nWidth	= pRC->width ;
					nLines	-- ;
					if (!fVariable && nLines <= 0) {
						nCursor	= 0 ;
						break ;
					}
				}
				TFrame_Rev      (wgTerminal, True) ;
				TFrame_SetCaret (wgTerminal) ;
				TFrame_Putchar  (wgTerminal, chSPC) ;
				TFrame_Rev      (wgTerminal, False) ;
				nWidth	-= szSPC.cx ;
				nCursor	-- ;
			}
			if (nForward > nPoint) {
				TFrame_Putchar (wgTerminal, '\n') ;
				nWidth	= pRC->width ;
				nLines	-- ;
			}
			nCursor	-= nForward ;
		}
		TVarbuffer_Clear (&vbufText) ;
	}
#if defined (DEBUG) || 0
	fprintf (stderr, "fVariable(%d), nLines(%d), nCursor(%d), fHaveFocus(%d)\n",
			 fVariable, nLines, nCursor, fHaveFocus) ;
#endif
	if ((fVariable || nLines > 0) && nCursor == 0 && fHaveFocus) {
#if defined (DEBUG) || 0
		fprintf (stderr, "nWidth(%d), SPC.cx(%d)\n",
				 nWidth, szSPC.cx) ;
#endif
		if (szSPC.cx >= nWidth) {
			TFrame_Putchar (wgTerminal, '\\') ;
			TFrame_Putchar (wgTerminal, '\n') ;
			nLines	-- ;
			if (!fVariable && nLines <= 0) 
				goto	skip ;
		}
		TFrame_Rev      (wgTerminal, True) ;
		TFrame_SetCaret (wgTerminal) ;
		TFrame_Putchar  (wgTerminal, chSPC) ;
		TFrame_Rev      (wgTerminal, False) ;
	}
  skip:
	pArg->m_nLines	= nLines ;
	pArg->m_nRest	= nRest ;
	pArg->m_nCursor	= nCursor ;

	TVarbuffer_Uninitialize (&vbufText) ;
	return ;
}

static inline	void
lispMachine_updateWindowBufferWithoutFrame (
	register Widget					wgTerminal,
	register TLMWindowUpdateArg*	pArg)
{
	register int				nRest, nCursor, nCount, nPoint ;
	register Char*				pDest ; 
	register TBufStringMarker*	pMkBuffer ;
	Char						rbufText [256] ;

	nRest		= pArg->m_nRest ;
	pMkBuffer	= pArg->m_pMkBuffer ;
	nCursor		= pArg->m_nCursor ;

	/*	˼ȴ֤ΤȤäƤ٤襨󥸥
	 */
	assert (nRest >= nCursor) ;
	while (nRest > 0 && nCursor > 0) {
		nCount	= (nCursor > NELEMENTS(rbufText))? NELEMENTS(rbufText) : nCursor  ;
		nPoint	= nCount ;
		pDest	= rbufText ;
		while (nCount -- > 0) {
			*pDest ++	= TBufStringMarker_GetChar (pMkBuffer) ;
			TBufStringMarker_Forward (pMkBuffer, 1) ;
		}
		TFrame_Puts (wgTerminal, rbufText, nPoint) ;
		nCursor	-= nPoint ;
		nRest	-= nPoint ;
	}
	assert (nCursor == 0) ;
	TFrame_SetCaret (wgTerminal) ;

	while (nRest > 0) {
		nCount	= (nRest > NELEMENTS(rbufText))? NELEMENTS(rbufText) : nRest ;
		nPoint	= nCount ;
		pDest	= rbufText ;
		while (nCount -- > 0) {
			*pDest ++	= TBufStringMarker_GetChar (pMkBuffer) ;
			TBufStringMarker_Forward (pMkBuffer, 1) ;
		}
		TFrame_Puts (wgTerminal, rbufText, nPoint) ;
		nCursor	-= nPoint ;
		nRest	-= nPoint ;
	}
	pArg->m_nRest	= nRest ;
	pArg->m_nCursor	= nCursor ;
	return ;
}

Boolean
lispMachine_UpdateWindow (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntFrame,
	register TLispEntity*	pEntWindow)
{
	register TLispManager*		pLispMgr	= pLM->m_pLispMgr ;
	register Boolean			fRetval ;
	TLispEntity*	pEntMessage ;

	if (TSUCCEEDED (lispWindow_GetMessage (pEntWindow, &pEntMessage)) &&
		TFAILED (lispEntity_Nullp (pLispMgr, pEntMessage))) {
		fRetval	= lispMachine_updateWindowMessage (pLM, pEntFrame, pEntWindow) ;
	} else {
		fRetval	= lispMachine_updateWindowBuffer (pLM, pEntFrame, pEntWindow) ;
	}
	lispWindow_Sync (pLispMgr, pEntWindow) ;
	return	fRetval ;
}

/*
 */
Boolean
lispMachine_updateWindowBuffer (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntFrame,
	register TLispEntity*	pEntWindow)
{
	register TLispManager*		pLispMgr	= pLM->m_pLispMgr ;
	Widget						wgTerminal ;
	TLispEntity*				pMkView ;
	TLispEntity*				pEntBuffer ;
	TLispEntity*				pEntModeline ;
	int							nPoint, nPointMax, nPointMin, nLength, nCursor ;
	register TFontSet*			pFontSet ;
	register int				nWidth, nRest ;
	TBufStringMarker			mkBuffer ;
	register Boolean			fHaveFocus, fHaveModeline, fVariable, fNoFrame ;
	XRectangle					rc ;
	TLMWindowUpdateArg			arg ;

	/*	Terminal 롣ȤϤɤΤ */
	if (TFAILED (lispFrame_GetTerminal (pEntFrame, &wgTerminal)))
		return	False ;

	fVariable		= TFrame_RectVariablep (wgTerminal) ;
	
	/*	ХåեϤƤʸɽ롣*/
	(void) lispWindow_GetViewMarker (pEntWindow, &pMkView) ;
	lispMarker_GetBufferPosition (pLispMgr, pMkView, &pEntBuffer, &nPoint) ;
	assert (pEntBuffer != NULL && nPoint >= 1) ;
	
	lispBuffer_GetFullString (pLispMgr, pEntBuffer, &mkBuffer, &nLength) ;
	/*lispBuffer_PointMin  (pLispMgr, pEntBuffer, &nPointMin) ;*/
	nPointMin	= 1 ;
	lispBuffer_PointMax  (pLispMgr, pEntBuffer, &nPointMax) ;

	nPointMax		-= nPointMin ;
	nPoint			-= nPointMin ;
	if (nPoint < 0)
		nPoint		= 0 ;
	if (nPoint > nLength)
		nPoint		= nLength ;
	lispBuffer_Point (pLispMgr, pEntBuffer, &nCursor) ;
	nCursor			-= nPointMin ;
	
	fHaveFocus	= lispWindow_HaveFocusp (pEntWindow) ;

	/*	Ԥ˺粿ʸޤ뤫Ŭʿ̡*/
	if (!fVariable) {
		lispWindow_GetArea (pEntWindow, &rc) ;
		nWidth		= rc.width ;
		fNoFrame	= False ;
	} else {
		if (TFrame_GetRect (wgTerminal, &rc) <= 0) {
			nWidth		= 0 ;
			fNoFrame	= True ;
		} else {
			nWidth		= rc.width - rc.x ;
			fNoFrame	= False ;
		}
	}

	fHaveModeline	= lispMachine_windowHaveModelinep (pLM, pEntBuffer, &pEntModeline) ;
	nRest			= nPointMax - nPoint ;

	if (TFAILED (fNoFrame)) {
		int					nFontHeight ;
		register Boolean	fExternModeline ;
		register int		nGuessChar, nLines ;

		/*	ɽΰ褬¸ߤʤΤꡣ*/
		if (rc.width <= 0 || rc.height <= 0)
			return	False ;

#if defined (DEBUG) || 0
		fprintf (stderr, "Frame (%d, %d, %d, %d)\n",
				 rc.x, rc.y, rc.width, rc.height) ;
#endif
		pFontSet		= TFrame_GetFontSet    (wgTerminal) ;
		TFrame_GetLineSpacing (wgTerminal, &nFontHeight) ;

		nGuessChar	= rc.width / nFontHeight ;
		if (nGuessChar <= 0)
			nGuessChar	= 40 ;	/* Ŭʿ͡*/

		/*	Terminal  put 롣*/
		nLines			= rc.height / nFontHeight ;
		fExternModeline	= TFrame_HaveExternModeline (wgTerminal) ;
		if (!fExternModeline && fHaveModeline)
			nLines	-- ;

		if (!fVariable || nRest > 0) {
			arg.m_nLines		= nLines ;
			arg.m_nRest			= nRest ;
			arg.m_fVariable		= fVariable ;
			arg.m_nGuessChar	= nGuessChar ;
			arg.m_pMkBuffer		= &mkBuffer ;
			arg.m_pRC			= &rc ;
			arg.m_pFontSet		= pFontSet ;
			arg.m_fHaveFocus	= fHaveFocus ;
			arg.m_nCursor		= nCursor ;
			arg.m_nWidth		= nWidth ;
			lispMachine_updateWindowBufferWithFrame (wgTerminal, &arg) ;
			nLines				= arg.m_nLines ;
		}
		if (!fVariable) 
			while (nLines -- > 0) 
				TFrame_Putchar (wgTerminal, '\n') ;
	} else {
		/*	OnTheSpot Ѥ Frame ̵⡼ɤǤ衣*/
		arg.m_pMkBuffer		= &mkBuffer ;
		arg.m_nRest			= nRest ;
		arg.m_nCursor		= nCursor ;
		lispMachine_updateWindowBufferWithoutFrame (wgTerminal, &arg) ;

		pFontSet			= 0 ;
		rc.width			= 0 ;
	}
	if (fHaveModeline)
		lispMachine_updateWindowModeline (pLM, pEntBuffer, wgTerminal, pFontSet, rc.width, pEntModeline) ;
	return	True ;
}

Boolean
lispMachine_updateWindowMessage (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntFrame,
	register TLispEntity*	pEntWindow)
{
	register TLispManager*		pLispMgr	= pLM->m_pLispMgr ;
	TDisplayState				state ;
	Widget						wgTerminal ;
	TLispEntity*				pEntMessage ;
	TLispEntity*				pEntBuffer ;
	TLispEntity*				pEntModeline ;
	XRectangle					rc ;
	register Boolean			fHaveModeline, fHaveFocus, fVariable, fExternModeline ;
	int							nPoint, nPointMax, nLength, nCursor ;
	register TFontSet*			pFontSet ;
	int							nFontHeight ;
	const Char*					pBufString ;
	register const Char*		ptr ;
	register const Char*		pBasePtr ;
	register int				nGuessChar, nLines, nWidth, nRest ;
	register int				nCheck, nCount ;
	TSize			sz ;
	const Char		chSPC	= 0x20 ;

	/*	Terminal 롣ȤϤɤΤ */
	if (TFAILED (lispFrame_GetTerminal (pEntFrame, &wgTerminal)))
		return	False ;

	fVariable		= TFrame_RectVariablep (wgTerminal) ;
	fExternModeline	= TFrame_HaveExternModeline (wgTerminal) ;
	pFontSet		= TFrame_GetFontSet  (wgTerminal) ;
	TFrame_GetLineSpacing (wgTerminal, &nFontHeight) ;

	/*	Window κɽʸƬõ*/
	if (TFAILED (lispWindow_GetMessage (pEntWindow, &pEntMessage)) ||
		TFAILED (lispEntity_GetStringValue (pLispMgr, pEntMessage, &pBufString, &nLength)) ||
		TFAILED (lispWindow_GetBuffer (pEntWindow, &pEntBuffer)))
		return	False ;

	/*	å¸ߤƤ硣*/
	nCursor				= 0 ;
	nPoint				= 0 ;
	nPointMax			= nLength ;
	state.m_pPutsFunc	= &lispMachine_windowPutchar2 ;
	fHaveFocus			= lispWindow_HaveFocusp (pEntWindow) ;

	if (!fVariable) {
		lispWindow_GetArea (pEntWindow, &rc) ;
		nWidth		= rc.width ;
	} else {
		/*	Frame ˿Ҥľʤȥ*/
		TFrame_GetRect (wgTerminal, &rc) ;
		nWidth		= rc.width - rc.x ;
	}
	/*	ɽΰ褬¸ߤʤΤꡣ*/
	if (rc.width <= 0 || rc.height <= 0)
		return	True ;

	nGuessChar		= rc.width / nFontHeight ;
	nRest			= nPointMax - nPoint ;
	nLines			= rc.height / nFontHeight ;
	fHaveModeline	= lispMachine_windowHaveModelinep (pLM, pEntBuffer, &pEntModeline) ;
	if (!fExternModeline && fHaveModeline)
		nLines	-- ;
	ptr			= pBufString + nPoint ;

	while ((fVariable || nLines > 0) && nRest > 0) {
		pBasePtr	= ptr ;
		/*
		 *	԰֤ޤϥХåեκǸޤã顢break 롣
		 *	ХåեκǸޤǲԤʤä顢ˤ
		 *	õˤʤΤǤޤ
		 */
		nCheck	= (nRest < nGuessChar)? nRest : nGuessChar ;
		nCount	= nCheck ;
		while (nCount > 0 && *ptr != '\n') {
			ptr	   ++ ;
			nCount -- ;
		}
		/*
		 *	ºݤˤɤ٤(pixelñ)ȤäƤޤäΤ򤳤
		 *	롣
		 */
		TGetTextExtents (pFontSet, pBasePtr, ptr - pBasePtr, &sz) ;
		/*
		 *	ԤƤޤν
		 */
		if (nWidth <= sz.cx) {
			int		nMin, nMax, nPoint ;
			/*
			 *	1ԤƤޤΤ2ʬõ롣õ
			 *	ޥȻפäġ
			 */
			nMin	= 0 ;
			nMax	= ptr - pBasePtr - 1 ;
			while (nPoint = (nMin + nMax) / 2, nMin < nMax) {
				TGetTextExtents (pFontSet, pBasePtr, nPoint, &sz) ;
				if (sz.cx < nWidth) {
					TGetTextExtents (pFontSet, pBasePtr, nPoint + 1, &sz) ;
					if (sz.cx >= nWidth)
						break ;
					nMin	= nPoint + 1 ;
				} else {
					nMax	= nPoint - 1 ;
				}
			}
			(state.m_pPutsFunc)(&state, wgTerminal, pBasePtr, nPoint, nCursor) ;
			ptr		=  pBasePtr + nPoint ;
			nRest	-= nPoint ;
			nCursor	-= nPoint ;
			TFrame_Putchar (wgTerminal, '\\') ;
			TFrame_Putchar (wgTerminal, '\n') ;
			nWidth	= rc.width ;
			nLines	-- ;
		} else {
			ptr		= pBasePtr ;
			nPoint	= (nCheck - nCount) ;
			nRest	-= nPoint ;
			if (nCount > 0) {
				(state.m_pPutsFunc)(&state, wgTerminal, pBasePtr, nPoint, nCursor) ;
				nCursor		-= nPoint ;
				ptr			= pBasePtr + nPoint ;
				/*
				 *	ٲԤΰ֤˥뤬Ƥ꤬ȯ롣
				 */
				if (nCursor == 0 && fHaveFocus) {
					TGetTextExtents (pFontSet, &chSPC, 1, &sz) ;
					if (sz.cx >= nWidth) {
						TFrame_Putchar (wgTerminal, '\\') ;
						TFrame_Putchar (wgTerminal, '\n') ;
						nLines	-- ;
						if (!fVariable && nLines <= 0) 
							break ;
					}
					TFrame_Rev      (wgTerminal, True) ;
					TFrame_SetCaret (wgTerminal) ;
					TFrame_Putchar  (wgTerminal, chSPC) ;
					TFrame_Rev      (wgTerminal, False) ;
				}
				/*	*ptr == '\n' */
				TFrame_Putchar (wgTerminal, *ptr ++) ;
				nCursor	-- ;
				nWidth	= rc.width ;
				nLines	-- ;
			} else {
				(state.m_pPutsFunc)(&state, wgTerminal, pBasePtr, nPoint, nCursor) ;
				ptr			= pBasePtr + nPoint ;
				nCursor		-= nPoint ;
				nWidth		-= sz.cx ;
			}
		}
	}
	if ((fVariable || nLines > 0) && nCursor == 0 && fHaveFocus) {
		TGetTextExtents (pFontSet, &chSPC, 1, &sz) ;
		if (sz.cx >= nWidth) {
			TFrame_Putchar (wgTerminal, '\\') ;
			TFrame_Putchar (wgTerminal, '\n') ;
			nLines	-- ;
			if (nLines <= 0) 
				goto	skip ;
		}
		TFrame_Rev      (wgTerminal, True) ;
		TFrame_SetCaret (wgTerminal) ;
		TFrame_Putchar  (wgTerminal, chSPC) ;
		TFrame_Rev      (wgTerminal, False) ;
	}
 skip:
	if (!fVariable)
		while (nLines -- > 0) 
			TFrame_Putchar (wgTerminal, '\n') ;
	/*	modline  update Ȧĺά*/
	if (fHaveModeline)
		lispMachine_updateWindowModeline (pLM, pEntBuffer, wgTerminal, pFontSet, rc.width, pEntModeline) ;
	return	True ;
}

void
lispMachine_windowPutchar1 (
	register TDisplayState*	pState,
	register Widget			wgTerminal,
	register const Char*	ptr,
	register int			nPoint, 
	register int			nCursor)
{
	if (0 <= nCursor && nCursor < nPoint) {
		TFrame_Puts     (wgTerminal, ptr, nCursor) ;
		TFrame_Rev      (wgTerminal, True) ;
		TFrame_SetCaret (wgTerminal) ;
		TFrame_Puts     (wgTerminal, ptr + nCursor, 1) ;
		TFrame_Rev      (wgTerminal, False) ;
		TFrame_Puts     (wgTerminal, ptr + nCursor + 1, nPoint - nCursor - 1) ;
		pState->m_pPutsFunc	= &lispMachine_windowPutchar2 ;
	} else {
		TFrame_Puts (wgTerminal, ptr, nPoint) ;
	}
	return ;
}

void
lispMachine_windowPutchar2 (
	register TDisplayState*	pState,
	register Widget			wgTerminal,
	register const Char*	ptr,
	register int			nPoint,
	register int			nCursor)
{
	TFrame_Puts (wgTerminal, ptr, nPoint) ;
	return ;
}

Boolean
lispMachine_windowHaveModelinep (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntBuffer,
	register TLispEntity**	ppEntModelineFormat)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntTarget ;
	TLispEntity*			pEntRetval ;
	register Boolean			fRetval ;

	pEntTarget	= lispMgr_GetReservedEntity (pLispMgr, LISPMGR_INDEX_MODE_LINE_FORMAT) ;
	fRetval		= lispMachine_GetSymbolValue (pLM, pEntBuffer, pEntTarget, &pEntRetval) ;
	if (TFAILED (fRetval) || TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntRetval)))
		return	False ;
	*ppEntModelineFormat	= pEntRetval ;
	return	True ;
}

Boolean
lispMachine_updateWindowModeline (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntBuffer,
	register Widget			wgTerminal,
	register TFontSet*		pFontSet,
	register int			nWidth,
	register TLispEntity*	pEntModeline)
{
	register Boolean		fRetval		= False ;
	static const Char		chSPC		= ' ' ;
	register const Char*	pString ;
	register int			nString ;
	TVarbuffer				vbufModeline ;
	TSize					sz ;

	/*	ǤĹХåեɬפˤʤΤɤʡ
	 */
	if (TFAILED (TVarbuffer_Initialize (&vbufModeline, sizeof (Char))))
		return	False ;

	if (TFrame_HaveExternModeline (wgTerminal)) {
		if (TFAILED (lispMachine_createShortWindowModelineString (&vbufModeline, pLM, pEntBuffer, pFontSet, nWidth, pEntModeline)))
			goto	error ;
		pString	= TVarbuffer_GetBuffer (&vbufModeline) ;
		nString	= TVarbuffer_GetUsage  (&vbufModeline) ;
		TFrame_SetModeline (wgTerminal, pString, nString) ;
	} else {
		if (TFAILED (lispMachine_createLongWindowModelineString (&vbufModeline, pLM, pEntBuffer, pFontSet, nWidth, pEntModeline)))
			goto	error ;

		pString	= TVarbuffer_GetBuffer (&vbufModeline) ;
		nString	= TVarbuffer_GetUsage  (&vbufModeline) ;
		TGetTextExtents (pFontSet, pString, nString, &sz) ;
		if (sz.cx < nWidth) {
			nWidth	-= sz.cx ;
			TGetTextExtents (pFontSet, &chSPC, 1, &sz) ;
			while (nWidth > 0) {
				if (TFAILED (TVarbuffer_Add (&vbufModeline, &chSPC, 1)))
					goto	error ;
				nWidth	-= sz.cx ;
			}
		}
		pString	= TVarbuffer_GetBuffer (&vbufModeline) ;
		nString	= TVarbuffer_GetUsage  (&vbufModeline) ;
		TFrame_Rev     (wgTerminal, True) ;
		TFrame_Puts    (wgTerminal, pString, nString) ;
		TFrame_Rev     (wgTerminal, False) ;
		TFrame_Putchar (wgTerminal, '\n') ;
	}
	fRetval	= True ;

  error:
	TVarbuffer_Uninitialize (&vbufModeline) ;
	return	fRetval ;
}

Boolean
lispMachine_createLongWindowModelineString (
	register TVarbuffer*	pvbufModeline,
	register TLispMachine*	pLM,
	register TLispEntity*	pEntBuffer,
	register TFontSet*		pFontSet,
	register int			nWidth,
	register TLispEntity*	pEntModeline)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*			pEntCar ;
	TLispEntity*			pEntCdr ;
	const Char*				pString ;
	int						nString ;
	int						nType ;

	while (TFAILED (lispEntity_Nullp (pLispMgr, pEntModeline))) {
		if (TFAILED (lispEntity_GetCar (pLispMgr, pEntModeline, &pEntCar)) ||
			TFAILED (lispEntity_GetCdr (pLispMgr, pEntModeline, &pEntCdr)))
			return	False ;
		(void) lispEntity_GetType (pLispMgr, pEntCar, &nType) ;
		switch (nType) {
		case	LISPENTITY_SYMBOL:
			if (TFAILED (lispMachine_GetSymbolValue (pLM, pEntBuffer, pEntCar, &pEntCar)) ||
				TFAILED (lispEntity_GetStringValue (pLispMgr, pEntCar, &pString, &nString)))
				break ;
			/*	% βϤʤ*/
			if (TFAILED (TVarbuffer_Add (pvbufModeline, pString, nString)))
				return	False ;
			break ;
				
		case	LISPENTITY_STRING:
			(void) lispEntity_GetStringValue (pLispMgr, pEntCar, &pString, &nString) ;
			if (TFAILED (lispMachine_addStringToWindowModeline (pvbufModeline, pFontSet, nWidth, pString, nString)))
				return	False ;
			break ;
		default:
			break ;
		}
		pEntModeline	= pEntCdr ;
	}
	return	True ;
}
	
Boolean
lispMachine_createShortWindowModelineString (
	register TVarbuffer*	pvbufModeline,
	register TLispMachine*	pLM,
	register TLispEntity*	pEntBuffer,
	register TFontSet*		pFontSet,
	register int			nWidth,
	register TLispEntity*	pEntModeline)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	TLispEntity*			pEntCar ;
	TLispEntity*			pEntCdr ;
	register TLispEntity*	pEntTarget ;
	TLispEntity*			pEntValue ;
	const Char*				pString ;
	int						nString ;
	int						nType ;

	/*	Empty modeline */
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntModeline)))
		return	True ;
	if (TFAILED (lispEntity_GetCar (pLispMgr, pEntModeline, &pEntCar)) ||
		TFAILED (lispEntity_GetCdr (pLispMgr, pEntModeline, &pEntCdr)))
		return	False ;
	if (TSUCCEEDED (lispEntity_Nullp (pLispMgr, pEntCdr))) {
		pEntTarget	= pEntCar ;
	} else {
		lispEntity_GetCar (pLispMgr, pEntCdr, &pEntCar) ;
		pEntTarget	= pEntCar ;
	}
	(void) lispEntity_GetType (pLispMgr, pEntTarget, &nType) ;
	switch (nType) {
	case	LISPENTITY_SYMBOL:
		if (TFAILED (lispMachine_GetSymbolValue (pLM, pEntBuffer, pEntTarget, &pEntValue)) ||
			TFAILED (lispEntity_GetStringValue (pLispMgr, pEntValue, &pString, &nString)))
			break ;
		/*	% βϤʤ*/
		if (TFAILED (TVarbuffer_Add (pvbufModeline, pString, nString)))
			return	False ;
		break ;
		
	case	LISPENTITY_STRING:
		(void) lispEntity_GetStringValue (pLispMgr, pEntTarget, &pString, &nString) ;
		if (TFAILED (lispMachine_addStringToWindowModeline (pvbufModeline, pFontSet, nWidth, pString, nString)))
			return	False ;
		break ;
	default:
		break ;
	}
	return	True ;
}
	
Boolean
lispMachine_addStringToWindowModeline (
	register TVarbuffer*	pvbufModeline,
	register TFontSet*		pFontSet,
	register int			nWidth,
	register const Char*	pStrModeline,
	register int			nStrModeline)
{	
	register int		nDiff, nCurWidth ;
	static const Char	chMINUS	= '-' ;
	TSize				sz ;

	while (nStrModeline > 0) {
		/*	ߤλѥƥ򸫤롣*/
		TGetTextExtents (pFontSet, TVarbuffer_GetBuffer (pvbufModeline), TVarbuffer_GetUsage (pvbufModeline), &sz) ;
		nCurWidth	= sz.cx ;
		if (nCurWidth >= nWidth)
			return	False ;

		if (*pStrModeline == '%') {
			pStrModeline	++ ;
			nStrModeline	-- ;
			if (nStrModeline <= 0)
				break ;
			switch (*pStrModeline) {
			case	'-':
				TGetTextExtents (pFontSet, &chMINUS, 1, &sz) ;	/* '-' ǽʤ*/
				nDiff	= nWidth - nCurWidth ;
				while (nDiff > 0) {
					if (TFAILED (TVarbuffer_Add (pvbufModeline, pStrModeline, 1)))
						return	False ;
					nDiff	-= sz.cx ;
				}
				return	True ;	/* ʾɽ̵̣*/

			case	'%':		/* '%' ɽ*/
				if (TFAILED (TVarbuffer_Add (pvbufModeline, pStrModeline, 1)))
					return	False ;
				break ;

			default:
				/*	ʸ̵뤹롣*/
				break ;
			}
			pStrModeline	++ ;
			nStrModeline	-- ;
		} else {
			register const Char*	pBase ;
			pBase	= pStrModeline ;
			while (*pStrModeline != '%' && nStrModeline > 0) {
				pStrModeline	++ ;
				nStrModeline	-- ;
			}
			if (TFAILED (TVarbuffer_Add (pvbufModeline, pBase, pStrModeline - pBase)))
				return	False ;
		}
	}
	return	True ;
}

