#if !defined (lmsymbol_h)
#define	lmsymbol_h

/*	Prototype */
Boolean	lispMachine_MakeLocalSymbolValue			(TLispMachine* pLM, TLispEntity* pSymbol, TLispBind** ppBindReturn) ;
Boolean	lispMachine_MakeLocalSymbolValueWithName	(TLispMachine* pLM, const Char* pName, const int nName, TLispBind** ppBindReturn) ;

/*	Function Prototype for "Setter" */
#define	SETPROTO(symbol)	Boolean symbol (TLispMachine*, TLispEntity*, TLispEntity*)
#define	SETPROTON(symbol)	Boolean symbol (TLispMachine*, const Char*, int, TLispEntity*)

SETPROTO(lispMachine_SetCurrentSymbolValue) ;
SETPROTO(lispMachine_SetCurrentBufferLocalSymbolValue) ;
SETPROTO(lispMachine_SetGlobalSymbolValue) ;

SETPROTON(lispMachine_SetCurrentSymbolValueWithName) ;
SETPROTON(lispMachine_SetCurrentBufferLocalSymbolValueWithName) ;
SETPROTON(lispMachine_SetGlobalSymbolValueWithName) ;

/*	Function Prototype for "Getter" */
#define	GETPROTO(symbol)	Boolean symbol (TLispMachine*, TLispEntity*, TLispEntity** const )
#define	GETPROTON(symbol)	Boolean symbol (TLispMachine*, const Char*, int, TLispEntity** const)

GETPROTO(lispMachine_GetCurrentSymbolValue) ;
GETPROTO(lispMachine_GetGlobalSymbolValue) ;
GETPROTO(lispMachine_GetCurrentBufferLocalSymbolValue) ;

GETPROTON(lispMachine_GetCurrentSymbolValueWithName) ;
GETPROTON(lispMachine_GetGlobalSymbolValueWithName) ;
GETPROTON(lispMachine_GetCurrentBufferLocalSymbolValueWithName) ;

/*	Function Prototype for Function Value "Setter/Getter" */
SETPROTO(lispMachine_SetSymbolFunctionValue) ;
GETPROTO(lispMachine_GetSymbolFunctionValue) ;

/*	Property "Setter/Getter" */
SETPROTO(lispMachine_SetSymbolProperty) ;
GETPROTO(lispMachine_GetSymbolProperty) ;

#define	GETPROTOE(symbol)	Boolean symbol (TLispMachine*, TLispEntity*, TLispEntity*, TLispEntity** const )
GETPROTOE(lispMachine_GetSymbolValue) ;
GETPROTOE(lispMachine_GetBufferLocalSymbolValue) ;

#undef	SETPROTO
#undef	SETPROTON
#undef	GETPROTO
#undef	GETPROTON

Boolean	lispMachine_GetBufferLocalSymbolValue (TLispMachine*, TLispEntity*, TLispEntity*, TLispEntity** const) ;
Boolean	lispMachine_GetFinalSymbolFunctionValue (TLispMachine*, TLispEntity*, TLispEntity**) ;

Boolean	lispMachine_SetCurrentSymbolValueWithNameA	(TLispMachine*, const char*, int, TLispEntity*) ;

#endif

