#if !defined (lmstate_h)
#define	lmstate_h

#define	LMSTATEPROTO(symbol)	TLMRESULT symbol (TLispMachine*)

/*	basic.kc */
LMSTATEPROTO (lispMachineState_Car) ;
LMSTATEPROTO (lispMachineState_Cdr) ;
LMSTATEPROTO (lispMachineState_Cons) ;
LMSTATEPROTO (lispMachineState_CarSafe) ;
LMSTATEPROTO (lispMachineState_Set) ;
LMSTATEPROTO (lispMachineState_Fset) ;
LMSTATEPROTO (lispMachineState_Eq) ;
LMSTATEPROTO (lispMachineState_Equal) ;
LMSTATEPROTO (lispMachineState_Null) ;
LMSTATEPROTO (lispMachineState_Numberp) ;
LMSTATEPROTO (lispMachineState_Integerp) ;
LMSTATEPROTO (lispMachineState_Floatp) ;
LMSTATEPROTO (lispMachineState_Stringp) ;
LMSTATEPROTO (lispMachineState_Consp) ;
LMSTATEPROTO (lispMachineState_Listp) ;
LMSTATEPROTO (lispMachineState_Vectorp) ;
LMSTATEPROTO (lispMachineState_Arrayp) ;
LMSTATEPROTO (lispMachineState_Sequencep) ;
LMSTATEPROTO (lispMachineState_Markerp) ;
LMSTATEPROTO (lispMachineState_IntegerOrMarkerp) ;
LMSTATEPROTO (lispMachineState_Subrp) ;
LMSTATEPROTO (lispMachineState_ByteCodeFunctionp) ;
LMSTATEPROTO (lispMachineState_Assoc) ;
LMSTATEPROTO (lispMachineState_Assq) ;
LMSTATEPROTO (lispMachineState_Memq) ;
LMSTATEPROTO (lispMachineState_Member) ;
LMSTATEPROTO (lispMachineState_Nthcdr) ;
LMSTATEPROTO (lispMachineState_Rassoc) ;
LMSTATEPROTO (lispMachineState_Nconc) ;
LMSTATEPROTO (lispMachineState_Append) ;
LMSTATEPROTO (lispMachineState_Throw) ;
LMSTATEPROTO (lispMachineState_Vconcat) ;
LMSTATEPROTO (lispMachineState_Nreverse) ;
LMSTATEPROTO (lispMachineState_Delete) ;
LMSTATEPROTO (lispMachineState_Delq) ;
LMSTATEPROTO (lispMachineState_Signal) ;
LMSTATEPROTO (lispMachineState_Setcar) ;
LMSTATEPROTO (lispMachineState_Setcdr) ;
LMSTATEPROTO (lispMachineState_Boundp) ;
LMSTATEPROTO (lispMachineState_DefaultValue) ;
LMSTATEPROTO (lispMachineState_SymbolValue) ;
LMSTATEPROTO (lispMachineState_Makunbound) ;
LMSTATEPROTO (lispMachineState_Fmakunbound) ;
LMSTATEPROTO (lispMachineState_Aref) ;
LMSTATEPROTO (lispMachineState_Aset) ;
LMSTATEPROTO (lispMachineState_Vector) ;
LMSTATEPROTO (lispMachineState_Princ) ;
LMSTATEPROTO (lispMachineState_Natnump) ;
LMSTATEPROTO (lispMachineState_Featurep) ;
LMSTATEPROTO (lispMachineState_Provide) ;

LMSTATEPROTO (lispMachineState_Eval) ;
LMSTATEPROTO (lispMachineState_Funcall) ;
LMSTATEPROTO (lispMachineState_Apply) ;
LMSTATEPROTO (lispMachineState_RunHooks) ;
LMSTATEPROTO (lispMachineState_Fboundp) ;
LMSTATEPROTO (lispMachineState_SymbolFunction) ;
LMSTATEPROTO (lispMachineState_Mapcar) ;
LMSTATEPROTO (lispMachineState_Evaluate) ;
LMSTATEPROTO (lispMachineState_EvalSymbol) ;
LMSTATEPROTO (lispMachineState_EvalCons) ;
LMSTATEPROTO (lispMachineState_ReturnOnly) ;

/*	let.c */
LMSTATEPROTO (lispMachineState_LetStar) ;
LMSTATEPROTO (lispMachineState_Let) ;

/*	lambda.c */
LMSTATEPROTO (lispMachineState_Lambda) ;
LMSTATEPROTO (lispMachineState_EvalLambdaForm) ;

/*	special.kc */
LMSTATEPROTO (lispMachineState_Done) ;
LMSTATEPROTO (lispMachineState_Identity) ;
LMSTATEPROTO (lispMachineState_Quote) ;
LMSTATEPROTO (lispMachineState_And) ;
LMSTATEPROTO (lispMachineState_Or) ;
LMSTATEPROTO (lispMachineState_If) ;
LMSTATEPROTO (lispMachineState_Cond) ;
LMSTATEPROTO (lispMachineState_While) ;
LMSTATEPROTO (lispMachineState_Catch) ;
LMSTATEPROTO (lispMachineState_ConditionCase) ;
LMSTATEPROTO (lispMachineState_Progn) ;
LMSTATEPROTO (lispMachineState_Prog1) ;
LMSTATEPROTO (lispMachineState_Prog2) ;
LMSTATEPROTO (lispMachineState_Setq) ;
LMSTATEPROTO (lispMachineState_SetqDefault) ;
LMSTATEPROTO (lispMachineState_Defun) ;
LMSTATEPROTO (lispMachineState_Defvar) ;
LMSTATEPROTO (lispMachineState_UnwindProtect) ;
LMSTATEPROTO (lispMachineState_SaveExcursion) ;
LMSTATEPROTO (lispMachineState_SaveRestriction) ;

/*	math.c */
LMSTATEPROTO (lispMachineState_Plus) ;
LMSTATEPROTO (lispMachineState_Minus) ;
LMSTATEPROTO (lispMachineState_Multiply) ;
LMSTATEPROTO (lispMachineState_Divide) ;
LMSTATEPROTO (lispMachineState_MathGreaterThan) ;
LMSTATEPROTO (lispMachineState_MathGreaterEqual) ;
LMSTATEPROTO (lispMachineState_MathLessThan) ;
LMSTATEPROTO (lispMachineState_MathLessEqual) ;
LMSTATEPROTO (lispMachineState_MathEqual) ;
LMSTATEPROTO (lispMachineState_1Plus) ;
LMSTATEPROTO (lispMachineState_1Minus) ;
LMSTATEPROTO (lispMachineState_Zerop) ;
LMSTATEPROTO (lispMachineState_Min) ;
LMSTATEPROTO (lispMachineState_Max) ;
LMSTATEPROTO (lispMachineState_Mod) ;
LMSTATEPROTO (lispMachineState_SlashEqual) ;

/*	string.kc */
LMSTATEPROTO (lispMachineState_String) ;
LMSTATEPROTO (lispMachineState_Concat) ;
LMSTATEPROTO (lispMachineState_StringEqual) ;
LMSTATEPROTO (lispMachineState_Mapconcat) ;
LMSTATEPROTO (lispMachineState_Substring) ;
LMSTATEPROTO (lispMachineState_Length) ;
LMSTATEPROTO (lispMachineState_StringToChar) ;
LMSTATEPROTO (lispMachineState_CharToString) ;
LMSTATEPROTO (lispMachineState_NumberToString) ;
LMSTATEPROTO (lispMachineState_Upcase) ;
LMSTATEPROTO (lispMachineState_Downcase) ;
LMSTATEPROTO (lispMachineState_Format) ;
LMSTATEPROTO (lispMachineState_TryCompletion) ;
LMSTATEPROTO (lispMachineState_MakeString) ;
LMSTATEPROTO (lispMachineState_ReadFromString) ;
LMSTATEPROTO (lispMachineState_StringToNumber) ;
LMSTATEPROTO (lispMachineState_CharCharset) ;
LMSTATEPROTO (lispMachineState_StringLessp) ;

/*	file.kc */
LMSTATEPROTO (lispMachineState_LoadFile) ;
LMSTATEPROTO (lispMachineState_Load) ;
LMSTATEPROTO (lispMachineState_ExpandFileName) ;
LMSTATEPROTO (lispMachineState_InsertFileContents) ;
LMSTATEPROTO (lispMachineState_FileNameNondirectory) ;
LMSTATEPROTO (lispMachineState_RenameFile) ;
LMSTATEPROTO (lispMachineState_DeleteFile) ;
LMSTATEPROTO (lispMachineState_FileModes) ;
LMSTATEPROTO (lispMachineState_SetFileModes) ;
LMSTATEPROTO (lispMachineState_WriteRegion) ;
LMSTATEPROTO (lispMachineState_FileExistsp) ;

/*	subr.kc	*/
LMSTATEPROTO (lispMachineState_Nth) ;
LMSTATEPROTO (lispMachineState_LocalSetKey) ;
LMSTATEPROTO (lispMachineState_Functionp) ;
LMSTATEPROTO (lispMachineState_MakeLocalHook) ;
LMSTATEPROTO (lispMachineState_AddHook) ;
LMSTATEPROTO (lispMachineState_Documentation) ;

LMSTATEPROTO (lispMachineState_Error) ;

/*	poem.c */
LMSTATEPROTO (lispMachineState_StringToCharList) ;

/*	queue-m.kc	*/
LMSTATEPROTO (lispMachineState_QueueCreate) ;
LMSTATEPROTO (lispMachineState_QueueAll) ;
LMSTATEPROTO (lispMachineState_QueueEnqueue) ;

/*	alist.c	*/
LMSTATEPROTO (lispMachineState_PutAlist) ;
LMSTATEPROTO (lispMachineState_ModifyAlist) ;
LMSTATEPROTO (lispMachineState_SetModifiedAlist) ;

/*	keymap.c	*/
LMSTATEPROTO (lispMachineState_MakeKeymap) ;
LMSTATEPROTO (lispMachineState_MakeSparseKeymap) ;
LMSTATEPROTO (lispMachineState_Keymapp) ;
LMSTATEPROTO (lispMachineState_LookupKey) ;
LMSTATEPROTO (lispMachineState_DefineKey) ;
LMSTATEPROTO (lispMachineState_CurrentMinorModeMaps) ;
LMSTATEPROTO (lispMachineState_UseLocalMap) ;
LMSTATEPROTO (lispMachineState_CurrentLocalMap) ;
LMSTATEPROTO (lispMachineState_CopyKeymap) ;
LMSTATEPROTO (lispMachineState_KeyBinding) ;

/*	buffer.c	*/
LMSTATEPROTO (lispMachineState_CurrentBuffer) ;
LMSTATEPROTO (lispMachineState_BufferString) ;
LMSTATEPROTO (lispMachineState_BufferSubstring) ;
LMSTATEPROTO (lispMachineState_Point) ;
LMSTATEPROTO (lispMachineState_PointMin) ;
LMSTATEPROTO (lispMachineState_PointMax) ;
LMSTATEPROTO (lispMachineState_PointMarker) ;
LMSTATEPROTO (lispMachineState_Bobp) ;
LMSTATEPROTO (lispMachineState_Eobp) ;
LMSTATEPROTO (lispMachineState_Eolp) ;
LMSTATEPROTO (lispMachineState_InsertChar) ;
LMSTATEPROTO (lispMachineState_Insert) ;
LMSTATEPROTO (lispMachineState_FollowingChar) ;
LMSTATEPROTO (lispMachineState_PrecedingChar) ;
LMSTATEPROTO (lispMachineState_SetBuffer) ;
LMSTATEPROTO (lispMachineState_SaveCurrentBuffer) ;
LMSTATEPROTO (lispMachineState_MakeLocalVariable) ;
LMSTATEPROTO (lispMachineState_MakeVariableBufferLocal) ;
LMSTATEPROTO (lispMachineState_LookingAt) ;
LMSTATEPROTO (lispMachineState_CharAfter) ;
LMSTATEPROTO (lispMachineState_CharAfter) ;
LMSTATEPROTO (lispMachineState_NarrowToRegion) ;
LMSTATEPROTO (lispMachineState_Widen) ;
LMSTATEPROTO (lispMachineState_GetBufferCreate) ;
LMSTATEPROTO (lispMachineState_GetBuffer) ;
LMSTATEPROTO (lispMachineState_EraseBuffer) ;
LMSTATEPROTO (lispMachineState_GenerateNewBufferName) ;
LMSTATEPROTO (lispMachineState_GenerateNewBuffer) ;
LMSTATEPROTO (lispMachineState_GetFileBuffer) ;
LMSTATEPROTO (lispMachineState_SetBufferModifiedp) ;
LMSTATEPROTO (lispMachineState_BufferModifiedp) ;

/*	edit.c	*/
LMSTATEPROTO (lispMachineState_SelfInsertCommand) ;
LMSTATEPROTO (lispMachineState_DeleteChar) ;
LMSTATEPROTO (lispMachineState_BackwardChar) ;
LMSTATEPROTO (lispMachineState_ForwardChar) ;
LMSTATEPROTO (lispMachineState_ForwardWord ) ;
LMSTATEPROTO (lispMachineState_BeginningOfLine) ;
LMSTATEPROTO (lispMachineState_EndOfLine) ;
LMSTATEPROTO (lispMachineState_ForwardLine) ;
LMSTATEPROTO (lispMachineState_DeleteBackwardChar) ;
LMSTATEPROTO (lispMachineState_DeleteRegion) ;
LMSTATEPROTO (lispMachineState_GotoChar) ;

/*	event.kc */
LMSTATEPROTO (lispMachineState_ReadEvent) ;
LMSTATEPROTO (lispMachineState_ReadChar) ;
LMSTATEPROTO (lispMachineState_ThisCommandKeys) ;

/*	stmarker.c */
LMSTATEPROTO (lispMachineState_MakeMarker) ;
LMSTATEPROTO (lispMachineState_SetMarker) ;
LMSTATEPROTO (lispMachineState_MarkerPosition) ;
LMSTATEPROTO (lispMachineState_MarkerBuffer) ;
LMSTATEPROTO (lispMachineState_MarkerInsertionType) ;
LMSTATEPROTO (lispMachineState_CopyMarker) ;

/*	wndproc.kc */
LMSTATEPROTO (lispMachineState_WindowProc) ;
LMSTATEPROTO (lispMachineState_Interactive) ;

/*	window.c */
LMSTATEPROTO (lispMachineState_WindowFrame) ;
LMSTATEPROTO (lispMachineState_WindowBuffer) ;
LMSTATEPROTO (lispMachineState_SelectedWindow) ;

/*	frame.c */
LMSTATEPROTO (lispMachineState_SelectedFrame) ;
LMSTATEPROTO (lispMachineState_MinibufferWindow) ;
LMSTATEPROTO (lispMachineState_FrameList) ;
LMSTATEPROTO (lispMachineState_MinibufferFrameList) ;

/*	interactive.kc */
LMSTATEPROTO (lispMachineState_Interactivep) ;
LMSTATEPROTO (lispMachineState_Commandp) ;
LMSTATEPROTO (lispMachineState_PrefixNumericValue) ;
LMSTATEPROTO (lispMachineState_CommandExecute) ;
LMSTATEPROTO (lispMachineState_CallInteractively) ;

/*	minibuf.c */
LMSTATEPROTO (lispMachineState_ReadString) ;
LMSTATEPROTO (lispMachineState_ExitRecursiveEdit) ;
LMSTATEPROTO (lispMachineState_AbortRecursiveEdit) ;
LMSTATEPROTO (lispMachineState_Message) ;
LMSTATEPROTO (lispMachineState_ReadFromMinibuffer) ;

/*	macro.c */
LMSTATEPROTO (lispMachineState_Defmacro) ;
LMSTATEPROTO (lispMachineState_EvalMacro) ;
LMSTATEPROTO (lispMachineState_Backquote) ;

/*	symbol.c */
LMSTATEPROTO (lispMachineState_Symbolp) ;
LMSTATEPROTO (lispMachineState_SymbolName) ;
LMSTATEPROTO (lispMachineState_MakeSymbol) ;
LMSTATEPROTO (lispMachineState_Intern) ;
LMSTATEPROTO (lispMachineState_InternSoft) ;
LMSTATEPROTO (lispMachineState_Unintern) ;
LMSTATEPROTO (lispMachineState_SymbolPlist) ;
LMSTATEPROTO (lispMachineState_Setplist) ;
LMSTATEPROTO (lispMachineState_Get) ;
LMSTATEPROTO (lispMachineState_Put) ;
LMSTATEPROTO (lispMachineState_PlistGet) ;
LMSTATEPROTO (lispMachineState_PlistPut) ;

/*	simple.c */
LMSTATEPROTO (lispMachineState_TransposeChars) ;
LMSTATEPROTO (lispMachineState_SetMark) ;
LMSTATEPROTO (lispMachineState_Mark) ;
LMSTATEPROTO (lispMachineState_CountLines) ;

/*	env.c */
LMSTATEPROTO (lispMachineState_Getenv) ;

/*	regex.c */
LMSTATEPROTO (lispMachineState_StringMatch) ;
LMSTATEPROTO (lispMachineState_ReSearchForward) ;
LMSTATEPROTO (lispMachineState_ReSearchBackward) ;
LMSTATEPROTO (lispMachineState_MatchBeginning) ;
LMSTATEPROTO (lispMachineState_MatchEnd) ;
LMSTATEPROTO (lispMachineState_MatchData) ;
LMSTATEPROTO (lispMachineState_SearchForward) ;
LMSTATEPROTO (lispMachineState_SearchBackward) ;
LMSTATEPROTO (lispMachineState_RegexpQuote) ;

/*	skk.c */
LMSTATEPROTO (lispMachineState_JSearchServer) ;
LMSTATEPROTO (lispMachineState_JOkuriSearchSubr) ;
LMSTATEPROTO (lispMachineState_JSearchJisyoFile) ;

/* misc.c */
LMSTATEPROTO (lispMachineState_Ding) ;
LMSTATEPROTO (lispMachineState_MakeCharacter) ;
LMSTATEPROTO (lispMachineState_CurrentTimeString) ;
LMSTATEPROTO (lispMachineState_SitFor) ;

/* im.c */
LMSTATEPROTO (lispMachineState_ImSendText) ;
LMSTATEPROTO (lispMachineState_ImSendEndConversion) ;
LMSTATEPROTO (lispMachineState_ImSendKey) ;

/* mutex.c */
LMSTATEPROTO (lispMachineState_Mutexp) ;
LMSTATEPROTO (lispMachineState_GetMutex) ;
LMSTATEPROTO (lispMachineState_GetMutexCreate) ;
LMSTATEPROTO (lispMachineState_MutualEval) ;

#undef	LMSTATEPROTO

#endif

