#include "AfxWin.h"
#include <stdio.h>
#include "lispmgrp.h"
#include "TFontSet.h"
#include "lmachinep.h"
#include "TTerminal.h"
#include "TFrame.h"

static	Boolean	lispMachine_updateFrame				(TLispMachine*, TLispEntity*) ;
static	Boolean	lispMachine_resizeNormalFrame		(TLispMachine*, TLispEntity*, const XRectangle*) ;
static	Boolean	lispMachine_activeFramep			(TLispMachine*, TLispEntity*) ;


Boolean
lispMachine_UpdateCurrentFrame (
	register TLispMachine*	pLM)
{
	assert (pLM != NULL) ;
	assert (pLM->m_pCurFrame != NULL) ;

	return	lispMachine_updateFrame (pLM, pLM->m_pCurFrame) ;
}

Boolean
lispMachine_UpdateAllFrame (
	register TLispMachine*	pLM)
{
	TLispEntity*	pEntFrame ;
	assert (pLM != NULL) ;

	pEntFrame	= pLM->m_lstFrame ;
	if (pEntFrame != NULL) {
		do {
			lispMachine_updateFrame (pLM, pEntFrame) ;
			lispFrame_GetNext (pEntFrame, &pEntFrame) ;
		}	while (pEntFrame != pLM->m_lstFrame) ;
	}
	return	True ;
}

void
lispMachine_ScheduleUpdateAllFrame (
	register TLispMachine*	pLM)
{
	register TLispManager*	pLispMgr ;
	register TLispEntity*	pEntFrame ;
	TLispEntity*			pEntNextFrame ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr != NULL) ;
	pEntFrame	= pLM->m_lstFrame ;

	if (pEntFrame != NULL) {
		do {
			lispFrame_ScheduleUpdate (pLispMgr, pEntFrame) ;
			lispFrame_GetNext (pEntFrame, &pEntNextFrame) ;
			pEntFrame	= pEntNextFrame ;
		}	while (pEntFrame != pLM->m_lstFrame) ;
	}
	return ;
}

Boolean
lispMachine_ResizeFrame (
	register TLispMachine*		pLM,
	register TLispEntity*		pEntFrame,
	register const XRectangle*	pRC)
{
	Widget	wgTerminal ;

	assert (pLM != NULL) ;
	assert (pEntFrame != NULL) ;

	if (TFAILED (lispFrame_GetTerminal (pEntFrame, &wgTerminal)))
		return	False ;
	if (TFrame_RectVariablep (wgTerminal)) {
		lispFrame_ScheduleUpdate (pLM->m_pLispMgr, pEntFrame) ;
		return	lispMachine_updateFrame (pLM, pEntFrame) ;
	} else {
		assert (pRC != NULL) ;
		return	lispMachine_resizeNormalFrame (pLM, pEntFrame, pRC) ;
	}
}	

/*	Frame ˤɽʸʤˤʤơեʤо
 *	ĤΤ롣(XUnmapWindow ưŪ˹Ԥ)
 *
 *	ΤȽäƤɤ롩 ΥեïäƤơ
 *	äƤ褤Ȥ
 */
Boolean
lispMachine_updateFrame (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntFrame)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	Widget					wgTerminal ;
	TLispEntity*			pEntTopWindow ;
	TLispEntity*			pEntWindow ;

	assert (pLispMgr  != NULL) ;
	assert (pEntFrame != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;

	if (TFAILED (lispFrame_GetTerminal (pEntFrame, &wgTerminal)))
		return	False ;
	if (TFAILED (lispFrame_NeedUpdatep (pLispMgr, pEntFrame)))
		return	True ;

	/*	б terminal ޤ clear ơ*/
	TFrame_Clear (wgTerminal) ;

	if (!TFrame_AutoPopupp (wgTerminal) ||
		TSUCCEEDED (lispMachine_activeFramep (pLM, pEntFrame))) {
		(void) lispFrame_GetTopWindow (pEntFrame, &pEntTopWindow) ;
		assert (pEntTopWindow != NULL) ;

		pEntWindow	= pEntTopWindow ;
		/*	Ȥ֤ (putchar?) Ƥäơ*/
		do {
			lispMachine_UpdateWindow (pLM, pEntFrame, pEntWindow) ;
			lispWindow_GetNext (pEntWindow, &pEntWindow) ;
		}	while (pEntWindow != pEntTopWindow) ;

		/*
		 *	Minibuffer Window  Frame ˴ޤޤƤȲꡣ
		 *	lispWindow_Update (pLispMgr, pFrame->m_pEntMinibufWindow) ;
		 */
	}

	TFrame_Flush (wgTerminal) ;
	return	True ;
}

/*	̥ե졼Υѹб롣ˤ Window ¤ФʤȲꤹ롣
 *	OverTheSpot, OffTheSpot ˤбǤʤ
 */
Boolean
lispMachine_resizeNormalFrame (
	register TLispMachine*		pLM,
	register TLispEntity*		pEntFrame,
	register const XRectangle*	pRC)
{
	register TLispManager*	pLispMgr	= pLM->m_pLispMgr ;
	register TLispEntity*	pEntWindow ;
	TLispEntity*			pEntTopWindow ;
	TLispEntity*			pEntNextWindow ;
	TLispEntity*			pEntMinibufWindow ;
	register Boolean		fMinibufExist, fMoveFocus ;
	register int			nWidth, nHeight ;
	register int			y, nFontHeight, nDelta, nWindow ;
	register int			nPrevHeight ;
	register TFontSet*		pFontSet ;
	XRectangle				rect, newRect ;
	Widget					wgTerminal ;
	
	assert (pLispMgr != NULL) ;
	assert (pEntFrame != NULL) ;

	nWidth	= pRC->width ;
	nHeight	= pRC->height ;
#if defined (DEBUG)
	fprintf (stderr, "lispMachine_ResizeNormalFrame (%p, %p, %d, %d)\n",
			 pLispMgr, pEntFrame, nWidth, nHeight) ;
#endif

	(void) lispFrame_GetTopWindow (pEntFrame, &pEntTopWindow) ;
	assert (pEntTopWindow != NULL) ;
	if (TFAILED (lispFrame_GetMinibufferWindow (pEntFrame, &pEntMinibufWindow)))
		pEntMinibufWindow	= NULL ;
	pEntWindow		= pEntTopWindow ;
	assert (pEntWindow != NULL) ;
	nPrevHeight		= 0 ;
	nWindow			= 0 ;
	fMinibufExist	= False ;
	do {
		lispWindow_GetArea (pEntWindow, &rect) ;
		nPrevHeight	+=	rect.height ;
		nWindow		++ ;
		if (pEntWindow == pEntMinibufWindow) 
			fMinibufExist	= True ;
		lispWindow_GetNext (pEntWindow, &pEntNextWindow) ;
		pEntWindow	= pEntNextWindow ;
	}	while (pEntWindow != pEntTopWindow) ;

	/*	礭ѹƤʤС⤹ɬפϤʤ
	 */
	nDelta		= nHeight - nPrevHeight ;
	if (nDelta == 0 && nWidth == rect.width) 
		return	True ;

	/*	Window 1Ĥ¸ߤʤСưƤɽ롣
	 */
	if (nWindow == 1) {
		newRect.x		= 0 ;
		newRect.y		= 0 ;
		newRect.width	= nWidth ;
		newRect.height	= nHeight ;
		lispWindow_SetArea (pEntTopWindow, &newRect) ;
		return	lispMachine_updateFrame (pLM, pEntFrame) ;
	}

	/*	Minibuffer Window δϳ
	 */
	if (fMinibufExist)
		nWindow	-- ;

	/*	եȤι⤵Ƥ
	 */
	(void) lispFrame_GetTerminal (pEntFrame, &wgTerminal) ;
	pFontSet	= TFrame_GetFontSet (wgTerminal) ;
	assert (pFontSet != NULL) ;
	nFontHeight	= pFontSet->m_iHeight ;
	assert (nFontHeight >= 1) ;

	/*	Window ʣˤϽ֤ˡ
	 */
	pEntWindow	= pEntTopWindow ;
	y			= 0 ;
	fMoveFocus	= False ;
	do {
		lispWindow_GetArea (pEntWindow, &rect) ;
		lispWindow_GetNext (pEntWindow, &pEntNextWindow) ;

		if (pEntWindow == pEntMinibufWindow) {
			newRect.x		= rect.x ;
			newRect.y		= rect.y ;
			newRect.width	= nWidth ;
			newRect.height	= rect.height ;
			lispWindow_SetArea (pEntWindow, &newRect) ;
			y				+= newRect.height ;
		} else {
			/*	Minibuffer Window ơ¾ Window ¸ߤǤˤϡ
			 *	ʤ᤮ Window Ͼõ롣
			 */
			if ((rect.height + nDelta) < nFontHeight * 2 && nWindow > 1) {
				nDelta			+= rect.height ;
				/*	ξä Window  Focus äƤˤϡ Window
				 *	 Focus ưɬפ롣
				 */
				if (TSUCCEEDED (lispWindow_HaveFocusp (pEntWindow)))
					fMoveFocus	= True ;
				lispFrame_RemoveWindow (pLispMgr, pEntFrame, pEntWindow) ;
				nWindow			-- ;
			} else {
				newRect.x		= rect.x ;
				newRect.y		= y ;
				newRect.width	= nWidth ;
				newRect.height	= rect.height + nDelta ;
				lispWindow_SetArea (pEntWindow, &newRect) ;
				nDelta			= 0 ;
				y				+= newRect.height ;

				/*	եΰưɬפ
				 */
				if (TSUCCEEDED (fMoveFocus)) {
					lispWindow_SetFocus (pEntWindow, True) ;
					fMoveFocus	= False ;
				}
			}
		}
#if defined (DEBUG)
		fprintf (stderr, "Window: (%d, %d, %d, %d), FontHeight: %d\n",
				 newRect.x, newRect.y, newRect.width, newRect.height, nFontHeight) ;
#endif
		pEntWindow		= pEntNextWindow ;
	}	while (pEntWindow != pEntTopWindow) ;

	return	lispMachine_updateFrame (pLM, pEntFrame) ;
}

/*	Active Frame ɤå롣
 */
Boolean
lispMachine_activeFramep (
	register TLispMachine*	pLM,
	register TLispEntity*	pEntFrame)
{
	register TLispManager*	pLispMgr ;
	TLispEntity*			pEntTopWindow ;
	TLispEntity*			pEntWindow ;
	TLispEntity*			pEntMsg ;

	assert (pLM != NULL) ;
	pLispMgr	= pLM->m_pLispMgr ;
	assert (pLispMgr  != NULL) ;
	assert (pEntFrame != NULL) ;
	assert (pEntFrame->m_iType == LISPENTITY_FRAME) ;

	/*	Current Frame ʤɽʤФʤʤ
	 */
	if (pEntFrame == pLM->m_pCurFrame)
		return	True ;

	/*	ǤʤΤʤ顢ɽ٤ΤäƤ뤫
	 *	å롣åäƤȤХåե
	 *	ǤʤȤ
	 */
	(void) lispFrame_GetTopWindow (pEntFrame, &pEntTopWindow) ;
	assert (pEntTopWindow != NULL) ;
	pEntWindow	= pEntTopWindow ;
	do {
		if (TSUCCEEDED (lispWindow_GetMessage (pEntWindow, &pEntMsg))) {
			const Char*		pString ;
			int				nString ;

			if (TSUCCEEDED (lispEntity_GetStringValue (pLispMgr, pEntMsg, &pString, &nString)) &&
				nString > 0) 
				return	True ;
		} else {
			TLispEntity*		pEntBuffer ;
			TBufStringMarker	mk ;
			int					nLength ;

			if (TSUCCEEDED (lispWindow_GetBuffer (pEntWindow, &pEntBuffer)) &&
				TSUCCEEDED (lispBuffer_GetFullString (pLispMgr, pEntBuffer, &mk, &nLength)) &&
				nLength > 0)
				return	True ;
		}
	}	while (pEntWindow != pEntTopWindow) ;

	return	False ;
}

