#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"

#define	lispEntity_GetMarkerPtr(ptr)	((TLispMarker *)((TLispEntity *)(ptr) + 1))

Boolean
lispMgr_CreateMarker (
	register TLispManager*			pLispMgr,
	register TLispEntity** const	ppReturn)
{
	TLispEntity*		pEntity ;
	register TLispMarker*		pMarker ;

	assert (pLispMgr    != NULL) ;
	assert (ppReturn != NULL) ;

#if defined (DEBUG_LV99)
	fprintf (stderr, "Garbage collecting ...") ;
	fflush (stderr) ;
	lispMgr_CollectGarbage (pLispMgr) ;
	fprintf (stderr, "done.\n") ;
#endif
	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, sizeof (TLispMarker), &pEntity)))
		return	False ;
	
	pEntity->m_iType			= LISPENTITY_MARKER ;
	pMarker						= lispEntity_GetMarkerPtr (pEntity) ;
	pMarker->m_fInsertionType	= False ;
	pMarker->m_pBuffer			= NULL ;
	pMarker->m_iPosition		= 0 ;
	pMarker->m_pPrevMarker		= NULL ;
	pMarker->m_pNextMarker		= NULL ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;

	*ppReturn	= pEntity ;
	return	True ;
}

void
lispMgr_DestroyMarker (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker)
{
	lispBuffer_RemoveMarker (pLispMgr, pEntMarker) ;
	return ;
}

Boolean
lispMarker_SetBufferPosition (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker,
	register TLispEntity*	pEntBuffer,
	register int			iPosition)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker					= lispEntity_GetMarkerPtr (pEntMarker) ;
	pMarker->m_pBuffer		= pEntBuffer ;
	pMarker->m_iPosition	= iPosition ;
	return	True ;
}

Boolean
lispMarker_SetInsertionType (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker,
	register Boolean			fInsertionType)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker						= lispEntity_GetMarkerPtr (pEntMarker) ;
	pMarker->m_fInsertionType	= fInsertionType ;
	return	True ;
}

Boolean
lispMarker_SetNext (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker,
	register TLispEntity*	pEntNextMarker)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker					= lispEntity_GetMarkerPtr (pEntMarker) ;
	pMarker->m_pNextMarker	= pEntNextMarker ;
	return	True ;
}

Boolean
lispMarker_SetPrevious (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker,
	register TLispEntity*	pEntPrevMarker)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker					= lispEntity_GetMarkerPtr (pEntMarker) ;
	pMarker->m_pPrevMarker	= pEntPrevMarker ;
	return	True ;
}

Boolean
lispMarker_GetInsertionType (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker,
	register Boolean*			pfTypeRet)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	assert (pfTypeRet     != NULL) ;
	
	pMarker		= lispEntity_GetMarkerPtr (pEntMarker) ;
	*pfTypeRet	= pMarker->m_fInsertionType ;
	return	True ;
}

Boolean
lispMarker_GetBufferPosition (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntMarker,
	register TLispEntity** const	ppBufferReturn,
	register int* const				piPositionReturn)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker		= lispEntity_GetMarkerPtr (pEntMarker) ;
	if (ppBufferReturn != NULL)
		*ppBufferReturn		= pMarker->m_pBuffer ;
	if (piPositionReturn != NULL)
		*piPositionReturn	= pMarker->m_iPosition ;
	return	True ;
}

Boolean
lispMarker_GetNext (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntMarker,
	register TLispEntity** const	ppReturn)
{
	register TLispMarker*	pMarker ;

	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	assert (ppReturn	  != NULL) ;
	
	pMarker		= lispEntity_GetMarkerPtr (pEntMarker) ;
	*ppReturn	= pMarker->m_pNextMarker ;
	return	True ;
}

Boolean
lispMarker_GetPrevious (
	register TLispManager*			pLispMgr,
	register TLispEntity*			pEntMarker,
	register TLispEntity** const	ppReturn)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	assert (ppReturn	  != NULL) ;
	
	pMarker		= lispEntity_GetMarkerPtr (pEntMarker) ;
	*ppReturn	= pMarker->m_pPrevMarker ;
	return	True ;
}

/*
 *	Хåե nPosition ΰ֤ nCount ʸ줿
 *	ޡΰư¸롣
 */
Boolean
lispMarker_MoveWithInsertion (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker,
	register int			nPosition,
	register int			nCount)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker		= lispEntity_GetMarkerPtr (pEntMarker) ;
	assert (pMarker->m_pBuffer != NULL) ;

#if defined (DEBUG_LV99)
	fprintf (stderr, "Marker (%d, %d), Pos(%d), Count(%d) -->",
			 pMarker->m_iPosition, pMarker->m_fInsertionType,
			 nPosition, nCount) ;
#endif
	if ((nPosition < pMarker->m_iPosition) ||
		(nPosition == pMarker->m_iPosition && pMarker->m_fInsertionType)) {
		pMarker->m_iPosition	+= nCount ;
#if defined (DEBUG_LV99)
		fprintf (stderr, "move (%d)\n", pMarker->m_iPosition) ;
	} else {
		fprintf (stderr, "nomove\n", pMarker->m_iPosition) ;
#endif
	}
	return	True ;
}

Boolean
lispMarker_MoveWithDeletion (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker,
	register int			nPosition,
	register int			nCount)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker		= lispEntity_GetMarkerPtr (pEntMarker) ;
	assert (pMarker->m_pBuffer != NULL) ;

	if (nPosition < pMarker->m_iPosition) {
		pMarker->m_iPosition	-= nCount ;
		if (pMarker->m_iPosition < nPosition)
			pMarker->m_iPosition	= nPosition ;
	}
	return	True ;
}

Boolean
lispMarker_Print (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntMarker)
{
	register TLispMarker*	pMarker ;
	
	assert (pLispMgr      != NULL) ;
	assert (pEntMarker != NULL) ;
	
	pMarker		= lispEntity_GetMarkerPtr (pEntMarker) ;
	fprintf (stderr, "(buffer/position/type: %lx/%d/%s)",
			 (unsigned long)pMarker->m_pBuffer,
			 pMarker->m_iPosition,
			 (pMarker->m_fInsertionType)? "true" : "false") ;
	return	True ;
}



