#if !defined (lispmachine_h)
#define	lispmachine_h

#include "lispmgrp.h"
#include "vstack.h"

typedef enum {
	LMR_ERROR,
	LMR_FATALERROR,
	LMR_SUSPEND,
	LMR_CONTINUE,
	LMR_RETURN,
	LMR_TICK,
	LMR_DONE,
	LMR_DESTROYED,	/* LispMachine ˴줿ʸ塢pLM λѤ϶ػߡ*/
}	TLMRESULT ;

typedef enum {
	LMEVENT_INVALID	= -1,
	LMEVENT_KEYPRESS,
	LMEVENT_FRAMERESIZE,
}	TLMEVENT ;

struct tagTLispMachine ;
struct tagTLispEntity ;
struct tagTLispBind ;

typedef struct tagTLispMachine	TLispMachine ;

/*	Prototypes */
Boolean			TLispMachine_Create				(TLispManager*, TLispMachine*, TLispMachine** const) ;
Boolean			TLispMachine_Destroy			(TLispMachine*) ;
TLMRESULT		TLispMachine_Test				(TLispMachine*, struct tagTLispEntity*) ;
Boolean			TLispMachine_EventProc			(TLispMachine*, int, void*, void*) ;
TLispManager*	TLispMachine_GetLispManager		(TLispMachine*) ;

#endif

