#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lispmgrp.h"
#include "limclient.h"

#define	lispEntity_GetIMClientPtr(ptr)	((TLispIMClient*)((TLispEntity *)(ptr) + 1))

Boolean
lispMgr_CreateIMClient (
	register TLispManager*			pLispMgr,
	register void*					pvClient,
	register void					(*pKeyNotify)(),
	register void					(*pTextNotify)(),
	register void					(*pEndNotify)(),
	register TLispEntity** const	ppEntReturn)
{
	TLispEntity*			pEntity ;
	register TLispIMClient*	pIMClient ;
	register size_t			nSize ;

	assert (pLispMgr    != NULL) ;
	assert (pvClient    != NULL) ;
	assert (ppEntReturn != NULL) ;

	nSize	= sizeof (TLispIMClient) ;
	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, nSize, &pEntity)))
		return	False ;

	pEntity->m_iType		= LISPENTITY_IMCLIENT ;
	pEntity->m_lReferCount	= 0 ;
	pIMClient				= lispEntity_GetIMClientPtr (pEntity) ;
	pIMClient->m_pvClient		= pvClient ;
	pIMClient->m_pKeyNotify		= pKeyNotify ;
	pIMClient->m_pTextNotify	= pTextNotify ;
	pIMClient->m_pEndNotify		= pEndNotify ;
	lispMgr_RegisterMisc (pLispMgr, pEntity) ;

	*ppEntReturn	= pEntity ;
	return	True ;
}

void
lispIMClient_Destroy (
	register TLispEntity*	pEntity)
{
	return ;
}

Boolean
lispIMClient_KeyNotify (
	register TLispEntity*	pEntity,
	register TXEvent*		pEv)
{
	register TLispIMClient*	pIMClient ;

	assert (pEntity != NULL) ;

	pIMClient	= lispEntity_GetIMClientPtr (pEntity) ;
	assert (pIMClient->m_pvClient != NULL) ;
	/*	XEvent ˡˤĤƹͻʤС⤷
	 *	ǤʤΤʤ顢ФƤʤ*/
	(pIMClient->m_pKeyNotify)(pIMClient->m_pvClient, pEv) ;
	return	True ;
}

Boolean
lispIMClient_TextNotify (
	register TLispEntity*	pEntity,
	register const Char*	pText,
	register int			nText)
{
	register TLispIMClient*	pIMClient ;

	assert (pEntity != NULL) ;

	if (pText != NULL && nText > 0) {
		pIMClient	= lispEntity_GetIMClientPtr (pEntity) ;
		assert (pIMClient->m_pvClient != NULL) ;
		(pIMClient->m_pTextNotify)(pIMClient->m_pvClient, pText, nText) ;
	}
	return	True ;
}

Boolean
lispIMClient_EndNotify (
	register TLispEntity*	pEntity)
{
	register TLispIMClient*	pIMClient ;

	assert (pEntity != NULL) ;

	pIMClient	= lispEntity_GetIMClientPtr (pEntity) ;
	(pIMClient->m_pEndNotify)(pIMClient->m_pvClient) ;
	return	True ;
}




