#if !defined (ltype_h)
#define	ltype_h

#include "local.h"
#include "lispmgr.h"
#include "lbind.h"
#include "lbuffer.h"
#include "lmarker.h"
#include "lframe.h"
#include "lwindow.h"

/*
 *	ƥƥμ(type-of ֤)
 */
typedef enum {
	LISPENTITY_BAD		= -1,	/*  entity */
	LISPENTITY_INTEGER	= 0,	/* */
	LISPENTITY_FLOAT,
	LISPENTITY_CONSCELL,
	LISPENTITY_VECTOR,
	LISPENTITY_STRING,
	LISPENTITY_SYMBOL,
	LISPENTITY_MARKER,
	LISPENTITY_BUFFER,
	LISPENTITY_WINDOW,
	LISPENTITY_FRAME,
	LISPENTITY_SUBR,
	LISPENTITY_IMCLIENT,
	LISPENTITY_MUTEX,
	LISPENTITY_XEVENT,
	LISPENTITY_EMPTY,
	LISPENTITY_VOID,
	LISPENTITY_BOOLVECTOR,	/* bool vector(bit vector) (̤) */
	LISPENTITY_CHARTABLE,	/* char-table () (̤) */
	MAX_LISPENTITY,
}	LISPENTITYTYPE ;

/*	̤ʬϴޤޤʤ褦ꡣ*/
#define	MAX_LISPENTITY_TYPE	(LISPENTITY_VOID + 1)

enum {
	LISPFRAMETYPE_NORMAL	= 0,
	LISPFRAMETYPE_ROOTWINDOW,
	LISPFRAMETYPE_OVERTHESPOT,
	LISPFRAMETYPE_OFFTHESPOT,
} ;

/*
 *	ƥƥΥǡ¤
 *	 + 0
 *	struct tagTLispEntity   
 *	 + sizeof (struct tagTLispEntity)
 *	 Entity ͭΥǡ  
 *	
 */
struct tagTLispEntity {
	LISPENTITYTYPE			m_iType ;
	long					m_lReferCount ;	/* ȥ󥿡*/
	int						m_iMarker ;
	struct tagTLispEntity*	m_pLeft ;
	struct tagTLispEntity*	m_pRight ;
} ;

struct tagTLispConscell {
	struct tagTLispEntity*	m_pCar ;
	struct tagTLispEntity*	m_pCdr ;
} ;

struct tagTLispVector {
	int						m_nElement ;
	struct tagTLispEntity*	m_apElement [1] ;
} ;

struct tagTLispString {
	int						m_nLength ;
	Char					m_achString [1] ;
} ;

struct tagTLispSymbol {
	struct tagTLispEntity*	m_pParent ;
	int						m_nLength ;
	Char					m_achName [1] ;
} ;

struct tagTLispBoolVector {
	int						m_nLength ;
	unsigned int			m_auBitArray [1] ;
} ;

struct tagTLispMutex {
	unsigned int			m_uLockCount ;
	void*					m_pOwner ;
	int						m_nLength ;
	Char					m_achString [1] ;
} ;

struct tagTLispXEventInt {
	struct tagTLispEntity*	m_pEntValue ;
	XEvent					m_evX ;
} ;

struct tagLMCMDINFO ;

typedef struct tagTLispConscell		TLispConscell ;
typedef struct tagTLispVector		TLispVector ;
typedef struct tagTLispString		TLispString ;
typedef struct tagTLispSymbol		TLispSymbol ;
typedef struct tagTLispEntity		TLispEntity ;
typedef struct tagTLispSubr			TLispSubr ;
typedef struct tagTLispMutex		TLispMutex ;
typedef struct tagTLispXEventInt	TLispXEventInt ;

#define	TLispEntity_GetValue(ptr)	((struct tagTLispEntity *)(ptr) + 1)

#endif

