#if !defined (lispbuffer_h)

#include "varbuffer.h"
#include "bufstring.h"

enum {
	MARKER_BTOP				= 0,
	MARKER_ETOP,
	MARKER_POINT,
	MARKER_ELAST,
	MARKER_BLAST,
	MARKER_MARK,		/* MARK ¸ߤƤʤ礬롣*/
	NUM_BUFFER_MUST_MARKERS,
} ;

enum {
	SIZE_LISP_BIND_TABLE	= 37,
	MAX_BUFFER_TEXT			= 256,
} ;

struct tagTLispBind ;
struct tagTLispEntity ;

/*
 *	m_pEntName:		Хåե̾
 *	m_pEntKeymap:	Хåե˳դƤ륭ޥåס
 */
struct tagTLispBuffer {
	struct tagTLispBind*	m_apVariableTable [SIZE_LISP_BIND_TABLE] ;
	TBufString				m_Text ;
	Boolean					m_fModified ;
	int						m_nTick ;
	struct tagTLispEntity*	m_pEntName ;
	struct tagTLispEntity*	m_pEntKeymap ;
	struct tagTLispEntity*	m_apMustMarkers [NUM_BUFFER_MUST_MARKERS] ;
	struct tagTLispEntity*	m_lstMarkers ;
	struct tagTLispEntity*	m_pNextBuffer ;
	struct tagTLispEntity*	m_pPrevBuffer ;
} ;

typedef struct tagTLispBuffer	TLispBuffer ;

#endif

