#if !defined (lispbind_h)
#define	lispbind_h

#include "lispmgr.h"

struct tagTLispEntity ;
struct tagTLispBind {
	struct tagTLispEntity*	m_pEntSymbol ;
	struct tagTLispEntity*	m_pEntValue ;
	struct tagTLispBind*	m_pLeft ;
	struct tagTLispBind*	m_pRight ;
} ;

typedef struct tagTLispBind		TLispBind ;

/*	Prototype */
Boolean	lispBind_Create					(TLispManager*, struct tagTLispEntity*, TLispBind**) ;
Boolean	lispBind_Destroy				(TLispManager*, TLispBind*) ;
Boolean	lispBind_GetValue				(TLispBind*, struct tagTLispEntity** const) ;
Boolean	lispBind_SetValue				(TLispManager*, TLispBind*, struct tagTLispEntity*) ;
/*Boolean	lispBind_Search				(TLispBind*, struct tagTLispEntity*, TLispBind** const, TLispBind** const) ;*/
Boolean	lispBind_Register				(TLispBind** const, TLispBind*) ;
Boolean	lispBind_Unregister				(TLispBind** const, TLispBind*) ;

Boolean	lispBindTable_Destroy			(TLispManager*, TLispBind** const, int) ;
Boolean	lispBindTable_MakeEntry			(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, TLispBind** const) ;
Boolean	lispBindTable_SetEntryValue		(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, struct tagTLispEntity*) ;
Boolean	lispBindTable_GetEntryValue		(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, struct tagTLispEntity** const) ;
Boolean	lispBindTable_SearchEntry		(TLispManager*, TLispBind** const, int, struct tagTLispEntity*, TLispBind** const) ;

#endif

