#if !defined (TLispClient_h)
#define	TLispClient_h

#include "lmachine.h"
#include "lispmgr.h"

/*
 *	LispMachine  Client ñ̤Ǥ¸ߤʤ
 *	Frame ̤ Client ñ̤¸ߤȤ櫓ǤϤʤ
 *	Minibuffer Window Ȥ Frame Ϥ줾졣
 */
struct tagTLispClient {
	struct tagTLispMachine*	m_pLM ;		/* Lisp Machine */
	Boolean					m_fModify ;
	struct tagTLispClient*	m_pNext ;
} ;

typedef	struct tagTLispClient	TLispClient ;

typedef struct tagTLispClientArg {
	TLispManager*	m_pLispMgr ;
	TLispMachine*	m_pLM ;
	void*			m_pvClient ;
	void			(*m_pKeyNotify)() ;
	void			(*m_pTextNotify)() ;
	void			(*m_pEndNotify)() ;
	Widget			m_wgFrame ;
	Widget			m_wgMinibufFrame ;
}	TLispClientArg ;

void	TLispClient_MainLoop			(XtAppContext, TLispMachine*) ;
Boolean	TLispClient_ClassInitialize		(TLispManager**, TLispMachine**, const char*, const char*, int) ;
void	TLispClient_ClassFinalize		(TLispMachine*) ;
void	TLispClient_PreInitialize 		(TLispClient*) ;
Boolean	TLispClient_Initialize 			(TLispClient*, TLispClientArg*) ;
void	TLispClient_Uninitialize 		(TLispClient*) ;
void	TLispClient_Reinitialize		(TLispClient*) ;
Boolean	TLispClient_Tick				(TLispClient*) ;
Boolean	TLispClient_Modifiedp			(TLispClient*) ;
void	TLispClient_Activate			(TLispClient*, Boolean) ;
void	TLispClient_SetModificationFlag	(TLispClient*, Boolean) ;

#endif

