#if !defined (kanji_h)
#define	kanji_h

#include "charset.h"
#include "Char.h"

/*========================================================================*
 *	
 *========================================================================*/
/*
 *	ǥ󥰥ƥࡣ
 */
enum {
	KCODING_SYSTEM_UNKNOWN		= -1,
	KCODING_SYSTEM_EUCJP		= 0,
	KCODING_SYSTEM_ISO2022JP2,
	KCODING_SYSTEM_SHIFTJIS,
	KCODING_SYSTEM_UNICODE,
	KCODING_SYSTEM_BINARY,
	MAX_KCODING_SYSTEM,
} ;

/*
 *	ԥɡ
 */
enum {
	KNEWLINE_UNKNOWN	= -1,
	KNEWLINE_UNIX		= 0,	/* 0x0A */
	KNEWLINE_MSDOS,				/* 0x0D 0x0A */
	KNEWLINE_MAC,				/* 0x0D */
} ;

/*========================================================================*
 *	ޥ
 *========================================================================*/

#define IS_SHIFTJIS_2BYTE_CODE1(c)		(((((unsigned char)c) >= 0x81 && ((unsigned char)c) <= 0x9F) || (((unsigned char)c) >= 0xE0 && ((unsigned char)c) <= 0xEF))? TRUE : FALSE)
#define IS_SHIFTJIS_2BYTE_CODE2(c)		(((((unsigned char)c) >= 0x40 && ((unsigned char)c) <= 0x7E) || (((unsigned char)c) >= 0x80 && ((unsigned char)c) <= 0xFC))? TRUE : FALSE)
#define IS_SHIFTJIS_JISX201_KATAKANA(c)	((((unsigned char)c) >= 0xA1 && ((unsigned char)c) <= 0xDF)? TRUE : FALSE)

#define	KANJICODE_CODINGSYSTEM(kcode)	((short)(kcode & 0x0000FFFFl))
#define	KANJICODE_NEWLINETYPE(kcode)	(((short)(kcode >> 16) & 0x0000FFFFl))
#define	KANJICODE_MAKE(iCS,iNT)			((KANJICODE)((((unsigned long)iCS) & 0x0000FFFFl) | ((((unsigned long)iNT) & 0x0000FFFFl) << 16)))


/*========================================================================*
 *	
 *========================================================================*/

/*========================================================================*
 *	¤Ρ
 *========================================================================*/
/*
 *	ISO2022 ϾܵΡ־֡
 */
typedef struct tagISO2022STATE {
	BOOL		m_fEscapeSequence ;
	int			m_iEscapeState ;
	BOOL		m_fSingleShift ;
	int			m_iLeadChara ;
	int			m_iCharset [4] ;
	int			m_iGL [2] ;
	int			m_iGR [2] ;
}	ISO2022STATE, *PISO2022STATE ;

/*
 *	Microsoft ɲϾֵΡ־֡
 */
typedef struct tagSHIFTJISSTATE {
	int			m_iLeadChara ;
}	SHIFTJISSTATE, *PSHIFTJISSTATE ;

/*
 *	ɲϤΤξܵ
 */
typedef struct tagKANJISTATEMACHINE {
	/*
	 *	ƽԤˤäƺƽ˻Ȥ
	 */
	int			(*m_pRestartFunc)(struct tagKANJISTATEMACHINE*) ;

	/*
	 *	ɤѴ˻Ȥܡ״ؿ
	 */
	int			(*m_pTransferFunc)(struct tagKANJISTATEMACHINE*, int iChara, Char* pOutput) ;

	/*
	 *	ɤѴ˻Ȥܡ״ؿ
	 */
	int			(*m_pRtransferFunc)(struct tagKANJISTATEMACHINE*, Char cc, char* pOutput) ;

	/*
	 *	֡ȤɤѴѤ롣
	 */
	union {
		ISO2022STATE	m_iso2022 ;
		SHIFTJISSTATE	m_shiftjis ;
	}	m_state ;

}	KANJISTATEMACHINE, *PKANJISTATEMACHINE ;

/*========================================================================*
 *	ץȥ
 *========================================================================*/
int		DetectKanjiCodingSystem				(const char* pBytes, int nBytes, int* pNewlineType) ;
int		InitializeKanjiFiniteStateMachine 	(PKANJISTATEMACHINE pKSM, int iCodingSystem) ;
int		RestartKanjiFiniteStateMachine		(PKANJISTATEMACHINE pKSM) ;
int		TransferKanjiFiniteStateMachine		(PKANJISTATEMACHINE pKSM, int iChara, Char* pOutput) ;
int		RtransferKanjiFiniteStateMachine	(PKANJISTATEMACHINE pKSM, Char cc, char* pOutput) ;

#endif

