#if !defined (filebuf_h)
#define	filebuf_h

#include "Char.h"
#include "kanji.h"

/*========================================================================*
 *	L萔B
 *========================================================================*/
#define	FILEBUF_SIZE	(64)

/*========================================================================*
 *	^̒`B
 *========================================================================*/

typedef struct {
	FILE*				m_fp ;
	KANJISTATEMACHINE	m_ksm ;
	Char				m_aiBuffer [FILEBUF_SIZE] ;
	int					m_iHead ;
	int					m_iUsage ;
}	FILEBUF ;

typedef FILEBUF	*PFILEBUF ;

/*========================================================================*
 *	vg^Cv錾B
 *========================================================================*/

int		FileBuf_Init (PFILEBUF pfbuf, FILE* fp, int iCodingSystem) ;
int		FileBuf_GetHead (PFILEBUF pfbuf) ;
int		FileBuf_GetUsage (PFILEBUF pfbuf) ;
Char	FileBuf_BufferedGetc (PFILEBUF pfbuf) ;
Char	FileBuf_Getc (PFILEBUF pfbuf) ;
int		FileBuf_Ungetc (PFILEBUF pfbuf, Char cc) ;
int		FileBuf_MoveHead (PFILEBUF pfbuf, int iHead) ;

#endif

