#include "sysdep.h"
#include <stdio.h>
#include <assert.h>
#include "filebuf.h"

/*========================================================================*
 *	ץȥ
 *========================================================================*/

static	Char	FileBuf_getc (PFILEBUF pfbuf) ;

/*========================================================================*
 *	Хؿ
 *========================================================================*/

int
FileBuf_Init (PFILEBUF pfbuf, FILE* fp, int iCodingSystem)
{
	assert (pfbuf != NULL) ;
	assert (fp != NULL) ;

	InitializeKanjiFiniteStateMachine (&pfbuf->m_ksm, iCodingSystem) ;
	pfbuf->m_fp		= fp ;
	pfbuf->m_iHead	= 0 ;
	pfbuf->m_iUsage	= 0 ;
	return	0 ;
}

/*
 *	ǴƤХåեΥإåɰ֤֤
 *()
 *	եɤߤ򤷤ˡХåեΥإåɰ֤Ѥ
 *	ᤷϤ롣ʤ顢fseek ǤʤǤбǽ
 */
int
FileBuf_GetHead (PFILEBUF pfbuf)
{
	assert (pfbuf != NULL) ;
	return	pfbuf->m_iHead ;
}

/*
 *	ǴƤХåեλѾ֤
 */
int
FileBuf_GetUsage (PFILEBUF pfbuf)
{
	assert (pfbuf != NULL) ;
	return	pfbuf->m_iUsage ;
}

/*
 *	ХåեؤƤʳǤϼºݤ˥ե뤫ɤळȤ
 *	ʤХåեκǸޤɤڤäʳǥե뤫ɤ
 *	Ф
 *	ޤǤϡFileBuf_Getc Ʊưե뤫ɤ߹
 *	ɬХåե˥ԡĤȤ㤦
 */
Char
FileBuf_BufferedGetc (PFILEBUF pfbuf)
{
	assert (pfbuf != NULL) ;
	assert (pfbuf->m_fp != NULL) ;
	assert (pfbuf->m_iHead <= pfbuf->m_iUsage) ;

	if (pfbuf->m_iHead == pfbuf->m_iUsage) {
		Char	ch ;

		ch	= FileBuf_getc (pfbuf) ;
		pfbuf->m_aiBuffer [pfbuf->m_iUsage ++]	= ch ;
	}
	return	pfbuf->m_aiBuffer [pfbuf->m_iHead ++] ;
}

/*
 *	ХåեؤƤʳǤϼºݤ˥ե뤫ɤळȤ
 *	ʤХåեκǸޤɤڤäʳǥե뤫ɤ
 *	Ф
 */
Char
FileBuf_Getc (PFILEBUF pfbuf)
{
	Char	ch ;

	assert (pfbuf != NULL) ;
	assert (pfbuf->m_fp != NULL) ;
	assert (0 <= pfbuf->m_iHead && pfbuf->m_iHead <= pfbuf->m_iUsage) ;
	assert (0 <= pfbuf->m_iUsage) ;

	if (pfbuf->m_iHead < pfbuf->m_iUsage) {
		ch	= pfbuf->m_aiBuffer [pfbuf->m_iHead ++] ;
		if (pfbuf->m_iHead == pfbuf->m_iUsage) {
			pfbuf->m_iHead	= 0 ;
			pfbuf->m_iUsage	= 0 ;
		}
	} else {
		ch	= FileBuf_getc (pfbuf) ;
	}
	return	ch ;
}

int
FileBuf_Ungetc (PFILEBUF pfbuf, Char cc)
{
	assert (pfbuf != NULL) ;

	if (pfbuf->m_iUsage >= FILEBUF_SIZE)
		return	-1 ;

	pfbuf->m_aiBuffer [pfbuf->m_iUsage ++]	= cc ;
	return	0 ;
}

int
FileBuf_MoveHead (PFILEBUF pfbuf, int iHead)
{
	assert (pfbuf != NULL) ;

	if (iHead < 0 || iHead > pfbuf->m_iUsage)
		return	-1 ;

	pfbuf->m_iHead	= iHead ;
	return	0 ;
}

/*========================================================================*
 *	ؿ
 *========================================================================*/

Char
FileBuf_getc (PFILEBUF pfbuf)
{
	int		iRet ;
	int		iChara ;
	Char	ch ;

	do {
		iChara	= getc (pfbuf->m_fp) ;
		iRet	= TransferKanjiFiniteStateMachine (&pfbuf->m_ksm, iChara, &ch) ;
	} while (iRet <= 0 && iChara != EOF) ;

	if (iChara == EOF)
		return	(Char)EOF ;

	return	ch ;
}

