#ifndef Char_h
#define Char_h

#include "charset.h"

/*========================================================================*
 *	}N̒`B
 *========================================================================*/

#define	CHAR_CHARSET(cc)			(((cc) >> 24) & 0x7F)
#define	CHAR_CODE(cc)				((cc) & 0xFFFF)

#define	Char_IsEqual(chl,chr)		(!Char_Difference ((chl), (chr)))
#define	Char_IsEqualAscii(chl,chr)	(!Char_DifferenceAscii ((chl), (chr)))

/*========================================================================*
 *	^`B
 *========================================================================*/

/*
 *	^Brbg̎gpԂ͎̒ʂB
 *		
 *		3130 .. 2423 .. 1615 ... 0
 *		
 *		󄫕              
 *		    W        R[h
 *		
 */
typedef unsigned long	Char ;

/*========================================================================*
 *	vg^Cv錾B
 *========================================================================*/

Char	Char_Make (int nSet, int nCode) ;
Char	Char_MakeAscii (char ch) ;
int		Char_IsAscii (Char cc) ;
int		Char_IsNul (Char cc) ;
int		Char_Is2ByteChara (Char cc) ;
int		Char_DifferenceAscii (Char cc, char ch) ;
int		Char_Difference (Char chLeft, Char chRight) ;
Char	Char_ToLower (Char cc) ;
Char	Char_ToUpper (Char cc) ;

#endif
